/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.expressionevaluator.viewcapturepoint;

import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.expressionevaluator.viewcapturepoint.ViewCapturePointPanel;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.swing.api.Component;

public class ViewCapturePointElement
extends AbstractElement
implements Element.SimpleElement,
Element.CalculatedElement {
    private ViewCapturePointPanel aditionalPanel;

    public ViewCapturePointElement() {
        super(ToolsLocator.getI18nManager().getTranslation("_Capture_point"), null, "expressionbuilder-element-view-capture-point");
    }

    public Object getValue() {
        if (this.aditionalPanel == null) {
            return null;
        }
        try {
            Geometry geom = this.aditionalPanel.getGeometry();
            if (geom == null) {
                return null;
            }
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            if (this.aditionalPanel.insertAsWKT()) {
                if (this.aditionalPanel.insertAsGeometry()) {
                    builder.geometry_support_type(GeometryExpressionBuilderHelper.GeometrySupportType.WKT);
                    return builder.geometry(geom, geom.getProjection()).toString();
                }
                String wkt = geom.convertToWKT();
                return "'" + wkt + "'";
            }
            if (this.aditionalPanel.insertAsGeometry()) {
                builder.geometry_support_type(GeometryExpressionBuilderHelper.GeometrySupportType.WKB);
                return builder.geometry(geom, geom.getProjection()).toString();
            }
            byte[] wkb = geom.convertToWKB();
            return builder.bytearray_hex(wkb);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get point value.", (Throwable)ex);
            return null;
        }
    }

    public String getRenderedValue() {
        Object v = this.getValue();
        if (v == null) {
            return super.getRenderedValue();
        }
        return v.toString();
    }

    public Component getAditionalPanel(JExpressionBuilder expressionBuilder) {
        if (this.aditionalPanel == null) {
            this.aditionalPanel = new ViewCapturePointPanel();
        }
        return this.aditionalPanel;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        return !application.getUIManager().isModalDialogShowing();
    }
}

