/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.view.legend.gui.AbstractThemeManagerPage;
import org.gvsig.app.project.documents.view.legend.gui.ThemeManagerWindow;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThemeManagerWindowNew
extends JPanel
implements IWindow,
ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(ThemeManagerWindow.class);
    private static final long serialVersionUID = 4650656815369149211L;
    private static int selectedTabIndex = 0;
    private static ArrayList<Class<? extends AbstractThemeManagerPage>> pages = new ArrayList();
    private FLayer layer;
    private JTabbedPane tabs = new JTabbedPane();
    private JPanel panelButtons;
    private static Hashtable<Class<? extends AbstractThemeManagerPage>, ArrayList<Class<? extends FLayer>>> s = new Hashtable();

    public ThemeManagerWindowNew(FLayer l) {
        this.layer = l;
        this.initialize();
    }

    private void initialize() {
        StringBuffer msgerr = new StringBuffer();
        for (int i = 0; i < pages.size(); ++i) {
            Class<? extends AbstractThemeManagerPage> pageClass = pages.get(i);
            AbstractThemeManagerPage tab = null;
            try {
                tab = pageClass.newInstance();
            }
            catch (Exception e) {
                msgerr.append(this.translate("_Cant_add_property_page_related_to_{0}", pageClass.getName())).append("\n");
                logger.info("Can't instance propety page from class " + pageClass.getName(), (Throwable)e);
                continue;
            }
            if (tab == null || !tab.isTabEnabledForLayer(this.layer)) continue;
            String tabName = null;
            try {
                tab.setModel(this.layer);
                tabName = tab.getName();
            }
            catch (Throwable ex) {
                msgerr.append(this.translate("_Cant_initialice_property_page_{0}", tabName)).append("\n");
                logger.info("Can't set model of property page '" + tabName + "' from class '" + pageClass.getName() + "'.");
            }
            this.tabs.addTab(tabName, tab);
        }
        if (this.tabs.getComponentCount() > selectedTabIndex) {
            this.tabs.setSelectedIndex(selectedTabIndex);
        }
        this.tabs.setPreferredSize(new Dimension(640, 390));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                selectedTabIndex = ThemeManagerWindowNew.this.tabs.getSelectedIndex();
                if (selectedTabIndex < 0) {
                    selectedTabIndex = 0;
                }
            }
        });
        this.add((Component)this.getPanelButtons(), "South");
        this.setSize(new Dimension(780, 540));
        if (msgerr.length() > 0) {
            PluginServices.getMainFrame().messageDialog(msgerr.toString(), "_Warning", 2);
        }
    }

    private String translate(String msg, String arg1) {
        String[] args = null;
        String translation = null;
        if (msg == null) {
            return "";
        }
        if (arg1 != null) {
            args = new String[]{arg1};
        }
        if ((translation = Messages.getText((String)msg, args)) == null) {
            return "_" + msg.replace("_", " ");
        }
        return translation;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            this.panelButtons = new JPanel(new FlowLayout(2, 5, 5));
            JButton btnAceptar = new JButton(PluginServices.getText((Object)this, (String)"Aceptar"));
            btnAceptar.setActionCommand("OK");
            btnAceptar.addActionListener((ActionListener)this);
            JButton btnApply = new JButton(PluginServices.getText((Object)this, (String)"Apply"));
            btnApply.setActionCommand("APPLY");
            btnApply.addActionListener((ActionListener)this);
            JButton btnCancelar = new JButton(PluginServices.getText((Object)this, (String)"Cerrar"));
            btnCancelar.setActionCommand("CANCEL");
            btnCancelar.addActionListener((ActionListener)this);
            this.panelButtons.setPreferredSize(new Dimension(493, 33));
            this.panelButtons.add((Component)btnCancelar);
            this.panelButtons.add((Component)btnApply);
            this.panelButtons.add((Component)btnAceptar);
        }
        return this.panelButtons;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
            this.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "APPLY"));
            this.close();
        } else if (e.getActionCommand() == "CANCEL") {
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                AbstractThemeManagerPage tab = (AbstractThemeManagerPage)this.tabs.getComponentAt(i);
                tab.cancelAction();
            }
            this.close();
        } else if (e.getActionCommand() == "APPLY") {
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                AbstractThemeManagerPage tab = (AbstractThemeManagerPage)this.tabs.getComponentAt(i);
                tab.applyAction();
            }
            this.layer.getMapContext().callLegendChanged();
        }
        System.gc();
    }

    private void close() {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public WindowInfo getWindowInfo() {
        WindowInfo viewInfo = new WindowInfo(17);
        viewInfo.setWidth(this.getWidth());
        viewInfo.setHeight(this.getHeight());
        viewInfo.setTitle(PluginServices.getText((Object)this, (String)"propiedades_de_la_capa"));
        return viewInfo;
    }

    public static void addPage(Class<? extends AbstractThemeManagerPage> themeManagerPageClass) {
        pages.add(themeManagerPageClass);
    }

    public static void setTabEnabledForLayer(Class<? extends AbstractThemeManagerPage> abstractThemeManagerPageClass, Class<? extends FLayer> fLayerClazz, boolean enabled) {
        if (enabled) {
            if (!s.containsKey(abstractThemeManagerPageClass)) {
                ArrayList<Class<? extends FLayer>> enabledLayers = new ArrayList<Class<? extends FLayer>>();
                enabledLayers.add(fLayerClazz);
                s.put(abstractThemeManagerPageClass, enabledLayers);
            } else {
                ArrayList<Class<? extends FLayer>> enabledLayers = s.get(abstractThemeManagerPageClass);
                enabledLayers.add(fLayerClazz);
            }
        } else {
            if (!s.containsKey(abstractThemeManagerPageClass)) {
                return;
            }
            ArrayList<Class<? extends FLayer>> enabledLayers = s.get(abstractThemeManagerPageClass);
            enabledLayers.remove(fLayerClazz);
        }
    }

    public static boolean isTabEnabledForLayer(AbstractThemeManagerPage page, FLayer layer) {
        try {
            return s.get(page.getClass()).contains(layer.getClass());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.TOOL_PROFILE;
    }
}

