/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.actions;

import org.gvsig.andami.PluginServices;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.actions.CopyPasteLayersUtils;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.tools.persistence.PersistentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayersUngroupTocMenuEntry
extends AbstractTocContextMenuAction {
    private static Logger logger = LoggerFactory.getLogger(LayersUngroupTocMenuEntry.class);

    @Override
    public String getGroup() {
        return "group4";
    }

    @Override
    public int getGroupOrder() {
        return 40;
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public String getText() {
        return PluginServices.getText((Object)this, (String)"desagrupar_capas");
    }

    @Override
    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        return true;
    }

    @Override
    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        FLayer lyr = this.getNodeLayer(item);
        return lyr instanceof FLayers && (!(lyr instanceof FLayers) || lyr.getParentLayer() != null);
    }

    @Override
    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayers agrupa;
        FLayers parent;
        if (this.isTocItemBranch(item) && (parent = (agrupa = (FLayers)this.getNodeLayer(item)).getParentLayer()) != null) {
            this.getMapContext().beginAtomicEvent();
            FLayer[] layers = new FLayer[agrupa.getLayersCount()];
            for (int i = 0; i < agrupa.getLayersCount(); ++i) {
                layers[i] = agrupa.getLayer(i);
            }
            try {
                PersistentState lyrs_state = CopyPasteLayersUtils.getAsFLayersPersistentState(layers, this.getMapContext());
                CopyPasteLayersUtils.saveToClipboard(lyrs_state);
                CopyPasteLayersUtils.removeLayers(layers, this.getMapContext());
                FLayers resp = CopyPasteLayersUtils.getClipboardAsFLayers();
                CopyPasteLayersUtils.addLayers(resp, parent);
            }
            catch (Exception e) {
                logger.error("Error ungrouping layers. Can't copy layers outside the group");
            }
            parent.removeLayer((FLayer)agrupa);
            this.getMapContext().endAtomicEvent();
            this.getMapContext().invalidate();
            Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
            project.setModified(true);
        }
    }

    private int getPositionForUngrouped(FLayers lyr) {
        FLayers pare = lyr.getParentLayer();
        for (int i = 0; i < pare.getLayersCount(); ++i) {
            if (pare.getLayer(i) != lyr) continue;
            return i;
        }
        return 0;
    }
}

