/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.IContextMenuAction;
import org.gvsig.app.project.documents.view.IContextMenuActionWithIcon;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.actions.ChangeNameTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.ChangeSymbolTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.CopyLayersTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.CutLayersTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.EditOpenParametersLayerTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.EliminarCapaTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.LayersGroupTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.LayersUngroupTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.PasteLayersTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.ReloadLayerTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.ShowLayerErrorsTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.ZoomAlTemaTocMenuEntry;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class FPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -7420923229618207434L;
    private DefaultMutableTreeNode nodo;
    protected MapContext mapContext;
    private FLayer[] selecteds;

    public static void registerExtensionPoint() {
        ProjectManager projectManager = ProjectManager.getInstance();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        if (viewManager.existsTOCContextMenuActions("active-layer-set-visible")) {
            return;
        }
        viewManager.addTOCContextAction("FSymbolChangeColor", new ChangeSymbolTocMenuEntry());
        viewManager.addTOCContextAction("ChangeName", new ChangeNameTocMenuEntry());
        viewManager.addTOCContextAction("ZoomAlTema", new ZoomAlTemaTocMenuEntry());
        viewManager.addTOCContextAction("EliminarCapa", new EliminarCapaTocMenuEntry());
        viewManager.addTOCContextAction("VerErroresCapa", new ShowLayerErrorsTocMenuEntry());
        viewManager.addTOCContextAction("EditOpenParameters", new EditOpenParametersLayerTocMenuEntry());
        viewManager.addTOCContextAction("ReloadLayer", new ReloadLayerTocMenuEntry());
        viewManager.addTOCContextAction("LayersGroup", new LayersGroupTocMenuEntry());
        viewManager.addTOCContextAction("LayersUngroup", new LayersUngroupTocMenuEntry());
        viewManager.addTOCContextAction("active-layer-set-visible", "group4/_Visibility/_Visible_active_layers", 40, 2);
        viewManager.addTOCContextAction("active-layer-set-hide", "group4/_Visibility/_Hide_active_layers", 40, 3);
        viewManager.addTOCContextAction("active-layer-bring-front", "group4/_Visibility/_Bring_to_front", 40, 4);
        viewManager.addTOCContextAction("active-layer-send-back", "group4/_Visibility/_Send_to_back", 40, 5);
        viewManager.addTOCContextAction("active-layer-move-ahead", "group4/_Visibility/_Move_ahead", 40, 6);
        viewManager.addTOCContextAction("active-layer-move-behind", "group4/_Visibility/_Move_behind", 40, 7);
        viewManager.addTOCSeparator("group4/_Visibility", 40, 8);
        viewManager.addTOCContextAction("layer-set-active", "group4/_Visibility/_Active_all_layers", 40, 10);
        viewManager.addTOCContextAction("layer-set-inactive", "group4/_Visibility/_Inactive_all_layers", 40, 11);
        viewManager.addTOCContextAction("layer-set-hide", "group4/_Visibility/_Hide_all_layers", 40, 12);
        viewManager.addTOCContextAction("layer-set-visible", "group4/_Visibility/_Visible_all_layers", 40, 13);
        viewManager.addTOCSeparator("group4/_Visibility", 40, 14);
        viewManager.addTOCContextAction("group-set-active-all-layers", "group4/_Visibility/_Active_all_layers_of_group", 40, 15);
        viewManager.addTOCContextAction("group-set-inactive-all-layers", "group4/_Visibility/_Inactive_all_layers_of_group", 40, 16);
        viewManager.addTOCContextAction("Copy", new CopyLayersTocMenuEntry());
        viewManager.addTOCContextAction("Cut", new CutLayersTocMenuEntry());
        viewManager.addTOCContextAction("Paste", new PasteLayersTocMenuEntry());
    }

    public FPopupMenu(MapContext mc, DefaultMutableTreeNode node) {
        this.initialize(mc, node);
    }

    private void initialize(MapContext mc, DefaultMutableTreeNode node) {
        this.mapContext = mc;
        this.nodo = node;
        this.selecteds = this.mapContext.getLayers().getActives();
        List<IContextMenuAction> actions = this.getActionList();
        if (actions == null) {
            return;
        }
        this.createMenuElements(actions);
    }

    public MapContext getMapContext() {
        return this.mapContext;
    }

    public ITocItem getNodeUserObject() {
        if (this.nodo == null) {
            return null;
        }
        return (ITocItem)this.nodo.getUserObject();
    }

    public DefaultMutableTreeNode getNode() {
        return this.nodo;
    }

    private List<IContextMenuAction> getActionList() {
        ProjectManager projectManager = ProjectManager.getInstance();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        return viewManager.getTOCContextMenuActions(this.mapContext, this.selecteds, this.getNodeUserObject());
    }

    private void createMenuElements(List<IContextMenuAction> actions) {
        String lastGroup = null;
        I18nManager i18n = ToolsLocator.getI18nManager();
        HashMap<String, JMenu> menus = new HashMap<String, JMenu>();
        for (IContextMenuAction action : actions) {
            MenuItem item = new MenuItem(action.getText(), action);
            item.setEnabled(action.isEnabled(this.getNodeUserObject(), this.selecteds));
            if (action.getGroup() != null) {
                String[] splits;
                String newGroup = action.getGroup();
                if (newGroup.contains("/")) {
                    splits = newGroup.split("/");
                    newGroup = splits[0];
                } else {
                    splits = null;
                }
                if (!newGroup.equals(lastGroup)) {
                    if (lastGroup != null) {
                        this.addSeparator();
                    }
                    lastGroup = newGroup;
                }
                if (splits != null && splits.length > 0) {
                    JMenu actualMenu;
                    String agrupation1 = splits[1];
                    String actionName = splits[2];
                    if (!menus.containsKey(agrupation1)) {
                        JMenu m = new JMenu(i18n.getTranslation(agrupation1));
                        menus.put(agrupation1, m);
                        this.add(m);
                        actualMenu = m;
                    } else {
                        actualMenu = (JMenu)menus.get(agrupation1);
                    }
                    if (actionName.startsWith("-") && actionName.endsWith("-")) {
                        actualMenu.addSeparator();
                        continue;
                    }
                    item = new MenuItem(i18n.getTranslation(actionName), action);
                    actualMenu.add(item);
                    continue;
                }
            }
            this.add(item);
        }
    }

    public class MenuItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 6858724610206253411L;
        private IContextMenuAction action;

        public MenuItem(String text, IContextMenuAction documentAction) {
            String tip;
            super(text);
            this.action = documentAction;
            if (this.action instanceof IContextMenuActionWithIcon) {
                this.setIcon(((IContextMenuActionWithIcon)this.action).getIcon());
            }
            if ((tip = this.action.getDescription()) != null && tip.length() > 0) {
                this.setToolTipText(tip);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.execute(FPopupMenu.this.getNodeUserObject(), FPopupMenu.this.selecteds);
            if (PluginServices.getMainFrame() != null) {
                PluginServices.getMainFrame().enableControls();
            }
        }
    }
}

