/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.MapOverview;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapOverviewListener
implements PointListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(MapOverviewListener.class);
    private final Image izoomout = PluginServices.getIconTheme().get("cursor-crux").getImage();
    protected MapOverview mapControl;

    public MapOverviewListener(MapOverview mapControl) {
        this.mapControl = mapControl;
    }

    public void point(PointEvent event) {
        ViewPort vp = this.mapControl.getMapContext().getViewPort();
        if (vp.getExtent() != null && this.mapControl.getAssociatedMapContext().getViewPort().getExtent() != null) {
            Point2D p = vp.toMapPoint(event.getPoint());
            Rectangle2D r = (Rectangle2D)this.mapControl.getAssociatedMapContext().getViewPort().getExtent().clone();
            r.setRect(p.getX() - r.getWidth() / 2.0, p.getY() - r.getHeight() / 2.0, r.getWidth(), r.getHeight());
            if (event.getEvent().getButton() != 1) {
                try {
                    this.mapControl.getAssociatedMapContext().getViewPort().setEnvelope(geomManager.createEnvelope(r.getX(), r.getY(), r.getMaxX(), r.getMaxY(), 0));
                }
                catch (CreateEnvelopeException e) {
                    logger.error("Error creating the envelope", (Throwable)e);
                }
                PluginServices.getMainFrame().enableControls();
            }
        }
    }

    public Image getImageCursor() {
        return this.izoomout;
    }

    public boolean cancelDrawing() {
        return true;
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }
}

