/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.symboltables;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.expressionevaluator.spi.AbstractGeometryFunction;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.HasDataStore;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.AreaAndPerimeterCalculator;
import org.gvsig.temporarystorage.TemporaryStorageGroup;
import org.gvsig.temporarystorage.TemporaryStorageLocator;
import org.gvsig.temporarystorage.TemporaryStorageManager;

public class ProjectSymbolTable
extends AbstractSymbolTable {
    public static final String PROJECT_GROUP = "Project";
    public static final String AREA_NAME = "AREA";
    public static final String PERIMETER_NAME = "PERIMETER";
    public static final String TABLE_NAME = "TABLE";
    public static final String FETCH_FIRST_SELECTED_NAME = "FETCH_FIRST_SELECTED";
    public static final String APPLICATION_NAME = "APPLICATION";
    static final String NAME = "Project";
    private static final String TABLE_DOCUMENT_TYPENAME = "project.document.table";
    private final ProjectValue currentProject = new ProjectValue();
    private final CurrentViewValue currentView = new CurrentViewValue();
    private final CurrentViewEnvelopeValue currentViewEnvelope = new CurrentViewEnvelopeValue();
    private final PropertiesValue propertiesFiles = new PropertiesValue();
    private Map<String, Object> appvars;

    public ProjectSymbolTable() {
        super("Project");
        this.addFunction((Function)new CurrentProjectFunction());
        this.addFunction((Function)new TableFunction());
        this.addFunction((Function)new ViewFunction());
        this.addFunction((Function)new ViewBBoxFunction());
        this.addFunction((Function)new PropertyFunction());
        this.addFunction((Function)new AreaFunction());
        this.addFunction((Function)new PerimeterFunction());
        this.addFunction((Function)new SavedPointFunction());
        this.addFunction((Function)new ApplicationFunction());
    }

    private MapContext getMapContext(Feature feature) {
        FeatureStore store = feature.getStore();
        Project project = ProjectManager.getInstance().getCurrentProject();
        project.getDocuments(ViewManager.TYPENAME);
        for (Document document : project.getDocuments(ViewManager.TYPENAME)) {
            ViewDocument view = (ViewDocument)document;
            MapContext mapContext = view.getMapContext();
            FLayer layer = this.getLayer(mapContext, store);
            if (layer == null) continue;
            return mapContext;
        }
        return null;
    }

    private FLayer getLayer(MapContext mapContext, FeatureStore store) {
        Iterator it = mapContext.deepiterator();
        while (it.hasNext()) {
            FeatureStore layer_store;
            FLayer layer = (FLayer)it.next();
            if (!(layer instanceof FLyrVect) || (layer_store = ((FLyrVect)layer).getFeatureStore()) != store) continue;
            return layer;
        }
        return null;
    }

    private IProjection getProjection(Object[] args, int i) {
        Object value = args[i];
        if (value == null) {
            return null;
        }
        if (value instanceof IProjection) {
            return (IProjection)value;
        }
        String code = value.toString();
        return CRSFactory.getCRS((String)code);
    }

    private int getUnitsArea(Object[] args, int i) {
        int j;
        Object value = args[i];
        if (value == null) {
            throw new IllegalArgumentException("Illegal unit value 'null'");
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String name = value.toString();
        String[] names = MapContext.getAreaAbbr();
        for (j = 0; j < names.length; ++j) {
            if (!name.equalsIgnoreCase(names[j])) continue;
            return j;
        }
        names = MapContext.getAreaNames();
        for (j = 0; j < names.length; ++j) {
            if (!name.equalsIgnoreCase(names[j])) continue;
            return j;
        }
        throw new IllegalArgumentException("Illegal unit name '" + name + "'");
    }

    private int getUnitsDistance(Object[] args, int i) {
        int j;
        Object value = args[i];
        if (value == null) {
            throw new IllegalArgumentException("Illegal unit value 'null'");
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String name = value.toString();
        String[] names = MapContext.getDistanceAbbr();
        for (j = 0; j < names.length; ++j) {
            if (!name.equalsIgnoreCase(names[j])) continue;
            return j;
        }
        names = MapContext.getDistanceNames();
        for (j = 0; j < names.length; ++j) {
            if (!name.equalsIgnoreCase(names[j])) continue;
            return j;
        }
        throw new IllegalArgumentException("Illegal unit name '" + name + "'");
    }

    protected Map<String, Object> getVars() {
        if (this.appvars == null) {
            PluginsManager manager = PluginsLocator.getPluginsManager();
            this.appvars = new HashMap<String, Object>();
            this.appvars.put("$GVSIGFOLDER", manager.getApplicationFolder().getAbsolutePath());
            this.appvars.put("$GVSIGHOMEFOLDER", manager.getApplicationHomeFolder().getAbsolutePath());
            this.appvars.put("$GVSIGVERSION", manager.getApplicationVersion());
            this.appvars.put("$GVSIGARGS", manager.getArguments());
            this.appvars.put("$GVSIGPACKAGE", manager.getPackageInfo());
        }
        return this.appvars;
    }

    public void setVar(String name, Object value) {
    }

    public void removeVar(String name) {
    }

    private class PropertyFunction
    extends AbstractFunction {
        public PropertyFunction() {
            super("Project", "PROPERTY", Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)), "Access to a property value in a properties file. If theindicated filename is not absolute, access it relativeto the project.", "PROPERTY({{filename}}, name, defaultValue)", new String[]{"filename - String value with the name of the properties file", "name - String value with the name of the property to retrieve from the file", "defaultValue - Optional. Default value if can't access the file or the property"}, "String");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            Properties properties;
            String defaultValue;
            String name;
            block7: {
                Map x;
                File file;
                String filename = this.getStr(args, 0);
                name = this.getStr(args, 1);
                defaultValue = null;
                if (args.length == 3) {
                    defaultValue = this.getStr(args, 2);
                }
                if (!(file = new File(filename)).isAbsolute()) {
                    Project project = (Project)ProjectSymbolTable.this.currentProject.get();
                    if (project.getFile() == null) {
                        return defaultValue;
                    }
                    file = new File(project.getFile().getParent(), filename);
                }
                if ((properties = (Properties)(x = (Map)ProjectSymbolTable.this.propertiesFiles.get()).get(file)) != null) break block7;
                properties = new Properties();
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    properties.load(in);
                }
                catch (Exception ex) {
                    String string;
                    try {
                        string = defaultValue;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    return string;
                }
                IOUtils.closeQuietly((InputStream)in);
                x.put(file, properties);
            }
            String value = properties.getProperty(name, defaultValue);
            return value;
        }
    }

    private class PerimeterFunction
    extends AbstractGeometryFunction {
        public PerimeterFunction() {
            super("Project", ProjectSymbolTable.PERIMETER_NAME, Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)), "Calculate the perimeter of the geometry in the indicated units", "PERIMETER({{geometry}}, 'm')", new String[]{"geometry - Geometry", "Projection - Optional. Projection of the geometry or a string with the projection name", "units - String value with the name the units to use"}, "Double");
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            int units = 0;
            IProjection proj = null;
            Geometry geom = this.getGeom(args, 0);
            switch (args.length) {
                case 2: {
                    units = ProjectSymbolTable.this.getUnitsDistance(args, 1);
                    break;
                }
                case 3: {
                    proj = ProjectSymbolTable.this.getProjection(args, 1);
                    units = ProjectSymbolTable.this.getUnitsDistance(args, 2);
                }
            }
            if (proj == null) {
                proj = geom.getProjection();
            }
            AreaAndPerimeterCalculator calculator = new AreaAndPerimeterCalculator();
            double perimeter = calculator.perimeter(geom, proj, units);
            return perimeter;
        }
    }

    private class AreaFunction
    extends AbstractGeometryFunction {
        public AreaFunction() {
            super("Project", ProjectSymbolTable.AREA_NAME, Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)), "Calculate the area of the geometry in the indicated units", "AREA({{geometry}}, 'm\u00b2')", new String[]{"geometry - Geometry", "Projection - Optional. Projection of the geometry or a string with the projection name", "units - String value with the name the units to use"}, "Double");
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            int units = 0;
            IProjection proj = null;
            Geometry geom = this.getGeom(args, 0);
            switch (args.length) {
                case 2: {
                    units = ProjectSymbolTable.this.getUnitsArea(args, 1);
                    break;
                }
                case 3: {
                    proj = ProjectSymbolTable.this.getProjection(args, 1);
                    units = ProjectSymbolTable.this.getUnitsArea(args, 2);
                }
            }
            if (proj == null) {
                proj = geom.getProjection();
            }
            AreaAndPerimeterCalculator calculator = new AreaAndPerimeterCalculator();
            double area = calculator.area(geom, proj, units);
            return area;
        }
    }

    private class SavedPointFunction
    extends AbstractFunction {
        public SavedPointFunction() {
            super("Project", "SAVEDPOINT", Range.is((Comparable)Integer.valueOf(1)), "Return the value of the saved point with the name indicated.\nIf the named point do not exists return null.", "SAVEDPOINT({{name}})", new String[]{"name - String value with the name of the point"}, "Geometry");
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            TemporaryStorageManager manager = TemporaryStorageLocator.getTemporaryStorageManager();
            TemporaryStorageGroup storage = manager.create("Points", Point.class);
            Geometry value = (Geometry)storage.get(this.getStr(args, 0));
            return value;
        }
    }

    private class ViewBBoxFunction
    extends AbstractFunction {
        public ViewBBoxFunction() {
            super("Project", "VIEWBOX", Range.is((Comparable)Integer.valueOf(0)), "Return the BBox of the active view.", "VIEWBOX()", null, "Geometry");
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            return ProjectSymbolTable.this.currentViewEnvelope.get();
        }
    }

    private class ViewFunction
    extends AbstractFunction {
        public ViewFunction() {
            super("Project", "VIEW", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1)), "Access to the indicated view. If viewName is null return active view", "VIEW({{viewName}})", new String[]{"viewName - Optional string value with the name of a view."}, "DocumentView");
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            if (args.length == 0) {
                Project project = (Project)ProjectSymbolTable.this.currentProject.get();
                ViewDocument view = (ViewDocument)project.getActiveDocument(ViewManager.TYPENAME);
                return view;
            }
            String viewName = this.getStr(args, 0);
            Project project = (Project)ProjectSymbolTable.this.currentProject.get();
            ViewDocument view = (ViewDocument)project.getDocument(viewName, ViewManager.TYPENAME);
            return view;
        }
    }

    private class TableFunction
    extends AbstractFunction {
        public TableFunction() {
            super("Project", ProjectSymbolTable.TABLE_NAME, Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), "Return the data store associated with a layer or a table.\nIf receive a single parameter, it will correspond to the name of a table-type document or a layer of the active view, and it will return your data store. If you receive two parameters, you expect to be the name of a view and a layer of it, returning the data store of the layer. Examples:\n  TABLE(table_name_document)\n  TABLE(layer_name_of_active_view)\n  TABLE(view_name, layer_name)\n", "TABLE({{view}}, layer)", new String[]{"view - String value with the name of a view, if view is null use current View.", "layer - String value with the name of a layer in the indicated view"}, "DataStore");
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            Project project = (Project)ProjectSymbolTable.this.currentProject.get();
            Document document = null;
            ViewDocument view = null;
            switch (args.length) {
                case 1: {
                    FLayer layer;
                    String tableName = this.getStr(args, 0);
                    document = project.getDocument(tableName, ProjectSymbolTable.TABLE_DOCUMENT_TYPENAME);
                    if (document instanceof HasDataStore) {
                        return ((HasDataStore)document).getDataStore();
                    }
                    view = (ViewDocument)project.getActiveDocument(ViewManager.TYPENAME);
                    if (view != null && (layer = view.getLayer(tableName)) instanceof HasDataStore) {
                        return ((HasDataStore)layer).getDataStore();
                    }
                    throw new ExpressionRuntimeException("Problems calling 'TABLE' function, can't locate table document '" + tableName + "'.");
                }
                case 2: {
                    String layerName;
                    FLayer layer;
                    String viewName = this.getStr(args, 0);
                    if (StringUtils.isBlank((CharSequence)viewName)) {
                        view = (ViewDocument)project.getActiveDocument(ViewManager.TYPENAME);
                        if (view == null) {
                            throw new ExpressionRuntimeException("Problems calling 'TABLE' function, can't locate active View.");
                        }
                    } else {
                        view = (ViewDocument)project.getDocument(viewName, ViewManager.TYPENAME);
                        if (view == null) {
                            throw new ExpressionRuntimeException("Problems calling 'TABLE' function, can't locate View '" + viewName + "'.");
                        }
                    }
                    if ((layer = view.getLayer(layerName = this.getStr(args, 1))) instanceof HasDataStore) {
                        return ((HasDataStore)layer).getDataStore();
                    }
                    throw new ExpressionRuntimeException("Problems calling 'TABLE' function, can't get the store from layer '" + layerName + "' in View '" + viewName + "'.");
                }
            }
            return null;
        }
    }

    private class ApplicationFunction
    extends AbstractFunction {
        public ApplicationFunction() {
            super("Project", ProjectSymbolTable.APPLICATION_NAME, Range.is((Comparable)Integer.valueOf(0)), "Access to the Application object.\n", "APPLICATION()", null, "ApplicationManager");
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            return ApplicationLocator.getApplicationManager();
        }
    }

    private class CurrentProjectFunction
    extends AbstractFunction {
        public CurrentProjectFunction() {
            super("Project", "PROJECT", Range.is((Comparable)Integer.valueOf(0)), "Access to the current project loaded in gvSIG desktop.\n", "PROJECT()", null, "Project");
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            return ProjectSymbolTable.this.currentProject.get();
        }
    }

    private class PropertiesValue
    extends CachedValue<Map<File, Properties>> {
        private PropertiesValue() {
        }

        @Override
        protected void reload() {
            this.value = new HashMap();
        }
    }

    private class CurrentViewEnvelopeValue
    extends CachedValue<Geometry> {
        private CurrentViewEnvelopeValue() {
        }

        @Override
        protected void reload() {
            ApplicationManager application = ApplicationLocator.getManager();
            ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (viewdoc == null) {
                this.value = null;
                return;
            }
            this.value = viewdoc.getMapContext().getViewPort().getEnvelope().getGeometry();
        }
    }

    private class CurrentViewValue
    extends CachedValue<ViewDocument> {
        private CurrentViewValue() {
        }

        @Override
        protected void reload() {
            ApplicationManager application = ApplicationLocator.getManager();
            ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            this.value = viewdoc;
        }
    }

    private class ProjectValue
    extends CachedValue<Project> {
        private ProjectValue() {
        }

        @Override
        protected void reload() {
            this.value = ProjectManager.getInstance().getCurrentProject();
        }
    }

    private abstract class CachedValue<T> {
        T value = null;
        long lastAccess = 0L;

        private CachedValue() {
        }

        protected abstract void reload();

        public boolean isExpired() {
            long now = System.currentTimeMillis();
            return now - this.lastAccess > 3000L;
        }

        public T get() {
            if (this.isExpired()) {
                this.reload();
            }
            this.lastAccess = System.currentTimeMillis();
            return this.value;
        }
    }
}

