/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.util;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.OpenErrorHandler;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.utils.SimpleFileFilter;

public class BaseOpenErrorHandler
implements OpenErrorHandler {
    private DataParameters parameters = null;

    public boolean canRetryOpen(Exception e, DataParameters parameters) {
        this.parameters = parameters;
        boolean retry = false;
        if (this.parameters instanceof FilesystemStoreParameters) {
            FilesystemStoreParameters filesystemStoreParameters = (FilesystemStoreParameters)this.parameters;
            File searchedFile = filesystemStoreParameters.getFile();
            File file = null;
            if (searchedFile != null && !searchedFile.exists()) {
                file = this.chooseAlternateFile(searchedFile);
                if (file != null) {
                    filesystemStoreParameters.setFile(file);
                    retry = true;
                } else {
                    return false;
                }
            }
            if (this.parameters.getDynClass().getName().equalsIgnoreCase("SHPStoreParameters")) {
                File searchedDBFFile = (File)this.parameters.getDynValue("dbfFile");
                if (searchedDBFFile != null && !searchedDBFFile.exists()) {
                    File possibleDbfFile = null;
                    if (file != null) {
                        possibleDbfFile = this.findFile(file, "dbf");
                    }
                    if (possibleDbfFile != null && possibleDbfFile.exists()) {
                        this.parameters.setDynValue("dbfFile", (Object)possibleDbfFile);
                        retry = true;
                    } else {
                        File dbfFile = this.chooseAlternateFile(searchedDBFFile);
                        if (dbfFile != null) {
                            this.parameters.setDynValue("dbfFile", (Object)dbfFile);
                            retry = true;
                        } else {
                            return false;
                        }
                    }
                }
                File searchedSHXFile = (File)this.parameters.getDynValue("shxfile");
                if (searchedDBFFile != null && !searchedSHXFile.exists()) {
                    File possibleShxFile = null;
                    if (file != null) {
                        possibleShxFile = this.findFile(file, "shx");
                    }
                    if (possibleShxFile != null && possibleShxFile.exists()) {
                        this.parameters.setDynValue("shxfile", (Object)possibleShxFile);
                        retry = true;
                    } else {
                        File shxFile = this.chooseAlternateFile(searchedSHXFile);
                        if (shxFile != null) {
                            this.parameters.setDynValue("shxfile", (Object)shxFile);
                            retry = true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
        return retry;
    }

    private File chooseAlternateFile(File searchedFile) {
        I18nManager i18nManager;
        ApplicationManager application = ApplicationLocator.getManager();
        int resp = application.confirmDialog((i18nManager = ToolsLocator.getI18nManager()).getTranslation("dont_find_the_file") + "\n" + searchedFile.getName() + "\n" + i18nManager.getTranslation("do_you_want_to_locate_the_file"), i18nManager.getTranslation("dont_find_the_file"), 0, 3, "File not found when open data source");
        if (resp == 0) {
            JFileChooser fileChooser = new JFileChooser("OPEN_LAYER_FILE_CHOOSER_ID", searchedFile.getParentFile());
            File parentFile = searchedFile.getParentFile();
            if (parentFile.exists()) {
                fileChooser.setLastPath(parentFile);
            }
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setDialogTitle("dont_find_the_file: " + searchedFile.getAbsolutePath());
            String searchedFileName = searchedFile.getName();
            String ext = searchedFileName.substring(searchedFileName.lastIndexOf(".") + 1);
            SimpleFileFilter fileFilter = new SimpleFileFilter(ext, ext);
            fileChooser.addChoosableFileFilter((FileFilter)fileFilter);
            fileChooser.setFileFilter((FileFilter)fileFilter);
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File file = fileChooser.getSelectedFile();
                return file;
            }
        }
        return null;
    }

    private File findFile(File file, String extension) {
        File[] files = file.getParentFile().listFiles(new ExtensionFilenameFilter(file, extension));
        if (files == null || files.length < 1) {
            return new File(file.getParentFile(), FilenameUtils.getBaseName((String)file.getName()) + "." + extension);
        }
        return files[0];
    }

    private class ExtensionFilenameFilter
    implements FilenameFilter {
        private String extension;
        private String baseName;

        ExtensionFilenameFilter(File f, String extension) {
            this.extension = extension;
            this.baseName = FilenameUtils.getBaseName((String)f.getName());
        }

        @Override
        public boolean accept(File arg0, String filename) {
            return FilenameUtils.getBaseName((String)filename).equals(this.baseName) && FilenameUtils.getExtension((String)filename).equalsIgnoreCase(this.extension);
        }
    }
}

