/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.filesystem.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.prepareAction.PrepareContext;
import org.gvsig.app.prepareAction.PrepareContextView_v1;
import org.gvsig.app.project.documents.view.toc.actions.LayerErrorsPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemFileFilter;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.FilesystemExplorerWizardPanelController;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.UnauthorizedException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemExplorerWizardPanel
extends WizardPanel {
    private static final long serialVersionUID = 788115220334290212L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemExplorerWizardPanel.class);
    private static final String DEFAULT_FILTER = "All_supported";
    public static final String OPEN_LAYER_FILE_CHOOSER_ID = "OPEN_LAYER_FILE_CHOOSER_ID";
    protected FilesystemServerExplorer explorer;
    private ArrayList<MyFileFilter> filters;
    private FilesystemExplorerWizardPanelController panel = null;
    private boolean tabularOnly;

    public FilesystemExplorerWizardPanel() {
        this(false);
    }

    public FilesystemExplorerWizardPanel(boolean tabularOnly) {
        this.tabularOnly = tabularOnly;
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ae) {
                FilesystemExplorerWizardPanel.this.initExplorer();
                FilesystemExplorerWizardPanel.this.initFilters();
                FilesystemExplorerWizardPanel.this.updatePanel();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
                FilesystemExplorerWizardPanel.this.dispose();
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }
        });
    }

    protected void updatePanel() {
        this.panel.setExplorer(this.explorer);
        this.panel.setFilters(this.filters);
    }

    @Override
    public void initWizard() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.setTabName(i18nManager.getTranslation("Fichero"));
        this.initExplorer();
        this.initFilters();
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel = new FilesystemExplorerWizardPanelController(this.getMapContext(), this.explorer, this.filters);
        this.panel.setTabularOnly(this.tabularOnly);
        this.add((Component)this.panel, gridBagConstraints);
        this.panel.addChangeListener(e -> this.callStateChanged(this.areSettingsValid()));
    }

    @Override
    public void execute() {
        if (this.getMapCtrl() == null) {
            throw new IllegalArgumentException("MapControl need");
        }
        for (DataStoreParameters params : this.getParameters()) {
            this.fixCRS(params);
            String layerName = ((FilesystemStoreParameters)params).getFile().getName();
            this.doAddLayer(layerName, params);
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void dispose() {
        if (this.explorer != null) {
            this.explorer.dispose();
            this.explorer = null;
        }
        if (this.filters != null) {
            this.filters.clear();
            this.filters = null;
        }
        this.panel.dispose();
    }

    @Override
    public DataStoreParameters[] getParameters() {
        return this.panel.getParameters();
    }

    public void addFiles(List<File> files) {
        this.panel.addFiles(files);
    }

    private void initExplorer() {
        if (this.explorer == null) {
            DataManager dm = DALLocator.getDataManager();
            try {
                FoldersManager folderManager = ToolsLocator.getFoldersManager();
                FilesystemServerExplorerParameters param = (FilesystemServerExplorerParameters)dm.createServerExplorerParameters("FilesystemExplorer");
                param.setInitialpath(folderManager.getLastPath(OPEN_LAYER_FILE_CHOOSER_ID, folderManager.getHome()).getAbsolutePath());
                this.explorer = (FilesystemServerExplorer)dm.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)param);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void initFilters() {
        if (this.filters == null) {
            int mode = 0;
            this.filters = new ArrayList();
            mode = this.getMapCtrl() == null ? 1 : 6;
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.filters.add(new MyFileFilter(this.explorer.getFilter(mode, i18nManager.getTranslation(DEFAULT_FILTER))));
            Iterator iter = this.explorer.getFilters(mode);
            while (iter.hasNext()) {
                this.filters.add(new MyFileFilter((FilesystemFileFilter)iter.next()));
            }
        }
    }

    boolean isTiled(DataStoreParameters parameters) {
        return this.panel.isTiled(parameters);
    }

    @Override
    protected void doAddLayer(String layerName, DataStoreParameters parameters) {
        final boolean b_isMapControlAvail = this.isMapControlAvailable();
        final MapControl mapControl = this.getMapCtrl();
        final MapContext mapContext = this.getMapContext();
        ApplicationManager application = ApplicationLocator.getManager();
        MapContextManager manager = MapContextLocator.getMapContextManager();
        LOGGER.info("addLayer('{}',...)", (Object)layerName);
        Thread task = new Thread(() -> {
            FLayer layer;
            block16: {
                layer = null;
                FLayer preparedLayer = null;
                try {
                    DataManager dataManager = DALLocator.getDataManager();
                    DataStore dataStore = dataManager.openStore(parameters.getDataStoreName(), parameters);
                    DataStoreProviderFactory factory = dataStore.getProviderFactory();
                    if (factory.isTiledSupported() != 2 && !factory.getClass().getSimpleName().equals("TileProviderFactory") && this.isTiled(parameters)) {
                        DataStoreParameters tileParameters = dataManager.createStoreParameters("TileCache");
                        PluginsManager pluginsManager = PluginsLocator.getManager();
                        File rootFolder = new File(pluginsManager.getApplicationHomeFolder(), "gvsig_rcache");
                        if (tileParameters.getDynClass().getDynField("rootFolder") != null) {
                            tileParameters.setDynValue("rootFolder", (Object)rootFolder);
                        }
                        try {
                            dataStore.useCache("TileCache", (DynObject)tileParameters);
                        }
                        catch (DataException e) {
                            LOGGER.warn("Can't cache the layer.", (Throwable)e);
                        }
                    }
                    String layerName1 = dataStore.getName();
                    layer = manager.createLayer(layerName1, dataStore);
                    DisposeUtils.disposeQuietly((Disposable)dataStore);
                    preparedLayer = application.prepareOpenLayer(layer, new PrepareContextView_v1(){

                        @Override
                        public Window getOwnerWindow() {
                            return null;
                        }

                        @Override
                        public MapControl getMapControl() {
                            return mapControl;
                        }

                        @Override
                        public IProjection getViewProjection() {
                            return mapContext.getProjection();
                        }

                        @Override
                        public MapContext getMapContext() {
                            return mapContext;
                        }

                        @Override
                        public boolean isMapControlAvailable() {
                            return b_isMapControlAvail;
                        }
                    });
                    if (preparedLayer != null) {
                        mapControl.addLayer(preparedLayer);
                    }
                    if (preparedLayer == layer) break block16;
                }
                catch (UnauthorizedException e) {
                    block17: {
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        ApplicationManager application1 = ApplicationLocator.getManager();
                        String resource = "";
                        if (e.getResource() instanceof FilesystemStoreParameters) {
                            resource = ((FilesystemStoreParameters)e.getResource()).getFile().getPath();
                        }
                        application1.messageDialog(i18nManager.getTranslation("_User_0_is_not_authorized_to_1_on_resource_2_3", new String[]{e.getIdentity().getID(), e.getActionName(), e.getResourceName(), resource}), i18nManager.getTranslation("_Unauthorized_access"), 2);
                        LOGGER.warn("Unauthorized access to layer '" + layerName + "'.", (Throwable)e);
                        if (preparedLayer == layer) break block17;
                        DisposeUtils.disposeQuietly((Disposable)preparedLayer);
                    }
                    DisposeUtils.disposeQuietly((Disposable)layer);
                }
                catch (Exception e2) {
                    block18: {
                        LayerErrorsPanel panel1 = new LayerErrorsPanel(layerName, e2);
                        if (preparedLayer != null) {
                            panel1.setLayer(preparedLayer);
                        } else if (layer != null) {
                            panel1.setLayer(layer);
                        }
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        ToolsSwingLocator.getWindowManager().showWindow((JComponent)panel1, i18nManager.getTranslation("_Problems_loading_the_layer"), WindowManager.MODE.WINDOW);
                        LOGGER.warn("Can't load layer '" + layerName + "'.", (Throwable)e2);
                        if (preparedLayer == layer) break block18;
                        {
                            catch (Throwable throwable) {
                                if (preparedLayer != layer) {
                                    DisposeUtils.disposeQuietly(preparedLayer);
                                }
                                DisposeUtils.disposeQuietly(layer);
                                throw throwable;
                            }
                        }
                        DisposeUtils.disposeQuietly((Disposable)preparedLayer);
                    }
                    DisposeUtils.disposeQuietly((Disposable)layer);
                }
                DisposeUtils.disposeQuietly((Disposable)preparedLayer);
            }
            DisposeUtils.disposeQuietly((Disposable)layer);
        });
        task.setName("LoadLayer" + layerName);
        this.startTask(task);
    }

    protected void showPropertiesDialog(DynObject parameters) {
        this.panel.showPropertiesDialog(parameters);
    }

    protected PrepareContext getPrepareDataStoreContext() {
        return this.panel.getPrepareDataStoreContext();
    }

    @Override
    public boolean areSettingsValid() {
        Object[] params = this.getParameters();
        return !ArrayUtils.isEmpty((Object[])params);
    }

    public class MyFileFilter
    extends FileFilter {
        private FilesystemFileFilter filter = null;

        public MyFileFilter(FilesystemFileFilter params) {
            this.setFilter(params);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return this.getFilter().accept(f);
        }

        @Override
        public String getDescription() {
            return this.getFilter().getDescription();
        }

        public String getName() {
            return this.getFilter().getDataStoreProviderName();
        }

        public FilesystemFileFilter getFilter() {
            return this.filter;
        }

        public void setFilter(FilesystemFileFilter filter) {
            this.filter = filter;
        }
    }
}

