/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.fmap.dal.store.dwg.legend;

import java.awt.Color;
import org.gvsig.dwg.fmap.dal.store.dwg.LegendBuilder;
import org.gvsig.dwg.lib.util.AcadColor;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialUniqueValueLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.IAttrInTableLabelingStrategy;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;

public class DWGLegendBuilder
implements LegendBuilder {
    private IVectorialUniqueValueLegend defaultLegend = null;
    private IAttrInTableLabelingStrategy labelingStragegy = null;

    public void begin() {
    }

    public void end() {
    }

    public Object getLegend() {
        return this.defaultLegend;
    }

    public LegendBuilder initialize(FeatureStoreProvider store) {
        this.defaultLegend = (IVectorialUniqueValueLegend)MapContextLocator.getMapContextManager().createLegend("VectorialUniqueValue");
        this.defaultLegend.setShapeType(0);
        this.defaultLegend.setClassifyingFieldNames(new String[]{"Color"});
        this.defaultLegend.setClassifyingFieldTypes(new int[]{4});
        ISymbol myDefaultSymbol = MapContextLocator.getSymbolManager().createSymbol(0, Color.BLACK);
        this.defaultLegend.setDefaultSymbol(myDefaultSymbol);
        this.labelingStragegy = SymbologyLocator.getSymbologyManager().createAttrInTableLabelingStrategy();
        this.labelingStragegy.setTextField("Text");
        this.labelingStragegy.setRotationField("Rotation");
        this.labelingStragegy.setHeightField("HeightText");
        this.labelingStragegy.setUnit(1);
        return this;
    }

    public void process(FeatureProvider feature) {
        Integer clave = (Integer)feature.get("Color");
        if (clave == null) {
            return;
        }
        this.defaultLegend.useDefaultSymbol(false);
        if (this.defaultLegend.getSymbolByValue((Object)clave) == null) {
            Color color = null;
            try {
                color = AcadColor.getColor((int)clave);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                color = AcadColor.getColor((int)255);
            }
            ISymbol theSymbol = MapContextLocator.getSymbolManager().createSymbol(0, color);
            theSymbol.setDescription(clave.toString());
            if (theSymbol instanceof IFillSymbol) {
                ((IFillSymbol)theSymbol).getOutline().setLineColor(color);
                Color fillColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
                ((IFillSymbol)theSymbol).setFillColor(fillColor);
            }
            if (theSymbol instanceof ILineSymbol) {
                ((ILineSymbol)theSymbol).setLineColor(color);
            }
            if (theSymbol != null) {
                this.defaultLegend.addSymbol((Object)clave, theSymbol);
            }
        }
        this.defaultLegend.useDefaultSymbol(true);
    }

    public Object getLabeling() {
        return this.labelingStragegy;
    }
}

