/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.threads;

import org.gvsig.utils.swing.threads.IMonitorableTask;
import org.gvsig.utils.swing.threads.IPipedTask;

public class PipeTask
implements IMonitorableTask {
    private IPipedTask task1;
    private IPipedTask task2;
    private boolean canceled = false;
    private IPipedTask currentTask = null;

    public PipeTask(IPipedTask task1, IPipedTask task2) {
        this.task1 = task1;
        this.task2 = task2;
        this.currentTask = task1;
    }

    @Override
    public int getInitialStep() {
        return 0;
    }

    @Override
    public int getFinishStep() {
        return this.currentTask.getFinishStep();
    }

    @Override
    public int getCurrentStep() {
        return this.currentTask.getCurrentStep();
    }

    @Override
    public String getStatusMessage() {
        return this.currentTask.getStatusMessage();
    }

    @Override
    public String getNote() {
        if (this.currentTask != null) {
            return this.currentTask.getNote();
        }
        return "";
    }

    @Override
    public boolean isDefined() {
        return this.currentTask.isDefined();
    }

    @Override
    public void cancel() {
        this.currentTask.cancel();
        this.canceled = true;
    }

    @Override
    public void run() throws Exception {
        this.currentTask.run();
        if (this.currentTask.isCanceled()) {
            return;
        }
        Object result = this.currentTask.getResult();
        this.currentTask = this.task2;
        this.currentTask.setEntry(result);
        this.currentTask.run();
    }

    @Override
    public boolean isCanceled() {
        return this.currentTask.isCanceled();
    }

    @Override
    public boolean isFinished() {
        return this.task1.isFinished() && this.task2.isFinished();
    }

    @Override
    public void finished() {
    }
}

