/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.commons.io.output.WriterOutputStream;
import org.gvsig.scripting.swing.api.JScriptingConsole;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class DefaultJScriptingConsole
extends JPanel
implements JScriptingConsole {
    private static final long serialVersionUID = -2060450772889689371L;
    private JTextPane console;
    private final OutputWriter output;
    private final OutputWriter errors;
    private PrintStream outputStream = null;
    private PrintStream errorsStream = null;

    public DefaultJScriptingConsole(boolean captureOutput) {
        this.initComponents();
        this.output = new OutputWriter(this.console, Color.BLACK);
        this.errors = new OutputWriter(this.console, Color.RED.darker());
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.setLayout(new BorderLayout());
        this.console = new JTextPane();
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.console);
        this.console.setFont(new Font("monospaced", 0, 13));
        JScrollPane scrollConsole = new JScrollPane(this.console);
        this.add((Component)scrollConsole, "Center");
    }

    public void clear() {
        this.console.setText("");
    }

    public void append(String s) {
        this.output.append(s);
    }

    public void append(String msg, Color color) {
        this.output.append(msg, color);
    }

    public JComponent asJComponent() {
        return this;
    }

    public Writer getOutputWriter() {
        return this.output;
    }

    public Writer getErrorsWriter() {
        return this.errors;
    }

    public PrintStream output() {
        if (this.outputStream == null) {
            WriterOutputStream xx = new WriterOutputStream((Writer)this.output);
            this.outputStream = new PrintStream((OutputStream)xx);
        }
        return this.outputStream;
    }

    public PrintStream errors() {
        if (this.errorsStream == null) {
            WriterOutputStream xx = new WriterOutputStream((Writer)this.errors);
            this.errorsStream = new PrintStream((OutputStream)xx);
        }
        return this.errorsStream;
    }

    private static class OutputWriter
    extends Writer {
        private final Color color;
        private final JTextPane textPanel;

        public OutputWriter(JTextPane textPanel, Color color) {
            this.color = color;
            this.textPanel = textPanel;
        }

        public void append(String msg) {
            this.append(msg, this.color);
        }

        public void append(String msg, Color color) {
            StyleContext sc = StyleContext.getDefaultStyleContext();
            AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color);
            int len = this.textPanel.getDocument().getLength();
            this.textPanel.setCaretPosition(len);
            this.textPanel.setCharacterAttributes(aset, false);
            this.textPanel.replaceSelection(msg);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String s = new String(cbuf, off, len);
            this.append(s);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

