/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.texteditor.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.scripting.swing.impl.syntaxhighlight.JRSyntaxTextArea;
import org.gvsig.texteditor.JTextEditor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.viewer.AbstractJViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTextEditorRSyntaxTextArea
extends AbstractJViewer
implements JTextEditor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JTextEditorRSyntaxTextArea.class);
    private final JPanel panel;
    private final JRSyntaxTextArea text;
    private boolean opened = false;
    private boolean saved = false;
    private File openedFile;
    private String mimeType;
    private final ChangeListenerHelper changeListeners;
    private final FindDialog findDialog;
    private final ReplaceDialog replaceDialog;
    private final GoToDialog gotoDialog;
    private final StatusBar statusbar;

    public JTextEditorRSyntaxTextArea(ViewerFactory factory) {
        super(factory);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.addMenuItem(fileMenu, "Open...", e -> this.doOpenFile());
        this.addMenuItem(fileMenu, "Save", e -> this.doSaveFile());
        this.addMenuItem(fileMenu, "Save as...", e -> this.doSaveAsFile());
        this.addMenuItem(fileMenu, "Close", e -> this.doClose());
        JMenu editMenu = new JMenu("Edit");
        this.addMenuItem(editMenu, "Select all", e -> this.doSelectAll());
        this.addMenuItem(editMenu, "Cut", e -> this.doCut());
        this.addMenuItem(editMenu, "Copy", e -> this.doCopy());
        this.addMenuItem(editMenu, "Paste", e -> this.doPaste());
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        this.changeListeners = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.statusbar = new StatusBar();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)menuBar, "North");
        this.text = new JRSyntaxTextArea();
        this.text.setlineTrackerVisible(false);
        this.panel.add((Component)this.text.asJComponent(), "Center");
        this.panel.add((Component)this.statusbar, "South");
        Document textDocument = this.text.getJTextComponent().getDocument();
        textDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JTextEditorRSyntaxTextArea.this.changeListeners.fireEvent(new ChangeEvent((Object)JTextEditorRSyntaxTextArea.this));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JTextEditorRSyntaxTextArea.this.changeListeners.fireEvent(new ChangeEvent((Object)JTextEditorRSyntaxTextArea.this));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JTextEditorRSyntaxTextArea.this.changeListeners.fireEvent(new ChangeEvent((Object)JTextEditorRSyntaxTextArea.this));
            }
        });
        this.text.addUpdateCaretPositionActionListener(e -> {
            JTextEditor.UpdateCaretPositionActionEvent event = (JTextEditor.UpdateCaretPositionActionEvent)e;
            this.statusbar.setPosition(event.getLine(), event.getColumn());
        });
        FindReplaceSearchListener findReplaceSearchListener = new FindReplaceSearchListener();
        this.findDialog = new FindDialog((Dialog)null, (SearchListener)findReplaceSearchListener);
        this.replaceDialog = new ReplaceDialog((Dialog)null, (SearchListener)findReplaceSearchListener);
        this.gotoDialog = new GoToDialog((Dialog)null);
        SearchContext searchContext = this.findDialog.getSearchContext();
        this.replaceDialog.setSearchContext(searchContext);
    }

    public JTextEditorRSyntaxTextArea() {
        this(null);
    }

    private void addMenuItem(JMenu menu, String text, ActionListener listener) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(listener);
        item.setEnabled(true);
        menu.add(item);
    }

    private void saveFile(File file) {
        try {
            FileUtils.write((File)file, (CharSequence)this.text.getText(), (Charset)StandardCharsets.UTF_8);
            this.saved = true;
        }
        catch (IOException ex) {
            LOGGER.warn("Can't save file (" + Objects.toString(file) + ")", (Throwable)ex);
        }
    }

    private void doOpenFile() {
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        FileDialogChooser open = manager.create("TextEditorLastFile");
        open.showOpenDialog(null);
        File file = open.getSelectedFile();
        try {
            this.openedFile = file;
            String s = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            this.text.setText(s);
            this.opened = true;
        }
        catch (IOException ex) {
            LOGGER.warn("Can't open file (" + Objects.toString(file) + ")", (Throwable)ex);
        }
    }

    private void doSaveFile() {
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        FileDialogChooser save = manager.create("TextEditorLastFile");
        File file = save.getSelectedFile();
        if (!this.opened && !this.saved) {
            save.showSaveDialog(null);
            if (file.exists()) {
                int confirmationResult = JOptionPane.showConfirmDialog(this.panel, "Replace existing file?");
                if (confirmationResult == 0) {
                    this.saveFile(file);
                }
            } else {
                this.saveFile(file);
            }
        } else {
            try {
                FileUtils.write((File)this.openedFile, (CharSequence)this.text.getText(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                LOGGER.warn("Can't save file (" + Objects.toString(file) + ")", (Throwable)ex);
            }
        }
    }

    private void doSaveAsFile() {
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        FileDialogChooser saveAs = manager.create("TextEditorLastFile");
        saveAs.showSaveDialog(null);
        File filename = saveAs.getSelectedFile();
        if (filename.exists()) {
            int confirmationResult = JOptionPane.showConfirmDialog(this.panel, "Replace existing file?");
            if (confirmationResult == 0) {
                this.saveFile(filename);
            }
        } else {
            this.saveFile(filename);
        }
    }

    private void doClose() {
        this.panel.setVisible(false);
    }

    private void doSelectAll() {
        this.text.getJTextComponent().selectAll();
    }

    private void doCopy() {
        this.text.getJTextComponent().copy();
    }

    private void doPaste() {
        this.text.getJTextComponent().paste();
    }

    private void doCut() {
        this.text.getJTextComponent().cut();
    }

    public void setMimetype(String mimeType) {
        this.mimeType = mimeType;
        this.text.setContentType(mimeType);
    }

    public String getMimetype() {
        return this.mimeType;
    }

    public void setContents(byte[] contents) {
        this.setContents(new String(contents, StandardCharsets.UTF_8));
    }

    public void setContents(String text) {
        Tika tika = new Tika();
        String mimetype = tika.detect(text.getBytes());
        if (StringUtils.equalsIgnoreCase((CharSequence)mimetype, (CharSequence)"text/plain") && StringUtils.containsAny((CharSequence)text, (CharSequence)"{[")) {
            JsonStructure x;
            try {
                StringReader sr = new StringReader(text);
                JsonReader reader = Json.createReader((Reader)sr);
                x = reader.read();
            }
            catch (Exception ex) {
                x = null;
            }
            if (x != null) {
                mimetype = "text/json";
            }
        }
        this.setMimetype(mimetype);
        this.text.setText(text);
    }

    public void setContents(Object data) {
        if (data instanceof String) {
            this.setContents((String)data);
            return;
        }
        if (data instanceof byte[]) {
            this.setContents((byte[])data);
            return;
        }
        super.setContents(data);
    }

    public String getContents() {
        return this.text.getText();
    }

    public byte[] getBytes() {
        return this.text.getText().getBytes(StandardCharsets.UTF_8);
    }

    public void clean() {
        this.setContents("");
    }

    public JTextComponent getJTextComponent() {
        return this.text.getJTextComponent();
    }

    public void selectLine(int line) {
        JTextComponent editor = this.getJTextComponent();
        editor.requestFocusInWindow();
        String code = editor.getText();
        int lineCounter = 0;
        int initialSelection = 0;
        int finalSelection = 0;
        for (int j = 0; j < code.length(); ++j) {
            if (code.charAt(j) != '\n') continue;
            if (++lineCounter == line - 1) {
                initialSelection = j;
            }
            if (lineCounter != line && (finalSelection != 0 || j != code.length() - 1)) continue;
            finalSelection = j;
        }
        editor.select(initialSelection, finalSelection);
    }

    public void gotoline(int i) {
        this.text.gotoline(i);
    }

    public int getLineCount() {
        JTextComponent textComponent = this.getJTextComponent();
        Element map = textComponent.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    public void addUpdateCaretPositionActionListener(ActionListener al) {
        this.text.addUpdateCaretPositionActionListener(al);
    }

    public boolean isModified() {
        return true;
    }

    public JComponent asJComponent() {
        return this.panel;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListeners.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListeners.hasChangeListeners();
    }

    private void message(String msg) {
        this.statusbar.message(msg);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public boolean support(String name) {
        switch (name) {
            case "insert": {
                return true;
            }
        }
        return super.support(name);
    }

    public boolean insert(int pos, String text) {
        try {
            int l = this.text.getText().length();
            if (pos < 0 || pos > l) {
                pos = l;
            }
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            Document doc = this.text.getJTextComponent().getDocument();
            doc.insertString(pos, text, attrs);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Can't insert text at position " + pos, ex);
        }
        return true;
    }

    private static class StatusBar
    extends JPanel {
        private JLabel message;
        private JLabel position;

        public StatusBar() {
            this.initComponents();
        }

        private void initComponents() {
            this.message = new JLabel("");
            this.position = new JLabel("Line 0:0");
            this.setLayout(new BorderLayout());
            this.add((Component)this.message, "West");
            this.add((Component)this.position, "East");
        }

        public void clear() {
            this.message.setText("");
        }

        public void message(String message) {
            this.message.setText(message);
        }

        public void setPosition(int line) {
            this.setPosition(line, -1);
        }

        public void setPosition(int line, int column) {
            if (line < 0) {
                this.position.setText("");
                return;
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (column < 0) {
                this.position.setText(i18n.getTranslation("Line") + " " + line + ":0");
            } else {
                this.position.setText(i18n.getTranslation("Line") + " " + line + ":" + column);
            }
        }

        public JComponent asJComponent() {
            return this;
        }
    }

    private class FindReplaceSearchListener
    implements SearchListener {
        private FindReplaceSearchListener() {
        }

        public void searchEvent(SearchEvent e) {
            SearchResult result;
            RSyntaxTextArea textArea = (RSyntaxTextArea)JTextEditorRSyntaxTextArea.this.getJTextComponent();
            if (textArea == null) {
                return;
            }
            SearchEvent.Type type = e.getType();
            SearchContext context = e.getSearchContext();
            switch (type) {
                default: {
                    result = SearchEngine.markAll((RTextArea)textArea, (SearchContext)context);
                    break;
                }
                case FIND: {
                    result = SearchEngine.find((JTextArea)textArea, (SearchContext)context);
                    if (result.wasFound()) break;
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                    break;
                }
                case REPLACE: {
                    result = SearchEngine.replace((RTextArea)textArea, (SearchContext)context);
                    if (result.wasFound()) break;
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                    break;
                }
                case REPLACE_ALL: {
                    result = SearchEngine.replaceAll((RTextArea)textArea, (SearchContext)context);
                    JOptionPane.showMessageDialog(null, result.getCount() + " occurrences replaced.");
                }
            }
            String text = result.wasFound() ? "Text found; occurrences marked: " + result.getMarkedCount() : (type == SearchEvent.Type.MARK_ALL ? (result.getMarkedCount() > 0 ? "Occurrences marked: " + result.getMarkedCount() : "") : "Text not found");
            JTextEditorRSyntaxTextArea.this.message(text);
        }

        public String getSelectedText() {
            RSyntaxTextArea textArea = (RSyntaxTextArea)JTextEditorRSyntaxTextArea.this.getJTextComponent();
            if (textArea == null) {
                return "";
            }
            return textArea.getSelectedText();
        }
    }
}

