/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.scale;

import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class ScaleEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    public static final String KEY_ORIGIN_CENTER = "_Key_origin_center";
    public static final String ORIGIN_CENTER = "_Origin_center";
    private static final String PROPORTIONAL_SCALE_QUESTION = "_Proportional_scale_question";
    private static final String PROPORTIONAL_SCALE = "_Proportional_scale";
    private static final String YES = "_yes";
    private static final String NO = "_no";
    private static final String SHORT_YES = "_short_yes";
    private static final String SHORT_NO = "_short_no";
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter proportionalModeParameter;
    private final EditingServiceParameter originPointParameter;
    private String center;
    private final EditingServiceParameter scaleFactorOrReferencePointParameter;
    private final EditingServiceParameter secondScalePointParameter;
    private final EditingServiceParameter verticalScaleFactorParameter;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private List<Feature> selectedFeatures;

    public ScaleEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.selectionParameter = new DefaultEditingServiceParameter("selection", i18nManager.getTranslation("selection"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        DefaultEditingServiceParameterOptions options = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation(ORIGIN_CENTER), (Object)ORIGIN_CENTER, i18nManager.getTranslation(KEY_ORIGIN_CENTER));
        String consoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage("_Origin_point", (EditingServiceParameterOptions)options);
        this.originPointParameter = new DefaultEditingServiceParameter("_Origin_point", consoleMsg, (EditingServiceParameterOptions)options, null, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.OPTION});
        this.scaleFactorOrReferencePointParameter = new DefaultEditingServiceParameter("_Scale_factor_or_reference_point", i18nManager.getTranslation("_Horizontal_scale_factor_or_reference_point"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION});
        this.verticalScaleFactorParameter = new DefaultEditingServiceParameter("_Vertical_scale_factor", i18nManager.getTranslation("_Vertical_scale_factor"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.secondScalePointParameter = new DefaultEditingServiceParameter("_Second_scale_point", i18nManager.getTranslation("_Second_scale_point"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        DefaultEditingServiceParameterOptions proportionalModeOptions = new DefaultEditingServiceParameterOptions().add(YES, (Object)true, i18nManager.getTranslation(SHORT_YES)).add(NO, (Object)false, i18nManager.getTranslation(SHORT_NO));
        String proportionalModeConsoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(PROPORTIONAL_SCALE_QUESTION, (EditingServiceParameterOptions)proportionalModeOptions);
        this.proportionalModeParameter = new DefaultEditingServiceParameter(PROPORTIONAL_SCALE, proportionalModeConsoleMsg, (EditingServiceParameterOptions)proportionalModeOptions, (Object)true, true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.selectionParameter);
        list.add(this.originPointParameter);
        list.add(this.secondScalePointParameter);
        list.add(this.proportionalModeParameter);
        list.add(this.scaleFactorOrReferencePointParameter);
        list.add(this.verticalScaleFactorParameter);
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.selectionParameter) {
            if (!(value instanceof FeatureSelection)) return;
            this.values.put(param, value);
            this.selectedFeatures = this.getSelectedFeaturesCopy((FeatureSelection)value);
            return;
        } else if (param == this.originPointParameter) {
            if (value == null) {
                this.center = null;
                this.values.remove(param);
                return;
            } else if (value instanceof Point) {
                this.values.put(param, value);
                this.center = null;
                return;
            } else {
                if (!(value instanceof String)) return;
                if (ORIGIN_CENTER.equalsIgnoreCase((String)param.getOptions2().getValue(value, param.getDefaultValue()))) {
                    this.center = ORIGIN_CENTER;
                    GeometryManager geomManager = GeometryLocator.getGeometryManager();
                    FeatureSelection selected = (FeatureSelection)this.values.get(this.selectionParameter);
                    if (selected == null || selected.isEmpty()) return;
                    try {
                        int subType = this.getProviderServices().getSubType(this.featureStore);
                        Envelope envelope = geomManager.createEnvelope(subType);
                        for (Feature feature : selected) {
                            Envelope featEnv = feature.getDefaultEnvelope();
                            envelope.add(featEnv);
                        }
                        if (envelope.isEmpty()) return;
                        Point theCenter = geomManager.createPoint(envelope.getCenter(0), envelope.getCenter(1), subType);
                        this.values.put(param, theCenter);
                        return;
                    }
                    catch (DataException | CreateEnvelopeException | CreateGeometryException ex) {
                        throw new InvalidEntryException(ex);
                    }
                } else {
                    this.center = null;
                    this.values.remove(param);
                }
            }
            return;
        } else if (param == this.scaleFactorOrReferencePointParameter) {
            if (value instanceof Point) {
                if (((Point)value).equals((Point)this.values.get(this.originPointParameter))) {
                    throw new InvalidEntryException(null);
                }
                this.values.put(param, value);
                return;
            } else {
                if (!(value instanceof Double)) return;
                if ((Double)value == 0.0) {
                    throw new InvalidEntryException(null);
                }
                this.values.put(param, value);
            }
            return;
        } else if (param == this.secondScalePointParameter) {
            if (!(value instanceof Point)) return;
            this.values.put(param, value);
            return;
        } else if (param == this.proportionalModeParameter) {
            boolean proportionalMode = (Boolean)param.getOptions2().getValue(value, param.getDefaultValue());
            this.values.put(param, proportionalMode);
            return;
        } else {
            if (param != this.verticalScaleFactorParameter) return;
            if (!(value instanceof Double)) throw new InvalidEntryException(null);
            if ((Double)value == 0.0) {
                throw new InvalidEntryException(null);
            }
            this.values.put(param, value);
        }
    }

    public EditingServiceParameter next() {
        boolean proportionalModeValue = (Boolean)this.values.get(this.proportionalModeParameter);
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.originPointParameter) == null) {
            return this.originPointParameter;
        }
        if (this.values.get(this.scaleFactorOrReferencePointParameter) == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            if (proportionalModeValue) {
                this.scaleFactorOrReferencePointParameter.setDescription(i18nManager.getTranslation("_Scale_factor_or_reference_point"));
            } else {
                this.scaleFactorOrReferencePointParameter.setDescription(i18nManager.getTranslation("_Horizontal_scale_factor_or_reference_point"));
            }
            return this.scaleFactorOrReferencePointParameter;
        }
        if (this.values.get(this.scaleFactorOrReferencePointParameter) instanceof Point) {
            if (this.values.get(this.secondScalePointParameter) == null) {
                return this.secondScalePointParameter;
            }
        } else if (!proportionalModeValue && this.values.get(this.verticalScaleFactorParameter) == null) {
            return this.verticalScaleFactorParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        block20: {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            IMarkerSymbol ruleMarkerSymbol = (IMarkerSymbol)editingProviderManager.getSymbol("rule-marker-symbol");
            IMarkerSymbol verticalRuleMarkerSymbol = (IMarkerSymbol)editingProviderManager.getSymbol("vertical-rule-marker-symbol");
            ViewPort vp = this.mapContext.getViewPort();
            DecimalFormat format = new DecimalFormat("0.00");
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subType = editingProviderServices.getSubType(this.featureStore);
                boolean proportional = (Boolean)this.values.get(this.proportionalModeParameter);
                if (!CollectionUtils.isNotEmpty(this.selectedFeatures)) break block20;
                Point origin = (Point)this.values.get(this.originPointParameter);
                if (origin != null) {
                    Object scaleFactorOrReferencePointValue = this.values.get(this.scaleFactorOrReferencePointParameter);
                    Double horizontalScale = 1.0;
                    Double verticalScale = 1.0;
                    if (scaleFactorOrReferencePointValue != null) {
                        if (scaleFactorOrReferencePointValue instanceof Double) {
                            horizontalScale = (Double)scaleFactorOrReferencePointValue;
                            if (proportional) {
                                verticalScale = horizontalScale;
                            }
                        } else if (scaleFactorOrReferencePointValue instanceof Point) {
                            Object secondScalePointValue;
                            double horizontalUnity = ((Point)scaleFactorOrReferencePointValue).getX() - origin.getX();
                            double verticalUnity = ((Point)scaleFactorOrReferencePointValue).getY() - origin.getY();
                            this.createRule(drawingStatus, origin, horizontalUnity, horizontalUnity, false, subType);
                            if (!proportional) {
                                this.createRule(drawingStatus, origin, verticalUnity, verticalUnity, true, subType);
                            }
                            if ((secondScalePointValue = this.values.get(this.secondScalePointParameter)) != null && secondScalePointValue instanceof Point) {
                                double horizontalRawScale = ((Point)secondScalePointValue).getX() - origin.getX();
                                horizontalScale = horizontalRawScale / horizontalUnity;
                                this.createRule(drawingStatus, origin, horizontalUnity, horizontalRawScale, false, subType);
                                Point horizontalMarker = geometryManager.createPoint(origin.getX() + horizontalRawScale, origin.getY(), subType);
                                drawingStatus.addStatus((Geometry)horizontalMarker, (ISymbol)ruleMarkerSymbol, "");
                                ISimpleTextSymbol textSymbol = this.getTextSymbol();
                                Point horizontalTextPoint = geometryManager.createPoint(horizontalMarker.getX() - vp.toMapDistance(10), horizontalMarker.getY() - vp.toMapDistance(20), subType);
                                drawingStatus.addStatus((Geometry)horizontalTextPoint, (ISymbol)textSymbol, format.format((double)Math.round(horizontalScale * 100.0) / 100.0));
                                if (proportional) {
                                    verticalScale = horizontalScale;
                                    double verticalRawScale = horizontalRawScale;
                                } else {
                                    double verticalRawScale = ((Point)secondScalePointValue).getY() - origin.getY();
                                    verticalScale = verticalRawScale / verticalUnity;
                                    this.createRule(drawingStatus, origin, verticalUnity, verticalRawScale, true, subType);
                                    Point verticalMarker = geometryManager.createPoint(origin.getX(), origin.getY() + verticalRawScale, subType);
                                    drawingStatus.addStatus((Geometry)verticalMarker, (ISymbol)verticalRuleMarkerSymbol, "");
                                    Point verticalTextPoint = geometryManager.createPoint(verticalMarker.getX() - vp.toMapDistance(verticalScale < 0.0 ? 40 : 35), verticalMarker.getY() - vp.toMapDistance(4), subType);
                                    drawingStatus.addStatus((Geometry)verticalTextPoint, (ISymbol)textSymbol, format.format((double)Math.round(verticalScale * 100.0) / 100.0));
                                }
                            } else {
                                AffineTransform at;
                                double horizontalRawScale = mousePosition.getX() - origin.getX();
                                horizontalScale = horizontalRawScale / horizontalUnity;
                                this.createRule(drawingStatus, origin, horizontalUnity, horizontalRawScale, false, subType);
                                Point horizontalMarker = geometryManager.createPoint(origin.getX() + horizontalRawScale, origin.getY(), subType);
                                drawingStatus.addStatus((Geometry)horizontalMarker, (ISymbol)ruleMarkerSymbol, "");
                                ISimpleTextSymbol textSymbol = this.getTextSymbol();
                                Point horizontalTextPoint = geometryManager.createPoint(horizontalMarker.getX() - vp.toMapDistance(10), horizontalMarker.getY() - vp.toMapDistance(20), subType);
                                drawingStatus.addStatus((Geometry)horizontalTextPoint, (ISymbol)textSymbol, format.format((double)Math.round(horizontalScale * 100.0) / 100.0));
                                if (proportional) {
                                    verticalScale = horizontalScale;
                                    double verticalRawScale = horizontalRawScale;
                                } else {
                                    double verticalRawScale = mousePosition.getY() - origin.getY();
                                    verticalScale = verticalRawScale / verticalUnity;
                                    this.createRule(drawingStatus, origin, verticalUnity, verticalRawScale, true, subType);
                                    Point verticalMarker = geometryManager.createPoint(origin.getX(), origin.getY() + verticalRawScale, subType);
                                    drawingStatus.addStatus((Geometry)verticalMarker, (ISymbol)verticalRuleMarkerSymbol, "");
                                    Point verticalTextPoint = geometryManager.createPoint(verticalMarker.getX() - vp.toMapDistance(verticalScale < 0.0 ? 40 : 35), verticalMarker.getY() - vp.toMapDistance(4), subType);
                                    drawingStatus.addStatus((Geometry)verticalTextPoint, (ISymbol)textSymbol, format.format((double)Math.round(verticalScale * 100.0) / 100.0));
                                }
                                try {
                                    at = this.getScaleAffineTransform(origin, horizontalScale, verticalScale);
                                }
                                catch (Exception e) {
                                    throw new DrawServiceException((Throwable)e);
                                }
                                this.applyTransformToDrawingStatus(drawingStatus, this.selectedFeatures, at);
                            }
                        }
                    } else if (proportional) {
                        double unity = mousePosition.getX() - origin.getX();
                        this.createRule(drawingStatus, origin, unity, unity, false, subType);
                    } else {
                        double horizontalUnity = mousePosition.getX() - origin.getX();
                        this.createRule(drawingStatus, origin, horizontalUnity, horizontalUnity, false, subType);
                        double verticalUnity = mousePosition.getY() - origin.getY();
                        this.createRule(drawingStatus, origin, verticalUnity, verticalUnity, true, subType);
                    }
                }
                return drawingStatus;
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return null;
    }

    private Line createLineFromAPointWithLenght(Point origin, double length, int subType, boolean vertical) throws CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Line line = geometryManager.createLine(subType);
        line.addVertex(origin);
        Point p3 = vertical ? geometryManager.createPoint(origin.getX(), origin.getY() + length, subType) : geometryManager.createPoint(origin.getX() + length, origin.getY(), subType);
        line.addVertex(p3);
        return line;
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    private void createRule(DefaultDrawingStatus drawingStatus, Point point, double unity, double length, boolean vertical, int subType) throws CreateGeometryException {
        IMarkerSymbol ruleDecimalSymbol;
        IMarkerSymbol ruleUnitySymbol;
        if (unity == 0.0 || length == 0.0) {
            return;
        }
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        if (vertical) {
            ruleUnitySymbol = (IMarkerSymbol)editingProviderManager.getSymbol("vertical-rule-unity-symbol");
            ruleDecimalSymbol = (IMarkerSymbol)editingProviderManager.getSymbol("vertical-rule-decimal-symbol");
        } else {
            ruleUnitySymbol = (IMarkerSymbol)editingProviderManager.getSymbol("rule-unity-symbol");
            ruleDecimalSymbol = (IMarkerSymbol)editingProviderManager.getSymbol("rule-decimal-symbol");
        }
        ISymbol ruleAxisSymbol = editingProviderManager.getSymbol("rule-axis-symbol");
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        ViewPort vp = this.mapContext.getViewPort();
        Line line = this.createLineFromAPointWithLenght(point, length, subType, vertical);
        drawingStatus.addStatus((Geometry)line, ruleAxisSymbol, "");
        double pos = 0.0;
        int i = 0;
        while (Math.abs(pos) <= Math.abs(length) * 1.01) {
            Point mark = vertical ? geometryManager.createPoint(point.getX(), point.getY() + pos, subType) : geometryManager.createPoint(point.getX() + pos, point.getY(), subType);
            if (i % 10 == 0) {
                drawingStatus.addStatus((Geometry)mark, (ISymbol)ruleUnitySymbol, "");
                ISimpleTextSymbol textSymbol = this.getTextSymbol();
                Point textPoint = vertical ? geometryManager.createPoint(mark.getX() - vp.toMapDistance(pos < 0.0 ? 15 : 10), mark.getY() - vp.toMapDistance(3), subType) : geometryManager.createPoint(mark.getX() - vp.toMapDistance(3), mark.getY() - vp.toMapDistance(10), subType);
                drawingStatus.addStatus((Geometry)textPoint, (ISymbol)textSymbol, String.valueOf((int)Math.signum(length * unity) * i / 10));
            } else {
                drawingStatus.addStatus((Geometry)mark, (ISymbol)ruleDecimalSymbol, "");
            }
            pos += Math.signum(length) * Math.signum(unity) * unity / 10.0;
            ++i;
        }
    }

    private void applyTransformToDrawingStatus(DefaultDrawingStatus drawingStatus, List<Feature> selected, AffineTransform at) throws BaseException {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        for (Feature feature : selected) {
            ISymbol previewSymbol = this.getPreviewSymbol(feature);
            Geometry transformedGeometry = feature.getDefaultGeometry().cloneGeometry();
            transformedGeometry.transform(at);
            ISymbol symbol = null;
            if (transformedGeometry instanceof Curve || transformedGeometry instanceof MultiCurve) {
                symbol = lineSymbolEditing;
            } else if (transformedGeometry instanceof Surface || transformedGeometry instanceof MultiSurface) {
                symbol = polygonSymbolEditing;
            } else if (transformedGeometry instanceof Point || transformedGeometry instanceof MultiPoint) {
                symbol = auxiliaryPointSymbolEditing;
            }
            if (transformedGeometry instanceof Aggregate) {
                int primitivesNumber = ((Aggregate)transformedGeometry).getPrimitivesNumber();
                for (int i = 0; i < primitivesNumber; ++i) {
                    drawingStatus.addStatus((Geometry)((Aggregate)transformedGeometry).getPrimitiveAt(i), symbol, "");
                    drawingStatus.addStatus((Geometry)((Aggregate)transformedGeometry).getPrimitiveAt(i), previewSymbol, "");
                }
                continue;
            }
            drawingStatus.addStatus(transformedGeometry, symbol, "");
            drawingStatus.addStatus(transformedGeometry, previewSymbol, "");
        }
    }

    private AffineTransform getScaleAffineTransform(Point axisP1, Double horizontalScale, Double verticalScale) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(-axisP1.getX(), -axisP1.getY());
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(horizontalScale, verticalScale);
        AffineTransform inverseTranslate = AffineTransform.getTranslateInstance(axisP1.getX(), axisP1.getY());
        AffineTransform at = new AffineTransform(translate);
        at.preConcatenate(scaleTransform);
        at.preConcatenate(inverseTranslate);
        return at;
    }

    public void stop() {
        this.values.clear();
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public void finishAndStore() throws FinishServiceException {
        block16: {
            try {
                AffineTransform at;
                Object horizontalScaleFactorOrReferencePointValue;
                if (!CollectionUtils.isNotEmpty(this.selectedFeatures)) break block16;
                Point origin = (Point)this.values.get(this.originPointParameter);
                Double horizontalScale = null;
                Double verticalScale = null;
                boolean proportionalMode = (Boolean)this.values.get(this.proportionalModeParameter);
                if (origin != null && (horizontalScaleFactorOrReferencePointValue = this.values.get(this.scaleFactorOrReferencePointParameter)) != null) {
                    Object secondScalePointValue;
                    if (horizontalScaleFactorOrReferencePointValue instanceof Double) {
                        horizontalScale = (Double)horizontalScaleFactorOrReferencePointValue;
                        if (proportionalMode) {
                            verticalScale = horizontalScale;
                        } else {
                            Object verticalScaleFactorValue = this.values.get(this.verticalScaleFactorParameter);
                            if (verticalScaleFactorValue != null && verticalScaleFactorValue instanceof Double) {
                                verticalScale = (Double)verticalScaleFactorValue;
                            }
                        }
                    } else if (horizontalScaleFactorOrReferencePointValue instanceof Point && (secondScalePointValue = this.values.get(this.secondScalePointParameter)) != null && secondScalePointValue instanceof Point) {
                        double horizontalUnity = ((Point)horizontalScaleFactorOrReferencePointValue).getX() - origin.getX();
                        double horizontalRawScale = ((Point)secondScalePointValue).getX() - origin.getX();
                        horizontalScale = horizontalRawScale / horizontalUnity;
                        if (proportionalMode) {
                            verticalScale = horizontalScale;
                        } else {
                            double verticalUnity = ((Point)horizontalScaleFactorOrReferencePointValue).getY() - origin.getY();
                            double verticalRawScale = ((Point)secondScalePointValue).getY() - origin.getY();
                            verticalScale = verticalRawScale / verticalUnity;
                        }
                    }
                }
                if (origin == null || horizontalScale == null || verticalScale == null) break block16;
                try {
                    at = this.getScaleAffineTransform(origin, horizontalScale, verticalScale);
                }
                catch (GeometryOperationException | GeometryOperationNotSupportedException e) {
                    throw new FinishServiceException(e);
                }
                try {
                    for (Feature feature : this.selectedFeatures) {
                        Geometry geom = feature.getDefaultGeometry().cloneGeometry();
                        geom.transform(at);
                        EditableFeature editableFeature = feature.getEditable();
                        editableFeature.setDefaultGeometry(geom);
                        this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
                    }
                }
                catch (Exception e) {
                    throw new FinishServiceException((Throwable)e);
                }
                this.featureStore.getFeatureSelection().deselectAll();
                this.selectedFeatures = Collections.EMPTY_LIST;
            }
            catch (DataException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selectionParameter, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "modify-scale";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    public Object getValue(EditingServiceParameter parameter, EditingServiceParameter.TYPE type) {
        if (this.values == null) {
            return null;
        }
        if (parameter == this.scaleFactorOrReferencePointParameter) {
            Object value = this.values.get(parameter);
            if (type == EditingServiceParameter.TYPE.VALUE) {
                if (value instanceof Double) {
                    return value;
                }
                return null;
            }
        } else if (parameter == this.originPointParameter && type == EditingServiceParameter.TYPE.OPTION) {
            return this.center;
        }
        return this.values != null ? this.values.get(parameter) : null;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        if (parameter == this.proportionalModeParameter) {
            return true;
        }
        return true;
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.values.put(this.selectionParameter, null);
        this.selectedFeatures = Collections.EMPTY_LIST;
        this.values.put(this.originPointParameter, null);
        this.center = null;
        this.values.put(this.scaleFactorOrReferencePointParameter, null);
        this.values.put(this.secondScalePointParameter, null);
        this.values.put(this.verticalScaleFactorParameter, null);
    }
}

