/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.impl;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInstantTypeNotRegisteredException;
import org.gvsig.timesupport.AbsoluteInterval;
import org.gvsig.timesupport.AbsoluteIntervalType;
import org.gvsig.timesupport.AbsoluteIntervalTypeNotRegisteredException;
import org.gvsig.timesupport.Chronology;
import org.gvsig.timesupport.Duration;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.Time;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.timesupport.impl.DefaultAbsoluteInstant;
import org.gvsig.timesupport.impl.DefaultDuration;
import org.gvsig.timesupport.impl.DefaultRelativeInstant;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAbsoluteInterval
implements AbsoluteInterval {
    static final long MILLIS_BY_SECOND = 1000L;
    static final long MILLIS_BY_MINUTE = 60000L;
    static final long MILLIS_BY_HOUR = 3600000L;
    static final long MILLIS_BY_DAY = 86400000L;
    static final long MILLIS_BY_MONTH = 2592000000L;
    static final long MILLIS_BY_YEAR = 946080000000L;
    private static Logger LOG = LoggerFactory.getLogger(DefaultAbsoluteInterval.class);
    private Period jodaPeriod = null;
    private AbsoluteInstant startAbsoluteInstant = null;
    private AbsoluteInstant endAbsoluteInstant = null;
    private AbsoluteIntervalType[] absoluteIntervalTypes = null;
    private Chronology chronology = null;
    private static final TimeSupportManager timeSupportManager = TimeSupportLocator.getManager();

    DefaultAbsoluteInterval(AbsoluteInstant startPartial, int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, Chronology chronology) throws AbsoluteIntervalTypeNotRegisteredException {
        this(years, months, weeks, days, hours, minutes, seconds, millis, chronology);
        this.initilizePartials(((DefaultAbsoluteInstant)startPartial).getJodaType());
    }

    DefaultAbsoluteInterval(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, Chronology chronology) throws AbsoluteIntervalTypeNotRegisteredException {
        this.jodaPeriod = new Period(years, months, weeks, days, hours, minutes, seconds, millis);
        this.absoluteIntervalTypes = new AbsoluteIntervalType[8];
        this.absoluteIntervalTypes[0] = timeSupportManager.getAbsoluteIntervalType(0);
        this.absoluteIntervalTypes[1] = timeSupportManager.getAbsoluteIntervalType(1);
        this.absoluteIntervalTypes[2] = timeSupportManager.getAbsoluteIntervalType(2);
        this.absoluteIntervalTypes[3] = timeSupportManager.getAbsoluteIntervalType(3);
        this.absoluteIntervalTypes[4] = timeSupportManager.getAbsoluteIntervalType(4);
        this.absoluteIntervalTypes[5] = timeSupportManager.getAbsoluteIntervalType(5);
        this.absoluteIntervalTypes[6] = timeSupportManager.getAbsoluteIntervalType(6);
        this.absoluteIntervalTypes[7] = timeSupportManager.getAbsoluteIntervalType(7);
        this.chronology = chronology;
        this.initilizePartials();
    }

    DefaultAbsoluteInterval(AbsoluteInstant startAbsoluteInstant, AbsoluteInstant endAbsoluteInstant, Chronology chronology) {
        this.jodaPeriod = new Period(startAbsoluteInstant.toStandardDuration().getMillis(), endAbsoluteInstant.toStandardDuration().getMillis());
        this.chronology = chronology;
        this.startAbsoluteInstant = startAbsoluteInstant;
        this.endAbsoluteInstant = endAbsoluteInstant;
    }

    DefaultAbsoluteInterval(RelativeInstant startPeriod, RelativeInstant endPeriod, Chronology chronology) {
        this.jodaPeriod = new Period((ReadableInstant)((DefaultRelativeInstant)startPeriod).getJodaType(), (ReadableInstant)((DefaultRelativeInstant)endPeriod).getJodaType());
        this.chronology = chronology;
        this.initilizePartials();
    }

    DefaultAbsoluteInterval(Chronology chronology, Period period) {
        this.jodaPeriod = period;
        this.chronology = chronology;
        this.initilizePartials();
    }

    DefaultAbsoluteInterval(AbsoluteInstant startPartial, AbsoluteInstant endPartial) {
        this.startAbsoluteInstant = startPartial;
        this.endAbsoluteInstant = endPartial;
        this.jodaPeriod = new Period(endPartial.getYears() - startPartial.getYears(), 0, endPartial.getMonths() - startPartial.getMonths(), endPartial.getDays() - startPartial.getDays(), endPartial.getHours() - startPartial.getHours(), endPartial.getMinutes() - startPartial.getMinutes(), endPartial.getSeconds() - startPartial.getSeconds(), endPartial.getMillis() - startPartial.getMillis());
    }

    private void initilizePartials() {
        this.startAbsoluteInstant = new DefaultAbsoluteInstant(this.chronology);
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (this.jodaPeriod.getYears() > 0) {
            types.add(5);
            values.add(this.jodaPeriod.getYears());
        }
        if (this.jodaPeriod.getMonths() > 0) {
            types.add(7);
            values.add(this.jodaPeriod.getMonths());
        }
        if (this.jodaPeriod.getWeeks() > 0) {
            types.add(11);
            values.add(this.jodaPeriod.getWeeks());
        }
        if (this.jodaPeriod.getDays() > 0) {
            types.add(8);
            values.add(this.jodaPeriod.getDays());
        }
        if (this.jodaPeriod.getHours() > 0) {
            types.add(17);
            values.add(this.jodaPeriod.getHours());
        }
        if (this.jodaPeriod.getMinutes() > 0) {
            types.add(19);
            values.add(this.jodaPeriod.getMinutes());
        }
        if (this.jodaPeriod.getSeconds() > 0) {
            types.add(21);
            values.add(this.jodaPeriod.getSeconds());
        }
        if (this.jodaPeriod.getMillis() > 0) {
            types.add(23);
            values.add(this.jodaPeriod.getMillis());
        }
        int[] nativeTypes = new int[types.size()];
        int[] nativeValues = new int[values.size()];
        for (int i = 0; i < types.size(); ++i) {
            nativeTypes[i] = (Integer)types.get(i);
            nativeValues[i] = (Integer)values.get(i);
        }
        try {
            this.endAbsoluteInstant = timeSupportManager.createAbsoluteInstant(nativeTypes, nativeValues, this.chronology);
        }
        catch (AbsoluteInstantTypeNotRegisteredException e) {
            LOG.error("Impossible to create the endPartial for a period", (Throwable)e);
        }
    }

    private void initilizePartials(Partial jodaPartial) {
        this.startAbsoluteInstant = new DefaultAbsoluteInstant(this.chronology, jodaPartial);
        DateTimeFieldType[] dateTimeFieldTypes = jodaPartial.getFieldTypes();
        int[] jodaValues = jodaPartial.getValues();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (this.jodaPeriod.getYears() > 0) {
            types.add(5);
            values.add(this.jodaPeriod.getYears());
        }
        if (this.jodaPeriod.getMonths() > 0) {
            types.add(7);
            values.add(this.jodaPeriod.getMonths());
        }
        if (this.jodaPeriod.getDays() > 0) {
            types.add(8);
            values.add(this.jodaPeriod.getDays());
        }
        if (this.jodaPeriod.getHours() > 0) {
            types.add(17);
            values.add(this.jodaPeriod.getHours());
        }
        if (this.jodaPeriod.getMinutes() > 0) {
            types.add(19);
            values.add(this.jodaPeriod.getMinutes());
        }
        if (this.jodaPeriod.getSeconds() > 0) {
            types.add(21);
            values.add(this.jodaPeriod.getSeconds());
        }
        if (this.jodaPeriod.getMillis() > 0) {
            types.add(23);
            values.add(this.jodaPeriod.getMillis());
        }
        for (int i = 0; i < dateTimeFieldTypes.length; ++i) {
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.year())) {
                this.initializePartialsIteration(types, values, jodaValues[i], 5);
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.monthOfYear())) {
                this.initializePartialsIteration(types, values, jodaValues[i], 7);
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.dayOfMonth())) {
                this.initializePartialsIteration(types, values, jodaValues[i], 8);
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.hourOfDay())) {
                this.initializePartialsIteration(types, values, jodaValues[i], 17);
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.minuteOfHour())) {
                this.initializePartialsIteration(types, values, jodaValues[i], 19);
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.secondOfMinute())) {
                this.initializePartialsIteration(types, values, jodaValues[i], 21);
                continue;
            }
            if (!dateTimeFieldTypes[i].equals(DateTimeFieldType.millisOfSecond())) continue;
            this.initializePartialsIteration(types, values, jodaValues[i], 23);
        }
        int[] nativeTypes = new int[types.size()];
        int[] nativeValues = new int[values.size()];
        for (int i = 0; i < types.size(); ++i) {
            nativeTypes[i] = (Integer)types.get(i);
            nativeValues[i] = (Integer)values.get(i);
        }
        try {
            this.endAbsoluteInstant = timeSupportManager.createAbsoluteInstant(nativeTypes, nativeValues, this.chronology);
        }
        catch (AbsoluteInstantTypeNotRegisteredException e) {
            LOG.error("Impossible to create the endPartial for a period", (Throwable)e);
        }
    }

    private void initializePartialsIteration(List types, List values, int jodaValue, int dateTimefieldtype) {
        boolean found = false;
        for (int j = 0; j < types.size(); ++j) {
            if (!types.get(j).equals(dateTimefieldtype)) continue;
            int value = (Integer)values.get(j);
            values.remove(j);
            values.add(j, value + jodaValue);
            found = true;
            break;
        }
        if (!found) {
            types.add(dateTimefieldtype);
            values.add(jodaValue);
        }
    }

    public int size() {
        return this.jodaPeriod.size();
    }

    public AbsoluteIntervalType getFieldType(int index) {
        return this.absoluteIntervalTypes[index];
    }

    public int getValue(int index) {
        return this.jodaPeriod.getValue(index);
    }

    public String toString() {
        return this.jodaPeriod.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultAbsoluteInterval)) {
            return false;
        }
        return ((DefaultAbsoluteInterval)obj).getJodaType().equals((Object)this.jodaPeriod);
    }

    Period getJodaType() {
        return this.jodaPeriod;
    }

    public Chronology getChronology() {
        return this.chronology;
    }

    public int getYears() {
        return this.jodaPeriod.getYears();
    }

    public int getMonths() {
        return this.jodaPeriod.getMonths();
    }

    public int getWeeks() {
        return this.jodaPeriod.getWeeks();
    }

    public int getDays() {
        return this.jodaPeriod.getDays();
    }

    public int getHours() {
        return this.jodaPeriod.getHours();
    }

    public int getMinutes() {
        return this.jodaPeriod.getMinutes();
    }

    public int getSeconds() {
        return this.jodaPeriod.getSeconds();
    }

    public int getMillis() {
        return this.jodaPeriod.getMillis();
    }

    public boolean isAfter(AbsoluteInterval period) {
        return this.jodaPeriod.getMillis() > period.getMillis();
    }

    public boolean isBefore(AbsoluteInterval period) {
        return this.jodaPeriod.getMillis() < period.getMillis();
    }

    public Object clone() throws CloneNotSupportedException {
        return new DefaultAbsoluteInterval(this.chronology, new Period((Object)this.jodaPeriod));
    }

    public AbsoluteInstant getStart() {
        return this.startAbsoluteInstant;
    }

    public AbsoluteInstant getEnd() {
        return this.endAbsoluteInstant;
    }

    public final boolean isRelative() {
        return false;
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isInterval() {
        return true;
    }

    public final boolean isInstant() {
        return false;
    }

    public boolean intersects(Time time) {
        if (time.isAbsolute()) {
            if (time.isInterval()) {
                return this.intersects((AbsoluteInterval)time);
            }
            return this.contains((Instant)((AbsoluteInstant)time));
        }
        return true;
    }

    public boolean intersects(AbsoluteInterval absoluteInsterInterval) {
        return this.getStart().isAfter((Instant)absoluteInsterInterval.getStart()) && this.getEnd().isBefore((Instant)absoluteInsterInterval.getStart()) || this.getEnd().isBefore((Instant)absoluteInsterInterval.getEnd()) && this.getEnd().isAfter((Instant)absoluteInsterInterval.getEnd());
    }

    public boolean contains(Instant instant) {
        if (instant.isAbsolute()) {
            return this.getMillis() >= ((AbsoluteInstant)instant).getMillis();
        }
        return false;
    }

    public Duration toStandardDuration() {
        long millis = 0L;
        millis += (long)this.getYears() * 946080000000L;
        millis += (long)this.getMonths() * 2592000000L;
        millis += (long)this.getDays() * 946080000000L;
        millis += (long)this.getHours() * 3600000L;
        millis += (long)this.getMinutes() * 60000L;
        millis += (long)this.getSeconds() * 1000L;
        return new DefaultDuration(millis += (long)this.getMillis());
    }
}

