/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.impl;

import org.gvsig.timesupport.Chronology;
import org.gvsig.timesupport.Duration;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.Time;
import org.gvsig.timesupport.impl.DefaultChronology;
import org.gvsig.timesupport.impl.DefaultDuration;
import org.gvsig.timesupport.impl.DefaultRelativeInstant;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class DefaultRelativeInterval
implements RelativeInterval {
    private Interval jodaInterval = null;
    private Chronology chronology = null;

    DefaultRelativeInterval(long startInstant, long endInstant, Chronology chronology) {
        this.jodaInterval = new Interval(startInstant, endInstant, ((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
    }

    DefaultRelativeInterval(RelativeInstant startInstant, RelativeInstant endInstant, Chronology chronology) {
        this(startInstant.toMillis(), endInstant.toMillis(), chronology);
    }

    DefaultRelativeInterval(Chronology chronology, Interval interval) {
        this.jodaInterval = interval;
        this.chronology = chronology;
    }

    public long toDurationMillis() {
        return this.jodaInterval.toDurationMillis();
    }

    public boolean contains(RelativeInstant instant) {
        return this.jodaInterval.contains((ReadableInstant)((DefaultRelativeInstant)instant).getJodaType());
    }

    public boolean isAfter(RelativeInstant instant) {
        return this.jodaInterval.isAfter((ReadableInstant)((DefaultRelativeInstant)instant).getJodaType());
    }

    public boolean isAfter(RelativeInterval interval) {
        return this.jodaInterval.isAfter((ReadableInterval)((DefaultRelativeInterval)interval).getJodaType());
    }

    public boolean isBefore(RelativeInstant instant) {
        return this.jodaInterval.isBefore((ReadableInstant)((DefaultRelativeInstant)instant).getJodaType());
    }

    public boolean isBefore(RelativeInterval interval) {
        return this.jodaInterval.isBefore((ReadableInterval)((DefaultRelativeInterval)interval).getJodaType());
    }

    public Duration toDuration() {
        return new DefaultDuration(this.toDurationMillis());
    }

    Interval getJodaType() {
        return this.jodaInterval;
    }

    public String toString() {
        return this.jodaInterval.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultRelativeInterval)) {
            return false;
        }
        return ((DefaultRelativeInterval)obj).getJodaType().equals((Object)this.jodaInterval);
    }

    public boolean contains(RelativeInterval interval) {
        return this.jodaInterval.contains((ReadableInterval)((DefaultRelativeInterval)interval).getJodaType());
    }

    public boolean overlaps(RelativeInterval interval) {
        return this.jodaInterval.overlaps((ReadableInterval)((DefaultRelativeInterval)interval).getJodaType());
    }

    public Chronology getChronology() {
        return this.chronology;
    }

    public Object clone() throws CloneNotSupportedException {
        return new DefaultRelativeInterval(this.chronology, new Interval((Object)this.jodaInterval));
    }

    public RelativeInstant getStart() {
        return new DefaultRelativeInstant(this.chronology, this.jodaInterval.getStart());
    }

    public RelativeInstant getEnd() {
        return new DefaultRelativeInstant(this.chronology, this.jodaInterval.getEnd());
    }

    public boolean isRelative() {
        return true;
    }

    public final boolean isAbsolute() {
        return false;
    }

    public boolean isInterval() {
        return true;
    }

    public final boolean isInstant() {
        return false;
    }

    public boolean contains(Instant instant) {
        if (instant.isRelative()) {
            return this.contains((RelativeInstant)instant);
        }
        return false;
    }

    public boolean intersects(Time time) {
        if (time.isRelative()) {
            if (time.isInterval()) {
                return this.intersects((RelativeInterval)time);
            }
            return this.contains((RelativeInstant)time);
        }
        return false;
    }

    public boolean intersects(RelativeInterval relativeInterval) {
        return this.getStart().isAfter((Instant)relativeInterval.getStart()) && this.getEnd().isBefore((Instant)relativeInterval.getStart()) || this.getEnd().isBefore((Instant)relativeInterval.getEnd()) && this.getEnd().isAfter((Instant)relativeInterval.getEnd());
    }

    public Duration toStandardDuration() {
        return new DefaultDuration(this.jodaInterval.toDuration());
    }
}

