/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.api;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.EditorFactory;
import org.gvsig.scripting.swing.api.JEditor;

public abstract class AbstractEditorFactory
implements EditorFactory {
    private final String description;
    private final String name;

    protected AbstractEditorFactory(String name, String description) {
        this.name = StringUtils.isEmpty((CharSequence)name) ? this.getClass().getSimpleName() : name;
        this.description = StringUtils.isEmpty((CharSequence)description) ? "" : description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public JEditor create(ScriptingUnit unit) {
        if (this.canCreate(unit)) {
            return this.doCreate(unit);
        }
        throw new IllegalArgumentException();
    }

    protected abstract JEditor doCreate(ScriptingUnit var1);
}

