/*
 * Decompiled with CFR 0.152.
 */
package com.ermapper.ecw;

import com.ermapper.ecw.JNCSError;
import com.ermapper.ecw.JNCSException;
import com.ermapper.ecw.JNCSFileNotOpenException;
import com.ermapper.ecw.JNCSFileOpenFailedException;
import com.ermapper.ecw.JNCSInvalidSetViewException;
import com.ermapper.ecw.JNCSNativeLibraryException;
import com.ermapper.ecw.JNCSProgressiveUpdate;
import com.ermapper.util.JNCSDatasetPoint;
import com.ermapper.util.JNCSWorldPoint;

public class JNCSFile
implements JNCSProgressiveUpdate {
    private static boolean bUseNativeMethods = false;
    private static boolean bSecurityError = false;
    private static boolean bUnsatisfiedLink = false;
    static boolean bHaveClassInit = false;
    static boolean debug = false;
    public static final int ECW_CELL_UNITS_INVALID = 0;
    public static final int ECW_CELL_UNITS_METERS = 1;
    public static final int ECW_CELL_UNITS_DEGREES = 2;
    public static final int ECW_CELL_UNITS_FEET = 3;
    public int numBands;
    public int width;
    public int height;
    public double originX;
    public double originY;
    public double cellIncrementX;
    public double cellIncrementY;
    public int cellSizeUnits;
    public double compressionRate;
    public boolean progressive;
    public String fileName;
    public String datum;
    public String projection;
    public boolean bIsOpen;
    private long nativeDataPointer;
    private static final boolean doGarbageCollectionOnClose = false;
    private static final int ECW_OK = 0;
    private int nFileSetViewDatasetTLX;
    private int nFileSetViewDatasetTLY;
    private int nFileSetViewDatasetBRX;
    private int nFileSetViewDatasetBRY;
    private int nFileSetViewWidth;
    private int nFileSetViewHeight;
    private double dFileSetViewWorldTLX;
    private double dFileSetViewWorldTLY;
    private double dFileSetViewWorldBRX;
    private double dFileSetViewWorldBRY;
    private boolean bSetViewIsWorld = false;
    protected JNCSProgressiveUpdate progImageClient = null;

    private native int ECWOpen(String var1, boolean var2);

    private native int ECWOpenArray(String var1, boolean var2, byte[] var3);

    private native void ECWClose(boolean var1);

    private native int ECWSetView(int var1, int[] var2, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13, int var15, int var16);

    private native int ECWReadLineRGBA(int[] var1);

    private native int ECWReadImageRGBA(int[] var1, int var2, int var3);

    private native short ECWGetPercentComplete();

    private static native String ECWGetErrorString(int var0);

    private static native int NCSJNIInit();

    private static native String ECWGetLibVersion();

    static void initClass() throws JNCSNativeLibraryException {
        boolean flag = false;
        boolean flag1 = false;
        try {
            System.loadLibrary("jecw2.0.0");
            bUseNativeMethods = true;
            bUnsatisfiedLink = false;
            int i = JNCSFile.NCSJNIInit();
            if (i != 0) {
                System.err.println("JNCSFile classes found on PATH failed to initialize correctly. Attempting to locate other libecw.so....");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JNCSFile() throws JNCSException {
        JNCSFile.initClass();
        this.cellSizeUnits = 0;
        this.bIsOpen = false;
    }

    public JNCSFile(String s, boolean flag) throws JNCSException {
        JNCSFile.initClass();
        this.open(s, flag);
    }

    protected void finalize() throws Throwable {
        if (this.bIsOpen) {
            this.ECWClose(false);
        }
        super.finalize();
    }

    public int open(String s, boolean flag) throws JNCSFileOpenFailedException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int i = this.ECWOpenArray(s, flag, s.getBytes());
        if (i != 0) {
            this.bIsOpen = false;
            String s1 = JNCSError.getError(i);
            throw new JNCSFileOpenFailedException(s1);
        }
        this.bIsOpen = true;
        this.progressive = flag;
        return 0;
    }

    public void close(boolean flag) {
        this.ECWClose(flag);
        if (!flag) {
            // empty if block
        }
    }

    public void addProgressiveUpdateListener(JNCSProgressiveUpdate jncsprogressiveupdate) {
        this.progImageClient = jncsprogressiveupdate;
    }

    public void refreshUpdate(int i, int j, double d, double d1, double d2, double d3) {
        if (this.progImageClient != null) {
            this.progImageClient.refreshUpdate(i, j, d, d1, d2, d3);
        }
    }

    public void refreshUpdate(int i, int j, int k, int l, int i1, int j1) {
        if (this.progImageClient != null) {
            this.progImageClient.refreshUpdate(i, j, k, l, i1, j1);
        }
    }

    public int setView(int i, int[] ai, int j, int k, int l, int i1, int j1, int k1) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException("File not open");
        }
        if (ai == null) {
            throw new JNCSInvalidSetViewException("Wrong parameter value");
        }
        int l1 = this.ECWSetView(i, ai, j, k, l, i1, 0.0, 0.0, 0.0, 0.0, j1, k1);
        if (l1 != 0) {
            String s = JNCSError.getError(l1);
            throw new JNCSInvalidSetViewException(s);
        }
        this.bSetViewIsWorld = false;
        return 0;
    }

    public int setView(int nBands, int[] posBands, int iniX, int iniY, int endX, int endY, double tlX, double tlY, double brX, double brY, int bufW, int bufH) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException("File not open");
        }
        if (posBands == null) {
            throw new JNCSInvalidSetViewException("Wrong parameter value");
        }
        int l = this.ECWSetView(nBands, posBands, iniX, iniY, endX, endY, tlX, tlY, brX, brY, bufW, bufH);
        if (l != 0) {
            String s = JNCSError.getError(l);
            throw new JNCSInvalidSetViewException(s);
        }
        this.bSetViewIsWorld = true;
        return 0;
    }

    public int setView(int i, int[] ai, double d, double d1, double d2, double d3, int j, int k) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException("File not open");
        }
        if (ai == null) {
            throw new JNCSInvalidSetViewException("Wrong parameter value");
        }
        JNCSDatasetPoint jncsdatasetpoint = this.convertWorldToDataset(d, d1);
        JNCSDatasetPoint jncsdatasetpoint1 = this.convertWorldToDataset(d2, d3);
        int l = this.ECWSetView(i, ai, jncsdatasetpoint.x, jncsdatasetpoint.y, jncsdatasetpoint1.x - 1, jncsdatasetpoint1.y - 1, d, d1, d2, d3, j, k);
        if (l != 0) {
            String s = JNCSError.getError(l);
            throw new JNCSInvalidSetViewException(s);
        }
        this.bSetViewIsWorld = true;
        return 0;
    }

    public int readLineRGBA(int[] ai) throws JNCSException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException("File not open");
        }
        int i = this.ECWReadLineRGBA(ai);
        if (i != 0) {
            String s = JNCSError.getError(i);
            throw new JNCSException(s);
        }
        return 0;
    }

    public int readLineBGRA(int[] ai) throws JNCSException {
        throw new JNCSException("Not Yet Implemented!");
    }

    public int readLineBIL(int[] ai) throws JNCSException {
        throw new JNCSException("Not Yet Implemented!");
    }

    public int readLineBIL(double[] ad) throws JNCSException {
        throw new JNCSException("Not Yet Implemented!");
    }

    public int readImageRGBA(int[] ai, int i, int j) throws JNCSException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException("File not open");
        }
        int k = this.ECWReadImageRGBA(ai, i, j);
        if (k != 0) {
            String s = JNCSError.getError(k);
            throw new JNCSException(s);
        }
        return 0;
    }

    public String getLastErrorText(int i) {
        return JNCSError.getError(i);
    }

    public JNCSDatasetPoint convertWorldToDataset(double d, double d1) throws JNCSFileNotOpenException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException();
        }
        int i = (int)Math.round((d - this.originX) / this.cellIncrementX);
        int j = (int)Math.round((d1 - this.originY) / this.cellIncrementY);
        return new JNCSDatasetPoint(i, j);
    }

    public JNCSWorldPoint convertDatasetToWorld(int i, int j) throws JNCSFileNotOpenException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException();
        }
        double d = this.originX + (double)i * this.cellIncrementX;
        double d1 = this.originY + (double)j * this.cellIncrementY;
        return new JNCSWorldPoint(d, d1);
    }

    public short getPercentComplete() {
        return this.ECWGetPercentComplete();
    }

    public static String getLibVersion() {
        return JNCSFile.ECWGetLibVersion();
    }

    private static void debug(String s) {
        if (debug) {
            System.out.println(s);
        }
    }
}

