/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.scripting.DataFolderFound;
import org.gvsig.scripting.ScriptingBaseScript;
import org.gvsig.scripting.ScriptingDialog;
import org.gvsig.scripting.ScriptingExternalFile;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingScript;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.impl.DataFolderManager;
import org.gvsig.scripting.impl.DefaultScriptingDialog;
import org.gvsig.scripting.impl.DefaultScriptingExternalFile;
import org.gvsig.scripting.impl.DefaultScriptingExternalTextFile;
import org.gvsig.scripting.impl.DefaultScriptingFolder;
import org.gvsig.scripting.impl.DefaultScriptingScript;
import org.gvsig.scripting.impl.FileUtils;
import org.gvsig.scripting.impl.ScriptNotFoundException;
import org.gvsig.scripting.impl.ScriptingInstallerProviderFactory;
import org.gvsig.scripting.impl.SystemFolder;
import org.gvsig.scripting.impl.UserFolder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.packageutils.Version;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.service.spi.ProviderFactory;
import org.gvsig.tools.util.FolderSet;
import org.python.jsr223.MyPyScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptingManager
implements ScriptingManager {
    static final Logger LOG = LoggerFactory.getLogger(DefaultScriptingManager.class);
    protected Map<String, ImageIcon> icons;
    protected List<RegisterSystemFolder> systemFolders = new ArrayList<RegisterSystemFolder>();
    protected ScriptEngineManager engineManager = null;
    private final SimpleBindings bindings = new SimpleBindings();
    private List<String> unitTypes = null;
    private ClassLoader classLoader = null;
    private final List<File> libFolders = new ArrayList<File>();
    private File home = null;
    private final List<ScriptingFolder> alternativeUserFolders = new ArrayList<ScriptingFolder>();
    private Map<String, String> extensionOfLanguage = null;
    private Map<String, String> languageOfExtension = null;
    private File packagesFolder;
    private final Map properties = new HashMap();
    private final Map<String, ScriptEngine> engineGroups = new HashMap<String, ScriptEngine>();
    private DataFolderManager dataFolderManager = null;
    private ScriptingFolder userFolder = null;
    private ScriptingFolder systemFolder = null;
    private Tika tika;
    private static final Pattern RE_LANG = Pattern.compile(".*lang[:]\\s*([a-zA-Z_][a-zA-Z_0-9]*)");
    private static final Pattern RE_ENCODING = Pattern.compile(".*encoding[:]\\s*([a-zA-Z_][a-zA-Z_0-9]*)");
    private final Map<File, File> links = new HashMap<File, File>();

    public DefaultScriptingManager() {
        this.classLoader = this.getClass().getClassLoader();
        this.setHomeFolder(null);
        this.bindings.put("ScriptingManager", (Object)this);
    }

    public DefaultScriptingManager(ClassLoader classLoader) {
        this();
        this.classLoader = classLoader;
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void setProperty(Object key, Object val) {
        this.properties.put(key, val);
    }

    public Map getExtendedProperties() {
        return this.properties;
    }

    private void createFolder(File f) {
        if (!f.exists()) {
            try {
                FileUtils.forceMkdir(f);
                LOG.info("Created scripting folder '" + f.getAbsolutePath() + "'");
            }
            catch (Throwable e) {
                LOG.warn("Can't Create scripting folder '" + f.getAbsolutePath() + "'");
            }
        }
    }

    private void createDefaultFolders(File home) {
        this.createFolder(new File(home, "scripts"));
        this.createFolder(new File(home, "lib"));
        this.createFolder(new File(home, "data"));
    }

    public File getHomeFolder() {
        if (!this.home.exists()) {
            this.createFolder(this.home);
            this.createDefaultFolders(this.home);
        }
        return this.home;
    }

    public void setHomeFolder(File home) {
        this.home = home == null ? new File(System.getProperty("user.home"), ".gvsig-scripting") : home;
        this.createDefaultFolders(this.home);
        LOG.info("Set scripting home to '" + this.home.getAbsolutePath() + "'");
        this.addLibFolder(new File(this.home, "lib"));
        FilesResourcesStorage resourcesStorage = new FilesResourcesStorage(this.home.getAbsolutePath());
        ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getManager();
        expressionManager.setScriptsResourcesStorage((ResourcesStorage)resourcesStorage);
        DisposeUtils.disposeQuietly((Disposable)resourcesStorage);
    }

    private DataFolderManager getDataFolderManager() {
        if (this.dataFolderManager == null) {
            this.dataFolderManager = new DataFolderManager(this);
        }
        return this.dataFolderManager;
    }

    public File getDataFolder(String id) {
        return this.getDataFolderManager().getDataFolder(id);
    }

    public void registerDataFolder(ScriptingFolder folderScript, String id) {
        this.getDataFolderManager().registerDataFolder(folderScript, id);
    }

    public List<DataFolderFound> searchOldVersions(Version currentVersion, FolderSet folder) {
        return this.getDataFolderManager().searchOldVersions(currentVersion, folder);
    }

    protected synchronized ScriptEngineManager getEngineManager() {
        if (this.engineManager == null) {
            this.engineManager = this.classLoader == null ? new ScriptEngineManager() : new ScriptEngineManager(this.classLoader);
            this.showEnginesInfo(this.engineManager);
        }
        return this.engineManager;
    }

    private void showEnginesInfo(ScriptEngineManager mgr) {
        if (LOG.isInfoEnabled()) {
            List<ScriptEngineFactory> factories = mgr.getEngineFactories();
            StringBuilder buffer = new StringBuilder();
            ArrayList<String> values = new ArrayList<String>();
            buffer.append("Scripting engines available:");
            for (ScriptEngineFactory factory : factories) {
                buffer.append("\n- {}: version = {}, language = {}, langVersion = {}");
                values.add(factory.getEngineName());
                values.add(factory.getEngineVersion());
                values.add(factory.getLanguageName());
                values.add(factory.getLanguageVersion());
                buffer.append("\n\t- Aliases: ");
                List<String> engNames = factory.getNames();
                int size = engNames.size();
                for (String string : engNames) {
                    buffer.append("{}");
                    if (--size > 0) {
                        buffer.append(", ");
                    }
                    values.add(string);
                }
                buffer.append("\n\t- File extensions: ");
                List<String> extNames = factory.getExtensions();
                size = extNames.size();
                for (String name3 : extNames) {
                    buffer.append("{}");
                    if (--size > 0) {
                        buffer.append(", ");
                    }
                    values.add(name3);
                }
                buffer.append("\n\t- Mime types: ");
                List<String> list = factory.getMimeTypes();
                size = list.size();
                for (String name4 : list) {
                    buffer.append("{}");
                    if (--size > 0) {
                        buffer.append(", ");
                    }
                    values.add(name4);
                }
            }
            LOG.info(buffer.toString(), values.toArray());
        }
    }

    public synchronized void loadEngines() {
        this.getEngineManager();
    }

    private ScriptEngine createJythonEngine() {
        ScriptEngineFactory factory = this.getEngineFactoryByLanguage("python");
        MyPyScriptEngine engine = new MyPyScriptEngine(factory);
        return engine;
    }

    public ImageIcon getIcon(String name) {
        return this.icons.get(name);
    }

    public String getEngineNameByLanguage(String langName) {
        ScriptEngineFactory factory = this.getEngineFactoryByLanguage(langName);
        if (factory == null) {
            return null;
        }
        return factory.getEngineName();
    }

    public ScriptEngine getEngineByLanguage(String langName) {
        return this.getEngineByLanguage(langName, null);
    }

    public synchronized ScriptEngine getEngineByLanguage(String langName, String isolationGroup) {
        ScriptEngine engine = null;
        if (!StringUtils.isEmpty((CharSequence)isolationGroup)) {
            isolationGroup = isolationGroup + "-" + langName;
            engine = this.engineGroups.get(isolationGroup.toLowerCase());
        }
        if (engine == null) {
            if ("python".equalsIgnoreCase(langName)) {
                engine = this.createJythonEngine();
            } else {
                ScriptEngineFactory factory = this.getEngineFactoryByLanguage(langName);
                if (factory == null) {
                    return null;
                }
                engine = factory.getScriptEngine();
            }
            if (!StringUtils.isEmpty((CharSequence)isolationGroup)) {
                this.engineGroups.put(isolationGroup.toLowerCase(), engine);
            }
        }
        engine.getBindings(100).putAll(this.bindings);
        return engine;
    }

    public synchronized Set<String> getEnginesIsolationGroups() {
        return this.engineGroups.keySet();
    }

    public ScriptEngineFactory getEngineFactoryByLanguage(String langName) {
        List<ScriptEngineFactory> factories = this.getEngineManager().getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            if (!factory.getLanguageName().equalsIgnoreCase(langName)) continue;
            return factory;
        }
        return null;
    }

    public boolean validateUnitId(ScriptingFolder folder, String id) {
        File f = new File(folder.getFile(), id + ".inf");
        return !f.exists();
    }

    public ScriptingScript createScript(ScriptingFolder folder, String id) {
        return this.createScript(folder, id, null);
    }

    public Script createScript(String name, String code, String languaje) {
        DefaultScriptingScript script = new DefaultScriptingScript(this.getUserFolder(), this, name, languaje);
        script.setCode(code);
        script.setSaved(true);
        return script;
    }

    private ScriptingScript createScript(ScriptingFolder folder, String id, String language) {
        DefaultScriptingScript script = new DefaultScriptingScript(folder, this, id);
        if (!script.getFile().exists()) {
            script.create(folder, id, language);
        } else {
            script.load(folder, id);
        }
        return script;
    }

    public ScriptingDialog createDialog(ScriptingFolder folder, String id) {
        return this.createDialog(folder, id, null);
    }

    private ScriptingDialog createDialog(ScriptingFolder folder, String id, String language) {
        DefaultScriptingDialog dialog = new DefaultScriptingDialog(folder, this, id);
        if (!dialog.getFile().exists()) {
            dialog.create(folder, id, language);
        } else {
            dialog.load(folder, id);
        }
        return dialog;
    }

    public ScriptingFolder createFolder(ScriptingFolder folder, String id) {
        DefaultScriptingFolder unit = new DefaultScriptingFolder(folder, this, new File(folder.getFile(), id));
        unit.load(folder, id);
        if (!unit.getFile().exists()) {
            unit.create(folder, id);
        }
        return unit;
    }

    private Tika getTika() {
        if (this.tika == null) {
            this.tika = new Tika();
        }
        return this.tika;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMimeType(File file) {
        String string;
        FileInputStream is = null;
        BufferedInputStream bis = null;
        try {
            is = new FileInputStream(file);
            bis = new BufferedInputStream(is);
            Metadata metadata = new Metadata();
            MediaType type = this.getTika().getDetector().detect((InputStream)bis, metadata);
            string = type.getType();
            IOUtils.closeQuietly((InputStream)bis);
        }
        catch (Exception ex) {
            String string2 = null;
            return string2;
        }
        finally {
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    public ScriptingExternalFile createExternalFile(ScriptingFolder folder, String id) {
        DefaultScriptingExternalFile unit = StringUtils.equalsIgnoreCase((CharSequence)"text", (CharSequence)this.getMimeType(new File(folder.getFile(), id))) ? new DefaultScriptingExternalTextFile(folder, this, id) : new DefaultScriptingExternalFile(folder, this, id);
        if (unit.getExternalFile() != null && !unit.getExternalFile().exists()) {
            unit.create(folder, id);
        }
        return unit;
    }

    public ScriptingBaseScript getScript(File file) {
        ScriptingBaseScript script = (ScriptingBaseScript)this.getUnit(file);
        if (script == null) {
            throw new ScriptNotFoundException(file);
        }
        return script;
    }

    public Script loadScript(URI uri) {
        File f = new File(uri);
        try {
            return (Script)this.getScript(f);
        }
        catch (ScriptNotFoundException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new ScriptNotFoundException(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script loadScript(ResourcesStorage storage, String name) {
        Script script;
        String head;
        ResourcesStorage.Resource res;
        block11: {
            block10: {
                block9: {
                    res = null;
                    if (storage != null) break block9;
                    Script script2 = null;
                    IOUtils.closeQuietly(res);
                    return script2;
                }
                res = storage.getResource(name);
                if (res != null && res.exists()) break block10;
                Script script3 = null;
                IOUtils.closeQuietly((Closeable)res);
                return script3;
            }
            byte[] head_bytes = new byte[500];
            IOUtils.read((InputStream)res.asInputStream(), (byte[])head_bytes);
            IOUtils.closeQuietly((Closeable)res);
            head = new String(head_bytes);
            if (!StringUtils.isEmpty((CharSequence)head)) break block11;
            Script script4 = null;
            IOUtils.closeQuietly((Closeable)res);
            return script4;
        }
        try {
            Script script5;
            String s;
            head = head.split("\n")[0];
            String lang = "python";
            String encoding = null;
            Matcher m = RE_LANG.matcher(head);
            if (m.groupCount() == 1 && !StringUtils.isBlank((CharSequence)(s = m.group(1)))) {
                lang = s;
            }
            if ((m = RE_ENCODING.matcher(head)).groupCount() == 1 && !StringUtils.isBlank((CharSequence)(s = m.group(1)))) {
                encoding = s;
            }
            String source = StringUtils.isBlank(encoding) ? IOUtils.toString((InputStream)res.asInputStream()) : IOUtils.toString((InputStream)res.asInputStream(), encoding);
            script = script5 = this.createScript(name, source, lang);
        }
        catch (Exception ex) {
            Script script6;
            try {
                LOG.warn("Can't load script from resources storage.", (Throwable)ex);
                script6 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(res);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)res);
            return script6;
        }
        IOUtils.closeQuietly((Closeable)res);
        return script;
    }

    public ScriptingFolder getFolder(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file argument can't be null");
        }
        file = this.getLinkSource(file);
        if (FileUtils.isSameFile(this.getRootUserFolder(), file)) {
            return this.getUserFolder();
        }
        ScriptingFolder folder = (ScriptingFolder)this.getUnit(file);
        if (folder == null) {
            throw new IllegalArgumentException("Can't get ScriptFolder from '" + file.getAbsolutePath() + "'.");
        }
        return folder;
    }

    public ScriptingUnit getUnit(String pathName) {
        ScriptingUnit unit = null;
        Object[] parts = StringUtils.split((String)pathName, (char)'/');
        if (parts[0].equals(this.getUserFolder().getName())) {
            unit = this.getUserFolder().getUnit(StringUtils.join((Object[])parts, (String)"/", (int)1, (int)parts.length));
        } else if (parts[0].equals(this.getSystemFolder().getName())) {
            unit = this.getSystemFolder().getUnit(StringUtils.join((Object[])parts, (String)"/", (int)1, (int)parts.length));
        }
        return unit;
    }

    public ScriptingUnit getUnit(File file) {
        if (file.isAbsolute()) {
            Object folder = FileUtils.isSameFile(this.getRootUserFolder(), file.getParentFile()) ? this.getUserFolder() : new DefaultScriptingFolder(null, this, file.getParentFile());
            ScriptingUnit unit = folder.getUnit(file);
            return unit;
        }
        ScriptingFolder folder = this.getUserFolder();
        ScriptingUnit unit = folder.getUnit(file);
        if (unit != null) {
            return unit;
        }
        folder = this.getSystemFolder();
        unit = folder.getUnit(file);
        if (unit != null) {
            return unit;
        }
        return null;
    }

    public ScriptingFolder getSystemFolder() {
        if (this.systemFolder == null) {
            this.systemFolder = new SystemFolder(this);
        }
        return this.systemFolder;
    }

    public ScriptingFolder getUserFolder() {
        if (this.userFolder == null) {
            this.userFolder = new UserFolder(this, this.getRootUserFolder());
        }
        return this.userFolder;
    }

    public ScriptingBaseScript getScript(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (name.indexOf(47) < 0) {
            return (ScriptingBaseScript)this.findScript(null, name);
        }
        ScriptingUnit unit = this.getUserFolder().getUnit(name);
        if (unit != null) {
            return (ScriptingBaseScript)unit;
        }
        unit = this.getSystemFolder().getUnit(name);
        return (ScriptingBaseScript)unit;
    }

    public Script locateScript(String name) {
        try {
            ScriptingBaseScript script = this.getScript(name);
            if (script instanceof Script) {
                return (Script)script;
            }
        }
        catch (Exception ex) {
            LOG.debug("Can't locate script '" + Objects.toString(name) + "'.", (Throwable)ex);
        }
        return null;
    }

    private ScriptingUnit findScript(ScriptingFolder folder, String name) {
        if (name == null) {
            return null;
        }
        if (name.trim().length() == 0) {
            return null;
        }
        if (folder == null) {
            ScriptingUnit unit = this.findScript(this.getUserFolder(), name);
            if (unit != null) {
                return unit;
            }
            unit = this.findScript(this.getSystemFolder(), name);
            return unit;
        }
        List units = folder.getUnits();
        for (ScriptingUnit unit : units) {
            if (!(unit instanceof ScriptingFolder ? (unit = this.findScript((ScriptingFolder)unit, name)) != null : unit instanceof ScriptingBaseScript && name.equalsIgnoreCase(unit.getId()))) continue;
            return unit;
        }
        return null;
    }

    public File getRootUserFolder() {
        return new File(this.getHomeFolder(), "scripts");
    }

    public void registerSystemFolder(String name, File folder) {
        this.systemFolders.add(new RegisterSystemFolder(name, folder));
        LOG.info("Register system folder name '" + name + "' folder " + folder.getAbsolutePath() + "'");
    }

    public List<RegisterSystemFolder> getSystemFolders() {
        return this.systemFolders;
    }

    public List<ScriptingFolder> getAlternativeUserFolders() {
        return this.alternativeUserFolders;
    }

    public void addAlternativeUserFolder(File f, String name, String description) {
        UserFolder x = new UserFolder(this, f);
        x.setName(name);
        x.setDescription(description);
        x.setId("UserFolder_" + this.alternativeUserFolders.size() + 1);
        this.alternativeUserFolders.add(x);
    }

    private void initLanguages() {
        List<String> extensions;
        List<ScriptEngineFactory> factories;
        if (this.extensionOfLanguage == null) {
            HashMap<String, String> theExtensionOfLanguage = new HashMap<String, String>();
            factories = this.getEngineManager().getEngineFactories();
            for (ScriptEngineFactory factory : factories) {
                if ("ognl".equals(factory.getLanguageName()) || (extensions = factory.getExtensions()) == null || extensions.isEmpty()) continue;
                theExtensionOfLanguage.put(factory.getLanguageName().toLowerCase(), extensions.get(0).toLowerCase());
            }
            this.extensionOfLanguage = theExtensionOfLanguage;
        }
        if (this.languageOfExtension == null) {
            HashMap<String, String> theLanguageOfExtension = new HashMap<String, String>();
            factories = this.getEngineManager().getEngineFactories();
            for (ScriptEngineFactory factory : factories) {
                if ("ognl".equals(factory.getLanguageName()) || (extensions = factory.getExtensions()) == null) continue;
                for (String extension1 : extensions) {
                    theLanguageOfExtension.put(extension1.toLowerCase(), factory.getLanguageName().toLowerCase());
                }
            }
            this.languageOfExtension = theLanguageOfExtension;
        }
    }

    public String getExtensionOfLanguage(String langName) {
        if (langName == null) {
            return null;
        }
        langName = langName.toLowerCase();
        this.initLanguages();
        return this.extensionOfLanguage.get(langName);
    }

    public List<String> getSupportedLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        this.initLanguages();
        languages.addAll(this.extensionOfLanguage.keySet());
        Collections.sort(languages);
        return languages;
    }

    public String getLanguageOfExtension(String extension) {
        if (extension == null) {
            return null;
        }
        if ((extension = extension.toLowerCase()).startsWith(".")) {
            extension = extension.substring(1);
        }
        this.initLanguages();
        return this.languageOfExtension.get(extension);
    }

    public Object get(String key) {
        return this.bindings.get(key);
    }

    public void put(String key, Object value) {
        this.bindings.put(key, value);
    }

    public ScriptingUnit createUnit(String unitType, ScriptingFolder folder, String id) {
        return this.createUnit(unitType, folder, id, null);
    }

    public ScriptingUnit createUnit(String unitType, ScriptingFolder folder, String id, String language) {
        if (unitType.equals("Script")) {
            return this.createScript(folder, id, language);
        }
        if (unitType.equals("Dialog")) {
            return this.createDialog(folder, id, language);
        }
        if (unitType.equals("Folder")) {
            return this.createFolder(folder, id);
        }
        if (unitType.equals("ExternalFile")) {
            return this.createExternalFile(folder, id);
        }
        return null;
    }

    public List<String> getUnitTypes() {
        if (this.unitTypes == null) {
            this.unitTypes = new ArrayList<String>();
            this.unitTypes.add("Script");
            this.unitTypes.add("Dialog");
            this.unitTypes.add("Folder");
            this.unitTypes.add("ExternalFile");
        }
        return this.unitTypes;
    }

    public void addLibFolder(File lib) {
        if (lib.exists()) {
            LOG.info("Add scripting lib folder '" + lib.getAbsolutePath() + "'");
            this.libFolders.add(lib);
        } else {
            LOG.info("Skip add scripting lib folder '" + lib.getAbsolutePath() + "', folder don't exist");
        }
    }

    public List<File> getLibFolders() {
        return new ArrayList<File>(this.libFolders);
    }

    public Map<String, String> getLibFoldersVersions() {
        HashMap<String, String> versions = new HashMap<String, String>();
        List<File> folders = this.getLibFolders();
        for (File folder : folders) {
            File parent = folder.getParentFile();
            File libVersions = new File(parent, folder.getName() + ".versions");
            if (!libVersions.exists()) continue;
            this.loadLibVersions(versions, libVersions);
        }
        if (versions.isEmpty()) {
            return null;
        }
        return versions;
    }

    private void loadLibVersions(Map<String, String> versions, File file) {
        List<String> lines;
        try {
            lines = FileUtils.readLines(file);
        }
        catch (IOException ex) {
            LOG.warn("Can't load lib versions from '" + file + ".", (Throwable)ex);
            return;
        }
        for (String line : lines) {
            String[] x = line.split("=");
            if (x.length != 2) continue;
            versions.put(x[0], x[1]);
        }
    }

    public ProviderFactory getInstallerFactory() {
        return new ScriptingInstallerProviderFactory();
    }

    public File getPackagesFolder() {
        return this.packagesFolder;
    }

    public void setPackagesFolder(File folder) {
        this.packagesFolder = folder;
    }

    public ScriptingFolder createLink(String name, File link, String targetPathName) {
        StringBuilder contents = new StringBuilder();
        contents.append("[Unit]\n").append("type = Folder\n").append("name = ").append(name).append("\n").append("description =\n").append("createdBy =\n").append("version =\n").append("\n").append("[Folder]\n").append("path =").append(targetPathName).append("\n").append("\n\n");
        if (link.isDirectory()) {
            link = new File(link, name + ".inf");
        } else if (!link.getName().endsWith(".inf")) {
            link = new File(link.getPath() + ".inf");
        }
        if (!link.exists()) {
            try {
                FileUtils.writeStringToFile(link, contents.toString());
            }
            catch (IOException ex) {
                LOG.warn("Can't create ScriptingFolder file in '" + link.getAbsolutePath() + "'.", (Throwable)ex);
            }
        }
        ScriptingFolder folder = this.getFolder(link);
        return folder;
    }

    public ScriptingFolder createLink(String name, ScriptingFolder link, String targetPathName) {
        return this.createLink(name, link.getFile(), targetPathName);
    }

    public void addLink(File source, File target) {
        this.links.put(FileUtils.getRealFile(target), source);
    }

    public File getLinkSource(File target) {
        File source = this.links.get(FileUtils.getRealFile(target));
        if (source == null) {
            return target;
        }
        if (source.exists()) {
            return source;
        }
        return target;
    }

    public boolean isInUserFolder(File f) {
        if (FileUtils.isSubfolder(this.getRootUserFolder(), f)) {
            return true;
        }
        for (File file : this.links.keySet()) {
            if (!FileUtils.isSubfolder(file, f)) continue;
            return true;
        }
        return false;
    }

    public Evaluator createEvaluator(String expression) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        Expression exp = manager.createExpression();
        exp.setPhrase(expression);
        return manager.createExpressionEvaluator(exp);
    }

    public static class RegisterSystemFolder {
        public String name;
        public File folder;

        public RegisterSystemFolder(String name, File folder) {
            this.name = name;
            this.folder = folder;
        }
    }
}

