/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import groovy.lang.GroovyClassLoader;
import groovy.util.GroovyScriptEngine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.gvsig.scripting.CompileErrorException;
import org.gvsig.scripting.ExecuteErrorException;
import org.gvsig.scripting.Main;
import org.gvsig.scripting.ScriptingBaseScript;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingScript;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.impl.AbstractScript;
import org.gvsig.scripting.impl.BaseScriptingNotifycation;
import org.gvsig.scripting.impl.EncodingUtils;
import org.gvsig.scripting.impl.MutableURLClassLoader;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.ini4j.Ini;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTraceback;
import org.python.core.imp;
import org.python.jsr223.MyPyScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptingScript
extends AbstractScript
implements ScriptingScript {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultScriptingScript.class);
    protected String langName;
    protected String extension = null;
    protected String librarySuffix = null;
    protected ScriptEngine engine = null;
    protected CompiledScript compiledCode;
    protected boolean useSysPath = false;
    private String code = null;
    private String mainName = "main";
    private final DelegateWeakReferencingObservable delegatedObservable;
    private OutputWriter stdout;
    private OutputWriter stderr;

    protected DefaultScriptingScript(ScriptingFolder parent, String typename, ScriptingManager manager, String id) {
        super(parent, typename, manager, id);
        this.setLangName("python");
        this.setSaved(true);
        this.delegatedObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);
        this.stdout = new OutputWriter(System.out);
        this.stderr = new OutputWriter(System.err);
    }

    public DefaultScriptingScript(ScriptingFolder parent, ScriptingManager manager, String id) {
        this(parent, "Script", manager, id);
    }

    public DefaultScriptingScript(ScriptingFolder parent, ScriptingManager manager, String id, String langName) {
        this(parent, "Script", manager, id);
        if (!StringUtils.isBlank((CharSequence)langName)) {
            this.setLangName(langName);
        }
    }

    @Override
    public int hashCode() {
        File f = this.getFile();
        if (f != null) {
            return "#$FILE$#".hashCode() + f.getAbsolutePath().hashCode();
        }
        String s = this.getId();
        if (s != null) {
            return "#$ID$#".hashCode() + s.hashCode();
        }
        s = this.getCode();
        if (s != null) {
            return "#$CODE$#".hashCode() + s.hashCode();
        }
        return super.hashCode();
    }

    public void addStdoutWriter(Writer out) {
        this.stdout.addWriter(out);
    }

    public void addStderrWriter(Writer err) {
        this.stderr.addWriter(err);
    }

    public void removeStdoutWriter(Writer out) {
        this.stdout.removeWriter(out);
    }

    public void removeStderrWriter(Writer err) {
        this.stdout.removeWriter(err);
    }

    public Object __getattr__(String name) {
        try {
            ScriptEngine theEngine = this.getEngine();
            this.compile();
            return theEngine.get(name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void __setattr__(String name, Object value) {
        ScriptEngine theEngine = this.getEngine();
        this.compile();
        theEngine.put(name, value);
    }

    public Object __call__() {
        return this.run();
    }

    public Object __call__(Object[] args) {
        return this.run(args);
    }

    public OutputWriter getStdout() {
        return this.stdout;
    }

    public OutputWriter getStderr() {
        return this.stderr;
    }

    protected void notifyErrors(Exception exception, String command) {
        this.delegatedObservable.notifyObservers((Object)new BaseScriptingNotifycation(this, 1, command, exception));
    }

    public String getCode() {
        if (this.code == null) {
            File f = null;
            try {
                f = this.getFileResource(this.extension);
                Charset encoding = Charsets.toCharset((String)EncodingUtils.getEncoding(f));
                this.code = FileUtils.readFileToString((File)f, (Charset)encoding);
            }
            catch (IOException e) {
                String fname = f == null ? "(null)" : f.getAbsolutePath();
                LOGGER.warn("Can't load code from file '" + fname + "'.");
            }
        }
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.engine = null;
        this.compiledCode = null;
        this.setSaved(false);
    }

    public String getLibrarySuffix() {
        return this.librarySuffix;
    }

    public void setLibrarySuffix(String librarySuffix) {
        this.librarySuffix = librarySuffix;
    }

    public List<File> getLibFolders() {
        List<File> folders = this.manager.getLibFolders();
        String suffix = this.getLibrarySuffix();
        if (suffix == null) {
            return folders;
        }
        for (int i = 0; i < folders.size(); ++i) {
            File folder = folders.get(i);
            File f = new File(folder.getParentFile(), folder.getName() + suffix);
            if (!f.exists()) continue;
            folders.set(i, f);
        }
        return folders;
    }

    protected String getCodeToInitializeEngine() {
        String initName = "org/gvsig/scripting/langs/" + this.getLangName().toLowerCase() + "/init.txt";
        try {
            InputStream template = this.getClass().getClassLoader().getResourceAsStream(initName);
            if (template == null) {
                return null;
            }
            List lines = IOUtils.readLines((InputStream)template);
            return StringUtils.join((Iterable)lines, (String)"\n");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't load code to initialize the script from '" + initName + ".", (Throwable)ex);
            return null;
        }
    }

    private List<URL> getClassPath() {
        HashSet<URL> classPath = new HashSet<URL>();
        try {
            ScriptingFolder folders2;
            URL url;
            if (StringUtils.isEmpty((CharSequence)this.getIsolationGroup())) {
                url = this.getFile().getParentFile().getCanonicalFile().toURI().toURL();
                classPath.add(url);
            }
            url = this.getManager().getUserFolder().getFile().getCanonicalFile().toURI().toURL();
            classPath.add(url);
            List<File> folders = this.getLibFolders();
            if (folders != null) {
                for (File folder : folders) {
                    url = folder.getAbsoluteFile().toURI().toURL();
                    classPath.add(url);
                }
            }
            if ((folders2 = this.getManager().getSystemFolder()) != null) {
                for (ScriptingUnit folder : folders2.getUnits()) {
                    url = folder.getFile().getCanonicalFile().toURI().toURL();
                    classPath.add(url);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<URL>(classPath);
    }

    private void addClassPathToEngine(ScriptEngine engine, List<URL> classPath) {
        block6: {
            block4: {
                ClassLoader loader;
                block7: {
                    PySystemState sys;
                    block5: {
                        if (!(engine instanceof MyPyScriptEngine)) break block4;
                        sys = Py.getSystemState();
                        if (!this.useSysPath) break block5;
                        LinkedHashSet<PyString> paths = new LinkedHashSet<PyString>();
                        for (int i = 0; i < sys.path.size(); ++i) {
                            String path = (String)sys.path.get(i);
                            if (path.equals("__pyclasspath__/") || path.equals("__classpath__")) continue;
                            paths.add(Py.newString((String)path));
                        }
                        for (URL url : classPath) {
                            String path = FileUtils.toFile((URL)url).getAbsolutePath();
                            paths.add(Py.newString((String)path));
                        }
                        paths.add(Py.newString((String)"__classpath__"));
                        paths.add(Py.newString((String)"__pyclasspath__/"));
                        sys.path.addAll(paths);
                        break block6;
                    }
                    loader = sys.getClassLoader();
                    if (loader != null) break block7;
                    ClassLoader parentClassLoader = imp.getParentClassLoader();
                    loader = new MutableURLClassLoader(classPath, parentClassLoader);
                    sys.setClassLoader(loader);
                    break block6;
                }
                if (!(loader instanceof MutableURLClassLoader)) break block6;
                ((MutableURLClassLoader)loader).addUrls(classPath);
                break block6;
            }
            if (engine instanceof GroovyScriptEngine) {
                GroovyClassLoader loader = ((GroovyScriptEngine)engine).getGroovyClassLoader();
                HashSet<URL> urls = new HashSet<URL>();
                urls.addAll(Arrays.asList(loader.getURLs()));
                for (URL url : classPath) {
                    if (urls.contains(url)) continue;
                    loader.addURL(url);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngine getEngine() {
        if (this.engine == null) {
            ScriptingManager scriptingManager = this.getManager();
            synchronized (scriptingManager) {
                ScriptEngine scriptEngine = this.manager.getEngineByLanguage(this.langName, this.getIsolationGroup());
                this.addClassPathToEngine(scriptEngine, this.getClassPath());
                scriptEngine.put("script", this);
                scriptEngine.put("Main", Main.class);
                scriptEngine.getContext().setWriter(this.stdout);
                scriptEngine.getContext().setErrorWriter(this.stderr);
                this.engine = scriptEngine;
                String theCode = this.getCodeToInitializeEngine();
                if (theCode != null) {
                    try {
                        this.engine.eval(theCode);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't initialize engine with the code:\n" + theCode, (Throwable)ex);
                    }
                }
            }
        }
        return this.engine;
    }

    @Override
    protected void loadInf(Ini prefs) {
        super.loadInf(prefs);
        this.setMainName((String)this.getInfValue(prefs, "Script", "main", "main"));
        this.setLangName((String)this.getInfValue(prefs, "Script", "Lang", this.getLangName()));
        this.setLibrarySuffix((String)this.getInfValue(prefs, "Script", "LibraryVersion", null));
        this.useSysPath = this.getInfBoolean(prefs, "Script", "useSysPath", false);
    }

    @Override
    public void load(ScriptingFolder folder, String id) {
        File f;
        this.setId(id);
        this.setParent(folder);
        String theExtension = FilenameUtils.getExtension((String)id);
        if (theExtension != null) {
            String language = this.manager.getLanguageOfExtension(theExtension);
            if (language != null) {
                this.setLangName(language);
            }
            this.setExtension(theExtension);
        }
        if ((f = this.getFileResource(".inf")).isFile()) {
            Ini prefs = null;
            try {
                prefs = new Ini(f);
            }
            catch (Exception e) {
                LOGGER.warn("Can't load 'inf' file '" + f.getAbsolutePath() + "'.", (Throwable)e);
            }
            this.loadInf(prefs);
        }
        this.setCode(null);
        this.setSaved(true);
    }

    public void save() {
        this.saveInfo();
        File fcode = this.getFileResource(this.getExtension());
        try {
            String text = this.getCode();
            Charset encoding = Charsets.toCharset((String)EncodingUtils.getEncoding(text));
            FileUtils.write((File)fcode, (CharSequence)text, (Charset)encoding);
        }
        catch (Exception e) {
            LOGGER.warn("Can't write code to file '" + fcode.getAbsolutePath() + "'.", (Throwable)e);
        }
        this.setSaved(true);
    }

    private void saveInfo() {
        File f = this.getFileResource(".inf");
        if (!f.isFile()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                LOGGER.warn("Can't create 'inf' file '" + f.getAbsolutePath() + "'.", (Throwable)e);
            }
        }
        Ini prefs = null;
        try {
            prefs = new Ini(f);
        }
        catch (Exception e) {
            LOGGER.warn("Can't load 'inf' file '" + f.getAbsolutePath() + "'.", (Throwable)e);
        }
        this.save(prefs);
    }

    @Override
    protected void save(Ini prefs) {
        super.save(prefs);
        prefs.put("Script", "main", (Object)this.getMainName());
        prefs.put("Script", "Lang", (Object)this.getLangName());
        if (this.useSysPath) {
            prefs.put("Script", "useSysPath", (Object)this.useSysPath);
        }
        try {
            prefs.store();
        }
        catch (IOException e) {
            String fname = prefs.getFile() == null ? "(null)" : prefs.getFile().getAbsolutePath();
            LOGGER.warn("Can't save inf file (" + fname + ").", (Throwable)e);
        }
    }

    public String getLangName() {
        return this.langName;
    }

    protected void setLangName(String langName) {
        if (langName == null) {
            return;
        }
        this.langName = langName;
        this.setExtension(this.manager.getExtensionOfLanguage(this.langName));
    }

    public String[] getIconNames() {
        return new String[]{"scripting-icon-" + this.getLangName().toLowerCase(), "scripting-icon-" + this.getLangName().toLowerCase() + "-open"};
    }

    public String getMainName() {
        return this.mainName;
    }

    public void setMainName(String mainName) {
        this.mainName = mainName;
    }

    public List<File> getFiles() {
        ArrayList<File> l = new ArrayList<File>();
        l.add(this.getScriptFile());
        return l;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = !extension.startsWith(".") ? "." + extension : extension;
    }

    public void addObserver(Observer o) {
        this.delegatedObservable.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.delegatedObservable.deleteObserver(o);
    }

    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    public void put(String name, Object value) {
        this.getEngine().put(name, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compile() {
        if (this.compiledCode != null) return;
        ScriptEngine theEngine = this.getEngine();
        if (theEngine instanceof Compilable) {
            try {
                Compilable compilable = (Compilable)((Object)theEngine);
                String theCode = this.getCode();
                if ("python".equalsIgnoreCase(this.getLangName())) {
                    theCode = theCode.replaceFirst("^\\s*#([^:\\n]*)coding:", "#$1 c-o-d-i-n-g:");
                }
                this.compiledCode = compilable.compile(theCode);
                if (!(theEngine instanceof Invocable)) return;
                this.compiledCode.eval();
                return;
            }
            catch (ScriptException e) {
                Object[] location = this.getLocation(e);
                CompileErrorException ce = new CompileErrorException(e.getMessage(), (File)location[0], ((Integer)location[1]).intValue(), ((Integer)location[2]).intValue(), (Throwable)e);
                this.notifyErrors((Exception)ce, "compile");
                throw ce;
            }
            catch (Throwable e) {
                CompileErrorException ce = new CompileErrorException(e.getMessage(), this.getScriptFile(), e);
                this.notifyErrors(new Exception(e), "compile");
                throw ce;
            }
        }
        String theCode = this.getCode();
        try {
            theEngine.eval(theCode);
            return;
        }
        catch (ScriptException e) {
            Object[] location = this.getLocation(e);
            CompileErrorException ce = new CompileErrorException(e.getMessage(), (File)location[0], ((Integer)location[1]).intValue(), ((Integer)location[2]).intValue(), (Throwable)e);
            this.notifyErrors((Exception)ce, "compile");
            throw ce;
        }
    }

    public void addDisposable(Disposable disposable) {
    }

    public Object main() {
        return this.run(null);
    }

    public Object main(Object ... args) {
        return this.run(args);
    }

    public Object run() {
        return this.run(null);
    }

    public Object run(Object[] args) {
        if (!this.isEnabled()) {
            System.err.printf("The script '" + this.getName() + "' is not enabled, see properties page to change.\n", new Object[0]);
            return null;
        }
        if (args == null) {
            args = new Object[]{};
        }
        this.compile();
        return this.invokeFunction(this.getMainName(), args);
    }

    public Object invokeFunction(String name, Object[] args) {
        try {
            if (this.getEngine() instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)this.getEngine());
                this.compile();
                if (args == null) {
                    args = new Object[]{};
                }
                return invocable.invokeFunction(name, args);
            }
            if (this.compiledCode != null) {
                Object x = this.compiledCode.eval();
                if (x instanceof Main) {
                    return ((Main)x).main(args);
                }
                if (x instanceof Runnable) {
                    ((Runnable)x).run();
                }
            }
            return null;
        }
        catch (ScriptException e) {
            Object[] location = this.getLocation(e);
            ExecuteErrorException ee = new ExecuteErrorException(e.getMessage(), (File)location[0], ((Integer)location[1]).intValue(), ((Integer)location[2]).intValue(), (Throwable)e);
            this.notifyErrors((Exception)((Object)ee), "invoke");
            throw ee;
        }
        catch (Error | Exception e) {
            ExecuteErrorException ee = new ExecuteErrorException(e.getMessage(), this.getScriptFile(), e);
            this.notifyErrors((Exception)((Object)ee), "invoke");
            throw ee;
        }
    }

    public File getScriptFile() {
        return this.getFileResource(this.extension);
    }

    private Object[] getLocation(ScriptException e) {
        Throwable[] es;
        for (Throwable t : es = ExceptionUtils.getThrowables((Throwable)e)) {
            if (!(t instanceof PyException)) continue;
            try {
                PyException pyex = (PyException)t;
                PyTraceback tb = pyex.traceback;
                if (tb == null) continue;
                while (tb.tb_next != null) {
                    tb = (PyTraceback)tb.tb_next;
                }
                String s = tb.tb_frame.f_globals.__getitem__((PyObject)new PyString("__file__")).asString();
                if (s.endsWith("$py.class")) {
                    s = s.substring(0, s.length() - 9) + ".py";
                    File resource = new File(s);
                    return new Object[]{resource, tb.tb_lineno, 0};
                }
                return new Object[]{this.getScriptFile(), tb.tb_lineno, 0};
            }
            catch (Exception ex) {
                Exception exception = ex;
            }
        }
        int column = e.getColumnNumber();
        if (column < 0) {
            column = 0;
        }
        return new Object[]{this.getScriptFile(), e.getLineNumber(), column};
    }

    public Object invokeMethod(Object obj, String name, Object[] args) throws NoSuchMethodException {
        if (this.getEngine() instanceof Invocable) {
            Invocable invocable = (Invocable)((Object)this.getEngine());
            this.compile();
            if (args == null) {
                args = new Object[]{};
            }
            try {
                return invocable.invokeMethod(obj, name, args);
            }
            catch (ScriptException e) {
                ExecuteErrorException ee = new ExecuteErrorException(e.getMessage(), this.getScriptFile(), e.getLineNumber(), e.getColumnNumber(), (Throwable)e);
                this.notifyErrors((Exception)((Object)ee), "invoke");
                throw ee;
            }
            catch (Throwable e) {
                ExecuteErrorException ee = new ExecuteErrorException(e.getMessage(), this.getScriptFile(), e);
                this.notifyErrors((Exception)((Object)ee), "invoke");
                throw ee;
            }
        }
        return null;
    }

    public File getResource(String filename) {
        return new File(this.getParent().getFile(), filename);
    }

    public String getMimeType() {
        return "text/" + this.getLangName();
    }

    @Override
    protected void console_println(String s) {
        super.console_println(s);
        try {
            this.stdout.write(s + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void runAsTask(Object[] args) {
        if (!this.isEnabled()) {
            System.err.printf("The script '" + this.getName() + "' is not enabled, see properties page to change.\n", new Object[0]);
            return;
        }
        ScriptTask task = new ScriptTask(this, args);
        task.start();
    }

    public boolean remove() {
        boolean r = true;
        File folder = this.getParent().getFile();
        File f = new File(folder, this.getId() + ".inf");
        try {
            FileUtils.forceDelete((File)f);
        }
        catch (IOException e) {
            LOGGER.warn("Can't remove inf file '" + f.getAbsolutePath() + "'.", (Throwable)e);
            r = false;
        }
        try {
            f = new File(folder, this.getId() + this.getExtension());
            FileUtils.forceDelete((File)f);
        }
        catch (IOException e) {
            LOGGER.warn("Can't remove code file '" + f.getAbsolutePath() + "'.", (Throwable)e);
            r = false;
        }
        return r;
    }

    @Override
    public void create(ScriptingFolder folder, String id, String language) {
        this.setParent(folder);
        this.setId(id);
        if (language == null) {
            this.setLangName("python");
        } else {
            this.setLangName(language);
        }
        this.setExtension(this.manager.getExtensionOfLanguage(this.getLangName()));
        File file = new File(folder.getFile(), this.id + ".inf");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            LOGGER.warn("Can't create file of the dialog in '" + file.getAbsolutePath() + "'.", (Throwable)e);
        }
        File fcode = this.getFileResource(this.getExtension());
        if (fcode.exists()) {
            this.saveInfo();
        } else {
            String template = this.getNewTemplate();
            if (template != null) {
                this.setCode(template);
            }
            this.save();
        }
    }

    public String getNewTemplate() {
        String theTemplateName = "org/gvsig/scripting/langs/" + this.getLangName().toLowerCase() + "/new_template.txt";
        try {
            InputStream template = this.getClass().getClassLoader().getResourceAsStream(theTemplateName);
            if (template == null) {
                return null;
            }
            List lines = IOUtils.readLines((InputStream)template);
            return StringUtils.join((Iterable)lines, (String)"\n");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't load new-template from '" + theTemplateName + "'.", (Throwable)ex);
            return null;
        }
    }

    public ScriptingUnit get(String name) {
        return this.manager.getScript(name);
    }

    public ScriptingUnit get(File file) {
        return this.manager.getScript(file);
    }

    public boolean move(ScriptingFolder target) {
        if (!this.manager.validateUnitId(target, this.getId())) {
            LOGGER.info("Can't move script '" + this.getId() + "' to '" + target.getFile().getAbsolutePath() + "', is not valid.");
            return false;
        }
        if (!this.isSaved()) {
            LOGGER.info("Can't move script '" + this.getId() + "', is not saved.");
            return false;
        }
        try {
            File codefile = this.getFileResource(this.extension);
            FileUtils.moveFileToDirectory((File)this.getFile(), (File)target.getFile(), (boolean)true);
            FileUtils.moveFileToDirectory((File)codefile, (File)target.getFile(), (boolean)true);
            this.parent = target;
            this.load(target, this.id);
        }
        catch (IOException ex) {
            LOGGER.info("Can't move script '" + this.getId() + "' to '" + target.getFile().getAbsolutePath() + "', " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean rename(String newId) {
        if (!this.manager.validateUnitId(this.getParent(), newId)) {
            LOGGER.info("Can't rename script '" + this.getId() + "', target id '" + newId + "' is not valid.");
            return false;
        }
        if (!this.isSaved()) {
            LOGGER.info("Can't rename script '" + this.getId() + "', is not saved.");
            return false;
        }
        try {
            ScriptingFolder target = this.getParent();
            File codefile = this.getFileResource(this.extension);
            FileUtils.moveFile((File)this.getFile(), (File)new File(target.getFile(), newId + ".inf"));
            FileUtils.moveFile((File)codefile, (File)new File(target.getFile(), newId + this.extension));
            this.setId(newId);
            this.saveInfo();
            this.load(target, this.id);
        }
        catch (IOException ex) {
            LOGGER.info("Can't rename script '" + this.getId() + "' to '" + newId + "', " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public List<String> getNames() {
        ScriptEngine theEngine = this.getEngine();
        if (theEngine instanceof MyPyScriptEngine) {
            return ((MyPyScriptEngine)theEngine).getLocalNames();
        }
        return null;
    }

    public String getText() {
        return this.getCode();
    }

    public void setText(String text) {
        this.setCode(text);
    }

    class ScriptTask
    extends AbstractMonitorableTask {
        ScriptingBaseScript script;
        Object[] args;

        protected ScriptTask(ScriptingBaseScript script, Object[] args) {
            super(script.getName(), false);
            this.script = null;
            this.args = null;
            this.args = args;
            this.script = script;
            this.script.put("task", (Object)this);
            this.script.put("taskStatus", (Object)this.getTaskStatus());
        }

        public void run() {
            try {
                DefaultScriptingScript.this.console_println("Running script " + this.script.getName() + ".");
                this.script.run(this.args);
                DefaultScriptingScript.this.console_println("Script " + this.script.getName() + " terminated.");
            }
            catch (Throwable e) {
                DefaultScriptingScript.this.console_println("Stript " + this.script.getName() + " aborted.");
            }
            finally {
                this.taskStatus.terminate();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
                this.taskStatus.remove();
            }
        }

        public void showTaskStatus() {
            this.taskStatus.add();
        }
    }

    public static class OutputWriter
    extends Writer {
        private final Set<Writer> writers = new HashSet<Writer>();
        private final PrintStream out;

        private OutputWriter(PrintStream out) {
            this.out = out;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                byte[] buf = new String(cbuf).getBytes(Charset.forName("UTF-8"));
                this.out.write(buf, off, len);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't output", (Throwable)ex);
            }
            for (Writer writer : this.writers) {
                try {
                    writer.write(cbuf, off, len);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't output", (Throwable)ex);
                }
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.out.flush();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't flush", (Throwable)ex);
            }
            for (Writer writer : this.writers) {
                try {
                    writer.flush();
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't flush", (Throwable)ex);
                }
            }
        }

        @Override
        public void close() throws IOException {
        }

        private void addWriter(Writer out) {
            this.writers.add(out);
        }

        private void removeWriter(Writer out) {
            this.writers.remove(out);
        }
    }
}

