/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.toc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.toc.TocMenuEntry;
import org.gvsig.app.project.documents.view.toc.gui.FPopupMenu;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.raster.wcs.app.wcsclient.layer.FLyrWCS;

public class WCSZoomToPixelTocMenuEntry
extends TocMenuEntry {
    public static final int ZOOM_TO_VIEW_CENTER = 2;
    private JMenuItem properties;
    FLayer lyr = null;
    public int zoomType = 2;

    public void initialize(FPopupMenu m) {
        super.initialize(m);
        if (this.isTocItemBranch()) {
            this.lyr = this.getNodeLayer();
            if (this.lyr instanceof FLyrWCS) {
                this.properties = new JMenuItem(PluginServices.getText((Object)((Object)this), (String)"Zoom_pixel"));
                this.getMenu().add(this.properties);
                this.getMenu().setEnabled(true);
                this.properties.addActionListener((ActionListener)((Object)this));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        ViewPort v = this.getMapContext().getViewPort();
        double w2 = (double)v.getImageWidth() / 2.0;
        double h2 = (double)v.getImageHeight() / 2.0;
        double wcOriginCenterX = v.getExtent().getMinX() + (v.getExtent().getMaxX() - v.getExtent().getMinX()) / 2.0;
        double wcOriginCenterY = v.getExtent().getMinY() + (v.getExtent().getMaxY() - v.getExtent().getMinY()) / 2.0;
        Point2D maxRes = ((FLyrWCS)this.lyr).getMaxResolution();
        double wcDstMinX = wcOriginCenterX - w2 * maxRes.getX();
        double wcDstMinY = wcOriginCenterY + h2 * maxRes.getY();
        double wcDstWidth = w2 * maxRes.getX() * 2.0;
        double wcDstHeight = h2 * maxRes.getY() * 2.0;
        GeometryManager geoMan = GeometryLocator.getGeometryManager();
        Envelope rAux = null;
        try {
            rAux = geoMan.createEnvelope(wcDstMinX, wcDstMinY, wcDstMinX + wcDstWidth, wcDstMinY + wcDstHeight, 0);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.getMapContext().getViewPort().setEnvelope(rAux);
    }
}

