/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.wizards;

import com.jgoodies.forms.layout.CellConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.persistence.serverData.ServerDataPersistence;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.panelGroup.loaders.PanelGroupLoaderFromExtensionPoint;
import org.gvsig.downloader.swing.DownloaderConfigController;
import org.gvsig.downloader.swing.DownloaderSwingLocator;
import org.gvsig.downloader.swing.DownloaderSwingManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorerParameters;
import org.gvsig.fmap.dal.store.wfs.WFSOpenStoreParameters;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.panelGroup.PanelGroupManager;
import org.gvsig.gui.beans.panelGroup.loaders.IPanelGroupLoader;
import org.gvsig.remoteclient.wfs.WFSProtocolHandlerFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.utils.swing.jcomboServer.ComboServerController;
import org.gvsig.utils.swing.jcomboServer.ServerData;
import org.gvsig.wfs.WFSClientExtension;
import org.gvsig.wfs.gui.panels.WFSParamsPanel;
import org.gvsig.wfs.gui.wizards.WFSWizardPage0View;
import org.gvsig.wfs.gui.wizards.WFSWizardView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSWizard
extends WizardPanel {
    private static final Logger logger = LoggerFactory.getLogger(WFSWizard.class);
    private static final String serversPropsFilename = "servers.properties";
    private PluginServices plugin = null;
    private int page;
    private boolean connected = false;
    private ComboServerController cmbHost = null;
    private JLabel lblTitle = null;
    private JScrollPane jScrollPane = null;
    private JPanel pnlName = null;
    private WFSParamsPanel wfsParamsPanel = null;
    private WFSServerExplorer explorer = null;
    private DynObject preferences = null;
    private boolean refreshing = false;
    private final String wfs_properties_extensionpoint_name = "WFSPropertiesDialog";
    private WFSWizardView view = null;
    private WFSWizardPage0View panelPage0 = null;
    private DownloaderConfigController downloaderController;
    private static final String[] SUSPICIOUS_PARAMS = new String[]{"request"};

    public WFSWizard() {
        this.initialize();
    }

    private void initialize() {
        DataManager dataManager = DALLocator.getDataManager();
        DownloaderSwingManager downloaderSwingManager = DownloaderSwingLocator.getDownloaderSwingManager();
        PluginsManager pluginsManager = PluginsLocator.getManager();
        this.plugin = pluginsManager.getPlugin(WFSClientExtension.class);
        this.view = new WFSWizardView();
        this.panelPage0 = new WFSWizardPage0View(){

            @Override
            public ImageIcon loadImage(String imageName) {
                String name = FilenameUtils.getBaseName((String)imageName);
                IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
                if (theme.exists(name)) {
                    return theme.get(name);
                }
                return new ImageIcon();
            }
        };
        this.downloaderController = downloaderSwingManager.createDownloaderConfigController(() -> {
            URL host = this.getHost();
            if (host == null) {
                return null;
            }
            return host.toExternalForm();
        }, this.panelPage0.btnDownloaderAddService, this.panelPage0.btnDownloaderAdmin);
        this.preferences = this.plugin.getPluginProperties();
        this.cmbHost = this.getCmbHost();
        this.refreshing = BooleanUtils.isTrue((Boolean)((Boolean)this.preferences.getDynValue("refresh_capabilities")));
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.setTabName(i18n.getTranslation("WFS"));
        this.translate();
        this.view.cmbCacheFeat.addItem(i18n.getTranslation("none"));
        List cacheProviders = dataManager.getFeatureCacheProviders();
        for (String featureCacheProvider : cacheProviders) {
            this.view.cmbCacheFeat.addItem(featureCacheProvider);
        }
        this.setLayout(new BorderLayout());
        this.setVisible(true);
        this.add(this.view, "Center");
        JPanel panelPages = new JPanel();
        panelPages.setLayout(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.fill = 1;
        cc.gridx = 0;
        cc.gridy = 0;
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        panelPages.add((Component)this.panelPage0, cc);
        cc.gridy = 1;
        panelPages.add((Component)this.getPanelPage2(), cc);
        this.view.panelPages.add((Component)panelPages, new CellConstraints(1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.page = 0;
        this.view.btnPrevious.addActionListener(e -> {
            int tabIndex = this.wfsParamsPanel.getSelectedIndex();
            if (this.page == 1) {
                if (tabIndex == 0) {
                    this.page = 0;
                    this.connected = false;
                    this.wfsParamsPanel.enableDefaultTabs(false);
                    this.getLblTitle().setText("-");
                    this.getTxtAbstract().setText("");
                    this.getPanelPage0().setVisible(true);
                    this.getPanelPage2().setVisible(false);
                } else {
                    this.wfsParamsPanel.goToPreviousTab();
                }
            }
            this.uptateNavigatingButtons();
        });
        this.view.btnNext.addActionListener(e -> {
            if (this.page == 0) {
                this.page = 1;
                this.getPanelPage0().setVisible(false);
                this.getPanelPage2().setVisible(true);
            } else {
                this.wfsParamsPanel.goToNextTab();
            }
            this.uptateNavigatingButtons();
        });
        this.getBtnConnect().addActionListener(e -> {
            if (!this.checkServerUrl()) {
                return;
            }
            this.getBtnConnect().setEnabled(false);
            try {
                this.rellenarControles();
                this.wfsParamsPanel.refreshCapabilitiesInfo();
                this.wfsParamsPanel.refreshWFSSelectFeaturePanel();
                this.wfsParamsPanel.enableDefaultTabs(false);
                this.getBtnConnect().setEnabled(true);
                this.getBtnSiguiente().setEnabled(true);
                this.getBtnSiguiente().requestFocus();
            }
            catch (Exception e1) {
                String msg = WFSWizard.getLastMessage(e1);
                JOptionPane.showMessageDialog((Component)((Object)this), Messages.getText((String)"cant_connect") + ":\n\n" + msg, Messages.getText((String)"error"), 0);
                this.getBtnConnect().setEnabled(true);
            }
            this.callStateChanged(false);
        });
        this.getBtnConnect().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    WFSWizard.this.getBtnConnect().doClick();
                }
            }
        });
        this.getChkCaching().setSelected(this.refreshing);
        this.getChkCaching().addActionListener(e -> {
            this.refreshing = this.getChkCaching().isSelected();
            this.preferences.setDynValue("refresh_capabilities", (Object)this.refreshing);
        });
        this.uptateNavigatingButtons();
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((JComponent)this.panelPage0.lblServer);
        swingManager.translate((JComponent)this.panelPage0.cmbHost);
        swingManager.translate((AbstractButton)this.panelPage0.btnConnect);
        swingManager.translate((AbstractButton)this.panelPage0.chkCaching);
        swingManager.translate((JComponent)this.panelPage0.lblDescription);
        swingManager.translate(this.panelPage0.lblName);
        swingManager.translate((JComponent)this.panelPage0.txtAbstract);
        swingManager.translate(this.view.lblServerVersion);
        swingManager.translate(this.view.lblCacheFeat);
        swingManager.translate((JComponent)this.view.cmbCacheFeat);
        swingManager.translate((AbstractButton)this.view.btnPrevious);
        swingManager.translate((AbstractButton)this.view.btnNext);
    }

    private void addHost(String host) {
        host = host.trim();
        ServerDataPersistence persistence = this.getServerDataPersistence();
        persistence.addServerData(new ServerData(host, "WFS"));
    }

    private void rellenarControles() throws Exception {
        String url = "(unknow)";
        try {
            url = this.getCmbHost().getModel().getSelectedItem().toString();
            DataManager dataManager = DALLocator.getDataManager();
            WFSServerExplorerParameters parameters = (WFSServerExplorerParameters)dataManager.createServerExplorerParameters("WFSServerExplorer");
            parameters.setUrl(url);
            parameters.setIgnoreCache(this.refreshing);
            this.addHost(url);
            this.explorer = (WFSServerExplorer)dataManager.openServerExplorer("WFSServerExplorer", (DataServerExplorerParameters)parameters);
            this.saveServerListFromComboBox();
            this.getLblTitle().setText(this.explorer.getTitle());
            this.getTxtAbstract().setText(this.explorer.getAbstract());
            List sel_ver = WFSProtocolHandlerFactory.getRequestableVersions(url, this.refreshing);
            this.wfsParamsPanel.getOptionsPanel().refreshVersions(sel_ver);
            if (sel_ver == null || sel_ver.isEmpty()) {
                this.view.lblServerTypeValue.setText("-");
            } else {
                this.view.lblServerTypeValue.setText(sel_ver.get(0).toString().trim());
                for (int i = 1; i < sel_ver.size(); ++i) {
                    String txt = this.view.lblServerTypeValue.getText();
                    txt = txt + ", " + sel_ver.get(i).toString().trim();
                    this.view.lblServerTypeValue.setText(txt);
                }
            }
            this.view.lblServerTypeValue.repaint();
            if (!this.explorer.getServerType().toLowerCase().startsWith("wfs 1.0")) {
                this.view.cmbCacheFeat.setEnabled(true);
            } else {
                this.view.cmbCacheFeat.setEnabled(false);
            }
            this.wfsParamsPanel.setServerExplorer(this.explorer);
            this.connected = true;
        }
        catch (Exception e) {
            logger.warn("Can't connect to '" + url + "'.", (Throwable)e);
            throw e;
        }
    }

    private void uptateNavigatingButtons() {
        if (this.page == 0) {
            this.getBtnAnterior().setEnabled(false);
            this.getBtnSiguiente().setEnabled(false);
        } else {
            short tabIndex = (short)this.wfsParamsPanel.getSelectedIndex();
            this.getBtnAnterior().setEnabled(true);
            if (this.wfsParamsPanel.nextPageEnabled() == -1) {
                this.getBtnSiguiente().setEnabled(false);
                if (tabIndex == this.wfsParamsPanel.getPanelInGUICount() - 1) {
                    this.getBtnSiguiente().setEnabled(false);
                }
            } else {
                this.getBtnSiguiente().setEnabled(true);
            }
        }
        this.callStateChanged(this.wfsParamsPanel != null ? this.wfsParamsPanel.isCorretlyConfigured() : false);
    }

    private ComboServerController getCmbHost() {
        if (this.cmbHost == null) {
            this.cmbHost = new ComboServerController(this.panelPage0.cmbHost);
            this.cmbHost.setModel(new DefaultComboBoxModel());
            this.cmbHost.setServerList(this.getServerDataPersistence().getArrayOfServerData());
            this.cmbHost.getCombo().getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        WFSWizard.this.getBtnConnect().doClick();
                    }
                }
            });
        }
        return this.cmbHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ServerDataPersistence getServerDataPersistence() {
        ServerDataPersistence servers;
        block8: {
            servers = (ServerDataPersistence)this.preferences.getDynValue("servers");
            if (servers != null && !servers.isEmpty()) break block8;
            if (servers == null) {
                servers = new ServerDataPersistence("WFS");
                this.preferences.setDynValue("servers", (Object)servers);
            }
            Properties prop = new Properties();
            File propFile = new File(this.plugin.getPluginDirectory(), serversPropsFilename);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                prop.load(fis);
            }
            catch (FileNotFoundException e) {
                logger.info("Properties file '" + propFile.getAbsolutePath() + "' not found", (Throwable)e);
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (IOException e2) {
                logger.info("Error reading properties file '" + propFile.getAbsolutePath() + "'.", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
            for (int i = 0; i < prop.size(); ++i) {
                Object value = prop.get("server[" + i + "]");
                servers.addServerData(new ServerData(value.toString(), "WFS"));
            }
        }
        return servers;
    }

    private void saveServerListFromComboBox() {
        ServerDataPersistence persistence = this.getServerDataPersistence();
        String urlSelected = this.getCmbHost().getModel().getSelectedItem().toString();
        boolean isSelectedInModel = false;
        for (int i = 0; i < this.getCmbHost().getItemCount(); ++i) {
            String url = this.getCmbHost().getItemAt(i).toString();
            persistence.addServerData(new ServerData(url, "WFS"));
            if (!url.equals(urlSelected)) continue;
            isSelectedInModel = true;
        }
        if (!isSelectedInModel) {
            persistence.addServerData(new ServerData(urlSelected, "WFS"));
        }
    }

    private JButton getBtnConnect() {
        return this.panelPage0.btnConnect;
    }

    private JPanel getPnlName() {
        if (this.pnlName == null) {
            this.pnlName = new JPanel(new FlowLayout(0, 10, 0));
            this.pnlName.setBounds(new Rectangle(9, 19, 452, 24));
            this.pnlName.add((Component)this.getJLabelName(), null);
            this.pnlName.add((Component)this.getLblTitle(), null);
        }
        return this.pnlName;
    }

    private JLabel getJLabelName() {
        return this.panelPage0.lblName;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel();
            this.lblTitle.setText("-");
            this.lblTitle.setPreferredSize(new Dimension(350, 16));
            this.lblTitle.setBounds(82, 26, 350, 16);
        }
        return this.lblTitle;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTxtAbstract());
            this.jScrollPane.setPreferredSize(new Dimension(450, 60));
            this.jScrollPane.setBounds(10, 47, 457, 247);
        }
        return this.jScrollPane;
    }

    private JTextArea getTxtAbstract() {
        return this.panelPage0.txtAbstract;
    }

    private JPanel getPanelMain() {
        return this.view.panelMain;
    }

    private JPanel getPanelPage0() {
        return this.panelPage0;
    }

    private JPanel getPanelPage2() {
        if (this.wfsParamsPanel == null) {
            try {
                PanelGroupManager manager = PanelGroupManager.getManager();
                manager.registerPanelGroup(WFSParamsPanel.class);
                manager.setDefaultType(WFSParamsPanel.class);
                this.wfsParamsPanel = (WFSParamsPanel)manager.getPanelGroup(null);
                this.wfsParamsPanel.setWizardPanel(this);
                this.wfsParamsPanel.loadPanels((IPanelGroupLoader)new PanelGroupLoaderFromExtensionPoint("WFSPropertiesDialog"));
                this.wfsParamsPanel.addChangeListener(evt -> {
                    JTabbedPane pane = (JTabbedPane)evt.getSource();
                    this.uptateNavigatingButtons();
                });
            }
            catch (BaseException bE) {
                NotificationManager.showMessageError((String)bE.getLocalizedMessageStack(), (Exception)((Object)bE));
            }
            catch (Exception e) {
                NotificationManager.showMessageError((String)e.getLocalizedMessage(), (Exception)e);
            }
        }
        return this.wfsParamsPanel;
    }

    private JButton getBtnSiguiente() {
        return this.view.btnNext;
    }

    private JButton getBtnAnterior() {
        return this.view.btnPrevious;
    }

    public WFSServerExplorer getServerExplorer() {
        return this.explorer;
    }

    public static Rectangle2D getRectangle(Rectangle2D[] rects) {
        Rectangle2D ret = rects[0];
        for (int i = 1; i < rects.length; ++i) {
            ret.add(rects[i]);
        }
        return ret;
    }

    public URL getHost() {
        try {
            return new URL(this.getCmbHost().getModel().getSelectedItem().toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void initWizard() {
    }

    public void execute() {
        WFSOpenStoreParameters parameters;
        this.wfsParamsPanel.setSelectedCache(Objects.toString(this.view.cmbCacheFeat.getSelectedItem(), null));
        String layerName = this.wfsParamsPanel.getFeaturesPanel().getLayerName();
        try {
            parameters = this.wfsParamsPanel.getDataStoreParameters();
        }
        catch (Exception e) {
            logger.warn("Can't make the parameters of the wfs layer", (Throwable)e);
            I18nManager i18n = ToolsLocator.getI18nManager();
            JOptionPane.showMessageDialog(null, i18n.getTranslation("_cant_create_wfslayer"), "addLayer", 2);
            return;
        }
        this.doAddLayer(this.getMapCtrl(), layerName, parameters);
    }

    private JCheckBox getChkCaching() {
        return this.panelPage0.chkCaching;
    }

    public void doClickOnNextButton() {
        this.getBtnSiguiente().doClick();
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void close() {
        if (this.explorer != null) {
            this.explorer.dispose();
        }
    }

    public boolean areSettingsValid() {
        if (this.wfsParamsPanel != null) {
            return this.wfsParamsPanel.isCorretlyConfigured();
        }
        return false;
    }

    private boolean checkServerUrl() {
        Object sel_obj = this.getCmbHost().getModel().getSelectedItem();
        if (sel_obj != null) {
            String url = sel_obj.toString();
            List<String> suspi = this.getSuspiciousParameters(url);
            if (suspi != null && !suspi.isEmpty()) {
                return this.userWantsToContinue(suspi);
            }
            return true;
        }
        return false;
    }

    private boolean userWantsToContinue(List<String> suspi) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String tit = i18n.getTranslation("server");
        String msg = i18n.getTranslation("Dangerous_parameters_found_Continue_question");
        int len = suspi.size();
        msg = msg + " '";
        for (int i = 0; i < len - 1; ++i) {
            msg = msg + suspi.get(i) + ", ";
        }
        int user_opt = JOptionPane.showConfirmDialog((Component)((Object)this), msg = msg + suspi.get(len - 1) + "'", tit, 0);
        return user_opt == 0;
    }

    private List<String> getSuspiciousParameters(String _url) {
        String str_url = _url;
        int len = SUSPICIOUS_PARAMS.length;
        String item = null;
        ArrayList<String> resp = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            item = SUSPICIOUS_PARAMS[i];
            item = "&" + item + "=";
            if (!str_url.contains(item)) continue;
            resp.add(SUSPICIOUS_PARAMS[i]);
        }
        return resp;
    }

    public static String getLastMessage(Throwable ex) {
        Throwable p;
        for (p = ex; p.getCause() != null && p.getCause() != p; p = p.getCause()) {
        }
        return p.getMessage();
    }
}

