/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.modeler.elements;

import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.modeler.elements.IModelElement;
import es.unex.sextante.modeler.elements.ModelElement3DRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementBand;
import es.unex.sextante.modeler.elements.ModelElementBoolean;
import es.unex.sextante.modeler.elements.ModelElementFilepath;
import es.unex.sextante.modeler.elements.ModelElementFixedTable;
import es.unex.sextante.modeler.elements.ModelElementInputArray;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import es.unex.sextante.modeler.elements.ModelElementPoint;
import es.unex.sextante.modeler.elements.ModelElementRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementSelection;
import es.unex.sextante.modeler.elements.ModelElementString;
import es.unex.sextante.modeler.elements.ModelElementTable;
import es.unex.sextante.modeler.elements.ModelElementTableField;
import es.unex.sextante.modeler.elements.ModelElementVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterFilepath;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;

public class ModelElementFactory {
    public static IModelElement getParameterAsModelElement(Parameter param) {
        IModelElement element = null;
        try {
            if (param instanceof ParameterRasterLayer) {
                element = new ModelElementRasterLayer();
                element.setNumberOfBands(-1);
            }
            if (param instanceof Parameter3DRasterLayer) {
                element = new ModelElement3DRasterLayer();
            } else if (param instanceof ParameterVectorLayer) {
                element = new ModelElementVectorLayer();
                AdditionalInfoVectorLayer ai = (AdditionalInfoVectorLayer)param.getParameterAdditionalInfo();
                ((ModelElementVectorLayer)element).setShapeType(ai.getShapeType());
            } else if (param instanceof ParameterTable) {
                element = new ModelElementTable();
            } else if (param instanceof ParameterPoint) {
                element = new ModelElementPoint();
            } else if (param instanceof ParameterNumericalValue) {
                element = new ModelElementNumericalValue();
            } else if (param instanceof ParameterString) {
                element = new ModelElementString();
            } else if (param instanceof ParameterFilepath) {
                element = new ModelElementFilepath();
            } else if (param instanceof ParameterFixedTable) {
                element = new ModelElementFixedTable();
                AdditionalInfoFixedTable aift = (AdditionalInfoFixedTable)param.getParameterAdditionalInfo();
                ((ModelElementFixedTable)element).setRowsCount(aift.getRowsCount());
                ((ModelElementFixedTable)element).setColsCount(aift.getColsCount());
                ((ModelElementFixedTable)element).setIsNumberOfRowsFixed(aift.isNumberOfRowsFixed());
            } else if (param instanceof ParameterSelection) {
                element = new ModelElementSelection();
            } else if (param instanceof ParameterMultipleInput) {
                element = new ModelElementInputArray();
                AdditionalInfoMultipleInput ai = (AdditionalInfoMultipleInput)param.getParameterAdditionalInfo();
                ((ModelElementInputArray)element).setType(ai.getDataType());
            } else if (param instanceof ParameterBoolean) {
                element = new ModelElementBoolean();
            } else if (param instanceof ParameterMultipleInput) {
                element = new ModelElementInputArray();
            } else if (param instanceof ParameterTableField) {
                element = new ModelElementTableField();
            } else if (param instanceof ParameterBand) {
                element = new ModelElementBand();
            }
        }
        catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
            // empty catch block
        }
        return element;
    }
}

