/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class FixedTableModel
extends AbstractTableModel {
    String[] m_sColumnNames;
    ArrayList[] m_Data;
    boolean m_bIsNumberOfRowsFixed;

    public FixedTableModel(String[] sColumnNames, int iRows, boolean bIsNumberOfRowsFixed) {
        this.m_sColumnNames = sColumnNames;
        this.m_bIsNumberOfRowsFixed = bIsNumberOfRowsFixed;
        this.m_Data = new ArrayList[sColumnNames.length];
        for (int i = 0; i < this.m_sColumnNames.length; ++i) {
            this.m_Data[i] = new ArrayList();
            for (int j = 0; j < iRows; ++j) {
                this.m_Data[i].add("0");
            }
        }
    }

    public static FixedTableModel newInstance(FixedTableModel fixedTableModel) {
        FixedTableModel newFixedTableModel = new FixedTableModel(fixedTableModel.getColumnNames(), fixedTableModel.getRowCount(), fixedTableModel.isNumberOfRowsFixed());
        newFixedTableModel.setData(fixedTableModel.getData());
        return newFixedTableModel;
    }

    public boolean setAttributes(String[] sColumnNames, ArrayList[] data, boolean bIsNumberOfRowsFixed) {
        if (data.length == sColumnNames.length) {
            this.setData(data);
            this.m_sColumnNames = sColumnNames;
            this.m_bIsNumberOfRowsFixed = bIsNumberOfRowsFixed;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.m_sColumnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.m_Data[0].size();
    }

    @Override
    public String getColumnName(int iCol) {
        return this.m_sColumnNames[iCol];
    }

    public String[] getColumnNames() {
        return this.m_sColumnNames;
    }

    @Override
    public Object getValueAt(int iRow, int iCol) {
        return this.m_Data[iCol].get(iRow);
    }

    public Class getColumnClass(int iField) {
        return this.getValueAt(0, iField).getClass();
    }

    @Override
    public boolean isCellEditable(int iRow, int iCol) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int iRow, int iCol) {
        try {
            if (iRow < this.getRowCount()) {
                this.m_Data[iCol].set(iRow, value.toString());
                this.fireTableCellUpdated(iRow, iCol);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addRow() {
        if (!this.m_bIsNumberOfRowsFixed) {
            for (int i = 0; i < this.m_sColumnNames.length; ++i) {
                this.m_Data[i].add(new Double(0.0));
            }
        }
        this.fireTableRowsInserted(this.m_Data[0].size(), this.m_Data[0].size());
    }

    public void removeRow(int iRow) {
        if (!this.m_bIsNumberOfRowsFixed) {
            for (int i = 0; i < this.m_sColumnNames.length; ++i) {
                this.m_Data[i].remove(iRow);
            }
        }
        this.fireTableRowsDeleted(iRow, iRow);
    }

    public ArrayList[] getData() {
        return this.m_Data;
    }

    public boolean setData(ArrayList[] data) {
        if (data.length == this.m_sColumnNames.length) {
            for (int i = 0; i < this.m_Data.length; ++i) {
                this.m_Data[i].clear();
                for (int j = 0; j < data[i].size(); ++j) {
                    this.m_Data[i].add(data[i].get(j));
                }
            }
            return true;
        }
        return false;
    }

    public boolean isNumberOfRowsFixed() {
        return this.m_bIsNumberOfRowsFixed;
    }

    public void setIsNumberOfRowsFixed(boolean bIsNumberOfRowsFixed) {
        this.m_bIsNumberOfRowsFixed = bIsNumberOfRowsFixed;
    }

    public String getDimensionsAsString() {
        StringBuffer s = new StringBuffer();
        s.append(Integer.toString(this.getRowCount()));
        s.append(" X ");
        s.append(Integer.toString(this.getColumnCount()));
        return s.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getRowCount(); ++i) {
            sb.append("[");
            for (int j = 0; j < this.getColumnCount(); ++j) {
                sb.append(this.getValueAt(i, j));
                if (j >= this.getColumnCount() - 1) continue;
                sb.append("|");
            }
            if (i < this.getRowCount() - 1) {
                sb.append("],");
                continue;
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getAsCSV() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                sb.append(this.getValueAt(i, j));
                if (i == this.getRowCount() - 1 && j == this.getColumnCount() - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }
}

