/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterNumericalValue
extends Parameter {
    private static final String MAX = "max";
    private static final String TYPE = "type";
    private static final String DEFAULT = "default";
    private static final String MIN = "min";

    @Override
    public String getParameterTypeName() {
        return "Numerical Value";
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public int getParameterValueAsInt() throws WrongParameterTypeException, NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return ((Number)this.m_ParameterValue).intValue();
        }
        throw new NullParameterValueException();
    }

    @Override
    public double getParameterValueAsDouble() throws WrongParameterTypeException, NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return ((Number)this.m_ParameterValue).doubleValue();
        }
        throw new NullParameterValueException();
    }

    @Override
    public boolean getParameterValueAsBoolean() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public String getParameterValueAsString() throws WrongParameterTypeException, NullParameterValueException {
        if (this.m_ParameterValue != null) {
            Number n = (Number)this.m_ParameterValue;
            if (((AdditionalInfoNumericalValue)this.m_ParameterAdditionalInfo).getType() == 1) {
                return Integer.toString(n.intValue());
            }
            return n.toString();
        }
        throw new NullParameterValueException();
    }

    @Override
    public Point2D getParameterValueAsPoint() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoNumericalValue) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof Number) {
            AdditionalInfoNumericalValue ainv;
            Number number = (Number)value;
            double dValue = number.doubleValue();
            if (dValue >= (ainv = (AdditionalInfoNumericalValue)this.m_ParameterAdditionalInfo).getMinValue() && dValue <= ainv.getMaxValue()) {
                this.m_ParameterValue = value;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Class getParameterClass() {
        return Number.class;
    }

    @Override
    protected void serializeAttributes(KXmlSerializer serializer) throws NullParameterAdditionalInfoException, IOException {
        AdditionalInfoNumericalValue ainv = (AdditionalInfoNumericalValue)this.m_ParameterAdditionalInfo;
        if (ainv == null) {
            throw new NullParameterAdditionalInfoException();
        }
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", MIN);
        serializer.attribute(null, "value", new Double(ainv.getMinValue()).toString());
        serializer.endTag(null, "attribute");
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", MAX);
        serializer.attribute(null, "value", new Double(ainv.getMaxValue()).toString());
        serializer.endTag(null, "attribute");
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", DEFAULT);
        serializer.attribute(null, "value", new Double(ainv.getDefaultValue()).toString());
        serializer.endTag(null, "attribute");
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", TYPE);
        serializer.attribute(null, "value", new Integer(ainv.getType()).toString());
        serializer.endTag(null, "attribute");
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        int iType = 0;
        double dMin = Double.MAX_VALUE;
        double dMax = Double.NEGATIVE_INFINITY;
        double dDefault = 0.0;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("attribute") != 0) break;
                    String sName = parser.getAttributeValue("", "name");
                    if (sName.compareTo(TYPE) == 0) {
                        iType = Integer.parseInt(parser.getAttributeValue("", "value"));
                    }
                    if (sName.compareTo(MIN) == 0) {
                        dMin = Double.parseDouble(parser.getAttributeValue("", "value"));
                    }
                    if (sName.compareTo(MAX) == 0) {
                        dMax = Double.parseDouble(parser.getAttributeValue("", "value"));
                    }
                    if (sName.compareTo(DEFAULT) != 0) break;
                    dDefault = Double.parseDouble(parser.getAttributeValue("", "value"));
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        ParameterNumericalValue param = new ParameterNumericalValue();
        AdditionalInfoNumericalValue ai = new AdditionalInfoNumericalValue(iType, dDefault, dMin, dMax);
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        Number n = (Number)this.m_ParameterValue;
        if (((AdditionalInfoNumericalValue)this.m_ParameterAdditionalInfo).getType() == 1) {
            return "\"" + Integer.toString(n.intValue()) + "\"";
        }
        return "\"" + n.toString() + "\"";
    }

    @Override
    public boolean isParameterValueCorrect() {
        return true;
    }
}

