/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.shapesTools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.outputs.IOutputChannel;
import java.util.ArrayList;

public class ShapesTools {
    public static IVectorLayer addFields(OutputFactory outputFactory, IVectorLayer layer, IOutputChannel channel, String[] sFieldNames, Object[][] addedValues, Class[] fieldTypes) throws UnsupportedOutputChannelException {
        int i;
        String[] sOrgFields = layer.getFieldNames();
        String[] sFields = new String[sOrgFields.length + sFieldNames.length];
        Object[] values = new Object[sOrgFields.length + sFieldNames.length];
        Class[] orgTypes = layer.getFieldTypes();
        Class[] types = new Class[sOrgFields.length + sFieldNames.length];
        for (i = 0; i < sOrgFields.length; ++i) {
            sFields[i] = sOrgFields[i];
            types[i] = orgTypes[i];
        }
        for (i = 0; i < sFieldNames.length; ++i) {
            sFields[i + sOrgFields.length] = ShapesTools.checkAttrName(sFieldNames[i], i + sOrgFields.length, sFields);
            types[i + sOrgFields.length] = fieldTypes[i];
        }
        IVectorLayer output = outputFactory.getNewVectorLayer(layer.getName(), layer.getShapeType(), types, sFields, channel, layer.getCRS());
        if (output != null) {
            int j = 0;
            IFeatureIterator iter = layer.iterator();
            while (iter.hasNext()) {
                try {
                    IFeature feature = iter.next();
                    IRecord record = feature.getRecord();
                    Object[] orgValues = record.getValues();
                    for (i = 0; i < orgValues.length; ++i) {
                        values[i] = orgValues[i];
                    }
                    for (i = 0; i < sFieldNames.length; ++i) {
                        values[i + orgValues.length] = addedValues[i][j];
                    }
                    output.addFeature(feature.getGeometry(), values);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            iter.close();
        }
        return output;
    }

    public static Geometry createCircle(double x, double y, double radius) {
        int SIDES = 100;
        Coordinate[] coords = new Coordinate[100];
        for (int i = 0; i < 100; ++i) {
            double angle = (double)i / 100.0 * 2.0 * Math.PI;
            double dx = Math.cos(angle) * radius;
            double dy = Math.sin(angle) * radius;
            coords[i] = new Coordinate(x + dx, y + dy);
        }
        coords[coords.length - 1] = coords[0];
        GeometryFactory factory = new GeometryFactory();
        LinearRing ring = factory.createLinearRing(coords);
        Polygon polygon = factory.createPolygon(ring, null);
        return polygon;
    }

    public static String checkAttrName(String name, int size, String[] attrNames) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            values.add(attrNames[i].toLowerCase());
        }
        int len = name.length();
        String resp = null;
        for (int i = 0; i < 255; ++i) {
            resp = i == 0 ? (len <= 10 ? name : name.substring(0, 10)) : (i <= 9 ? (len <= 8 ? name + "_" + i : name.substring(0, 8) + "_" + i) : (i <= 99 ? (len <= 8 ? name + i : name.substring(0, 8) + i) : (len <= 7 ? name + i : name.substring(0, 7) + i)));
            if (values.contains(resp.toLowerCase())) continue;
            return resp;
        }
        return name.substring(0, 4) + "_" + System.currentTimeMillis() % 1000000L;
    }
}

