/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.objects.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Shape;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ZXingObjectDrawer
implements FSObjectDrawer {
    private static Object handleValueForHint(EncodeHintType type, String value) {
        switch (type) {
            case DATA_MATRIX_SHAPE: {
                return ZXingObjectDrawer.safeSymbolShapeHint(value);
            }
            case PDF417_DIMENSIONS: {
                try {
                    int[] dim = Arrays.stream(value.trim().split(",")).mapToInt(Integer::parseInt).toArray();
                    if (dim.length == 4) {
                        return new Dimensions(dim[0], dim[1], dim[2], dim[3]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId2Param)LogMessageId.LogMessageId2Param.GENERAL_UNABLE_TO_PARSE_VALUE_AS, (Object)value, (Object)Dimensions.class.getCanonicalName());
                return null;
            }
        }
        return value;
    }

    private static SymbolShapeHint safeSymbolShapeHint(String value) {
        try {
            return SymbolShapeHint.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId2Param)LogMessageId.LogMessageId2Param.GENERAL_UNABLE_TO_PARSE_VALUE_AS, (Object)value, (Object)SymbolShapeHint.class.getCanonicalName(), (Throwable)e);
            return null;
        }
    }

    private static EncodeHintType safeEncodeHintTypeValueOf(String value) {
        try {
            return EncodeHintType.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId2Param)LogMessageId.LogMessageId2Param.GENERAL_UNABLE_TO_PARSE_VALUE_AS, (Object)value, (Object)EncodeHintType.class.getCanonicalName(), (Throwable)e);
            return null;
        }
    }

    private static int parseInt(String value, int defaultColor) {
        try {
            return Long.decode(value.toLowerCase(Locale.ROOT)).intValue();
        }
        catch (NumberFormatException nfe) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId2Param)LogMessageId.LogMessageId2Param.GENERAL_UNABLE_TO_PARSE_VALUE_AS, (Object)value, (Object)"integer", (Throwable)nfe);
            return defaultColor;
        }
    }

    public Map<Shape, String> drawObject(Element e, double x, double y, double width, double height, OutputDevice outputDevice, RenderingContext ctx, int dotsPerPixel) {
        MultiFormatWriter mfw = new MultiFormatWriter();
        int onColor = e.hasAttribute("on-color") ? ZXingObjectDrawer.parseInt(e.getAttribute("on-color"), -16777216) : -16777216;
        int offColor = e.hasAttribute("off-color") ? ZXingObjectDrawer.parseInt(e.getAttribute("off-color"), -1) : -1;
        EnumMap<EncodeHintType, Object> encodeHints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        encodeHints.put(EncodeHintType.MARGIN, (Object)0);
        NodeList childNodes = e.getChildNodes();
        int childNodesCount = childNodes.getLength();
        for (int i = 0; i < childNodesCount; ++i) {
            Object value;
            Element eChild;
            Node n = childNodes.item(i);
            if (!(n instanceof Element) || !"encode-hint".equals((eChild = (Element)n).getTagName())) continue;
            EncodeHintType encodeHintType = ZXingObjectDrawer.safeEncodeHintTypeValueOf(eChild.getAttribute("name"));
            Object object = value = encodeHintType != null ? ZXingObjectDrawer.handleValueForHint(encodeHintType, eChild.getAttribute("value")) : null;
            if (encodeHintType == null || value == null) continue;
            encodeHints.put(encodeHintType, value);
        }
        String value = e.getAttribute("value");
        BarcodeFormat barcodeFormat = e.hasAttribute("format") ? BarcodeFormat.valueOf((String)e.getAttribute("format")) : BarcodeFormat.QR_CODE;
        int finalWidth = (int)(width / (double)dotsPerPixel);
        int finalHeight = (int)(height / (double)dotsPerPixel);
        try {
            BitMatrix bitMatrix = mfw.encode(value, barcodeFormat, finalWidth, finalHeight, encodeHints);
            outputDevice.drawWithGraphics((float)x, (float)y, (float)width, (float)height, graphics2D -> graphics2D.drawImage(MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix, (MatrixToImageConfig)new MatrixToImageConfig(onColor, offColor)), 0, 0, finalWidth, finalHeight, null));
        }
        catch (WriterException we) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.GENERAL_MESSAGE, (Object)"Error while generating the barcode", (Throwable)we);
        }
        return null;
    }
}

