/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.io.File;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.util.Factory;
import org.gvsig.tools.util.GetItemByKey;
import org.gvsig.tools.util.GetKeys;
import org.gvsig.tools.util.IsEmpty;
import org.gvsig.tools.util.Size;
import org.gvsig.tools.util.Size64;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeMapImpl<K, V>
extends AbstractDisposable
implements Map<K, V>,
GetItemByKey<K, V>,
Size64,
Size,
GetKeys<K>,
IsEmpty,
Disposable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LargeMapImpl.class);
    private final File f;
    private MVStore mvstore;
    private MVMap<K, V> mvMap;

    public LargeMapImpl() {
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        this.f = folderManager.getUniqueTemporaryFile(new String[]{"MinLargeMap.mv"});
        this.mvstore = MVStore.open((String)this.f.getAbsolutePath());
        this.mvMap = this.mvstore.openMap("DefaultMap");
    }

    public long size64() {
        return this.mvMap.sizeAsLong();
    }

    protected void doDispose() throws BaseException {
        this.mvstore.closeImmediately();
        FileUtils.deleteQuietly((File)this.f);
        this.mvMap = null;
        this.mvstore = null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mvMap.entrySet();
    }

    public List<K> getKeys() {
        AbstractList keys = new AbstractList<K>(){

            @Override
            public K get(int index) {
                Object key = LargeMapImpl.this.mvMap.getKey((long)index);
                return key;
            }

            @Override
            public int size() {
                return LargeMapImpl.this.mvMap.size();
            }
        };
        return keys;
    }

    @Override
    public int size() {
        return this.mvMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mvMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mvMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mvMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.mvMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.mvMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.mvMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.mvMap.putAll(m);
    }

    @Override
    public void clear() {
        this.mvMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mvMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.mvMap.values();
    }

    public static void selfRegister() {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.registerLargeMap(new Factory(){

            public String getName() {
                return "MVStoreMapFactory";
            }

            public Object create(Object ... parameters) {
                return new LargeMapImpl();
            }
        });
    }
}

