/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.h2.H2SpatialConnectionParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;

public class H2SpatialConnectionParametersHelper {
    private final JDBCConnectionParameters parameters;
    private static final String DATABASE_FILE = "database_file";
    private static final String MAXSECONDSIDLE = "MaxSecondsIdle";
    private static final String SERVERPORT = "ServerPort";
    private static final String SERVERALLOWOTHERS = "ServerAllowOthers";
    private static final String SPLIT = "Split";
    private static final String MAINTAINGLOBALCONNECTION = "maintainGlobalConnection";

    public H2SpatialConnectionParametersHelper(JDBCConnectionParameters parameters) {
        this.parameters = parameters;
    }

    public String getUrl() {
        String url = (String)this.getDynValue("url");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = H2SpatialUtils.getConnectionURL((H2SpatialConnectionParameters)this.parameters);
            this.setDynValue("url", url);
        }
        return url;
    }

    public void validate() throws ValidateDataParametersException {
        if (this.getDynValue("jdbcdriverclass") == null) {
            this.setDynValue("jdbcdriverclass", "org.h2.Driver");
        }
        if (this.getFile() == null) {
            if (this.getDynValue("dbname") == null) {
                throw new ValidateDataParametersException();
            }
            this.setFile(new File((String)this.getDynValue("dbname")));
        } else {
            String dbName = (String)this.getDynValue("dbname");
            if (StringUtils.isEmpty((CharSequence)dbName)) {
                dbName = this.getDbNameFromFile(this.getFile());
                this.setDynValue("dbname", dbName.toUpperCase());
            }
        }
        if (this.getDynValue("url") == null) {
            String url = H2SpatialUtils.getConnectionURL((H2SpatialConnectionParameters)this.parameters);
            this.setDynValue("url", url);
        }
    }

    private Object getDynValue(String name) {
        return this.parameters.getDynValue(name);
    }

    private void setDynValue(String name, Object value) {
        this.parameters.setDynValue(name, value);
    }

    public int getMaxSecondsIdle() {
        Integer x = (Integer)this.getDynValue(MAXSECONDSIDLE);
        if (x == null) {
            return -1;
        }
        return x;
    }

    public int getServerPort() {
        Integer x = (Integer)this.getDynValue(SERVERPORT);
        if (x == null) {
            return -1;
        }
        return x;
    }

    public boolean getServerAllowOthers() {
        Boolean x = (Boolean)this.getDynValue(SERVERALLOWOTHERS);
        if (x == null) {
            return false;
        }
        return x;
    }

    public File getFile() {
        File f = (File)this.getDynValue(DATABASE_FILE);
        if (this.getDynValue("dbname") == null && f != null) {
            String dbname = this.getDbNameFromFile(f);
            this.setDynValue("dbname", dbname);
        }
        return f;
    }

    public void setFile(File database) {
        this.setDynValue(DATABASE_FILE, database);
        if (this.getDynValue("dbname") == null && database != null) {
            String dbname = this.getDbNameFromFile(database);
            this.setDynValue("dbname", dbname);
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        return props;
    }

    private String getDbNameFromFile(File f) {
        String name = H2SpatialUtils.removeH2FileNameExtension(f.getName());
        return name;
    }

    public String getServerPortAsString() {
        int port = this.getServerPort();
        if (port <= 0) {
            return null;
        }
        String port_s = String.valueOf(port);
        return port_s;
    }

    public int getSplitSize() {
        try {
            Number size = (Number)this.getDynValue(SPLIT);
            if (size == null || size.intValue() < 1) {
                return 0;
            }
            return size.intValue();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public boolean getMaintainGlobalConnection() {
        Boolean x = (Boolean)this.getDynValue(MAINTAINGLOBALCONNECTION);
        if (x == null) {
            return false;
        }
        return x;
    }
}

