/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.impl.RowImpl;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.h2.JdbcDriverBackwardsCompat;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.store.Data;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.upgrade.DbUpgrade;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Testmdb {
    private static Map<String, String> mdbtypes2h2 = null;

    public static void main(String[] args) throws Exception {
        Testmdb.test2();
    }

    public static void test1() throws Exception {
        com.healthmarketscience.jackcess.Table table;
        Database db = DatabaseBuilder.open((File)new File("/home/jjdelcerro/datos/geodata/db/mdb/northwind.accdb"));
        for (String tableName : db.getTableNames()) {
            table = db.getTable(tableName);
            System.out.println(table.getName() + ", " + table.getColumnCount());
        }
        for (String tableName : db.getTableNames()) {
            table = db.getTable(tableName);
            System.out.println(Testmdb.createTableSQL(table));
        }
    }

    public static void test2() throws Exception {
        Driver.load();
        Connection conn = DriverManager.getConnection("jdbc:accdb:/home/jjdelcerro/datos/geodata/db/mdb/northwind.accdb");
        Statement stmt0 = conn.createStatement();
        DatabaseMetaData dbmatadata = conn.getMetaData();
        ResultSet rs0 = stmt0.executeQuery("SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, table_type FROM INFORMATION_SCHEMA.TABLES where table_type in ('TABLE', 'EXTERNAL') ORDER BY TABLE_NAME");
        while (rs0.next()) {
            System.out.print(rs0.getString("TABLE_NAME"));
            System.out.print(" ");
            System.out.print(rs0.getString("table_type"));
            System.out.println();
        }
        System.out.println();
        rs0.close();
        Statement stmt1 = conn.createStatement();
        ResultSet rs1 = stmt1.executeQuery("SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, table_type FROM INFORMATION_SCHEMA.TABLES where table_type in ('TABLE', 'EXTERNAL') ORDER BY TABLE_NAME");
        while (rs1.next()) {
            int i;
            int i2;
            String tablename = rs1.getString("TABLE_NAME");
            Statement stmt = conn.createStatement();
            ResultSet rs3 = stmt.executeQuery("SELECT * FROM \"" + tablename + "\"");
            ResultSetMetaData rsMetadata = rs3.getMetaData();
            int columnCount = rsMetadata.getColumnCount();
            int[] colsizes = new int[columnCount + 1];
            int recordsCount = 0;
            for (i2 = 1; i2 <= columnCount; ++i2) {
                colsizes[i2] = rsMetadata.getColumnName(i2).length() + 1;
            }
            while (rs3.next()) {
                for (i2 = 1; i2 <= columnCount; ++i2) {
                    int l = Objects.toString(rs3.getObject(i2)).length() + 1;
                    if (l <= colsizes[i2]) continue;
                    colsizes[i2] = l;
                }
                ++recordsCount;
            }
            rs3.close();
            System.out.println("Table: \"" + tablename + "\" records " + recordsCount);
            ResultSet rs = stmt.executeQuery("SELECT * FROM \"" + tablename + "\"");
            rsMetadata = rs.getMetaData();
            for (i = 1; i <= columnCount; ++i) {
                System.out.print(StringUtils.rightPad((String)rsMetadata.getColumnName(i), (int)colsizes[i]));
            }
            System.out.println();
            for (i = 1; i <= columnCount; ++i) {
                System.out.print(StringUtils.repeat((String)"-", (int)(colsizes[i] - 1)) + " ");
            }
            System.out.println();
            while (rs.next()) {
                for (i = 1; i <= columnCount; ++i) {
                    System.out.print(StringUtils.rightPad((String)Objects.toString(rs.getObject(i)), (int)colsizes[i]));
                }
                System.out.println();
            }
            rs.close();
            System.out.println();
        }
        rs1.close();
        stmt1.close();
        stmt0.close();
        conn.close();
    }

    private static String getH2Typename(com.healthmarketscience.jackcess.Column column) {
        if (mdbtypes2h2 == null) {
            mdbtypes2h2 = new HashMap<String, String>();
            mdbtypes2h2.put("TEXT", "VARCHAR");
            mdbtypes2h2.put("BYTE", "INT");
            mdbtypes2h2.put("INT", "INT");
            mdbtypes2h2.put("LONG", "INT");
            mdbtypes2h2.put("DOUBLE", "DOUBLE");
            mdbtypes2h2.put("SHORT_DATE_TIME", "VARCHAR");
            mdbtypes2h2.put("MONEY", "DOUBLE");
            mdbtypes2h2.put("BOOLEAN", "BOOLEAN");
            mdbtypes2h2.put("GUID", "VARCHAR");
            mdbtypes2h2.put("MEMO", "CLOB");
            mdbtypes2h2.put("COMPLEX_TYPE", "BLOB");
            mdbtypes2h2.put("NUMERIC", "NUMERIC");
        }
        String type = column.getType().toString().toUpperCase();
        return mdbtypes2h2.getOrDefault(type, "???" + type + "???");
    }

    public static String createTableSQL(com.healthmarketscience.jackcess.Table table) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE \"");
        builder.append(table.getName());
        builder.append("\" (");
        builder.append("\n");
        boolean first = true;
        for (com.healthmarketscience.jackcess.Column column : table.getColumns()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
                builder.append("\n");
            }
            builder.append(" \"");
            builder.append(column.getName());
            builder.append("\" ");
            builder.append(Testmdb.getH2Typename(column));
        }
        builder.append("\n");
        builder.append(") ");
        builder.append("\n");
        builder.append("ENGINE \"");
        builder.append(MDBTableEngine.class.getName());
        builder.append("\" ");
        builder.append("\n");
        builder.append("WITH \"");
        builder.append(table.getDatabase().getFile().getAbsolutePath());
        builder.append("\"");
        return builder.toString();
    }

    public static class MDBTableEngine
    implements TableEngine {
        public Table createTable(CreateTableData data) {
            return new MDBTable(data);
        }

        private static class MDBTable
        extends TableBase {
            private static final Map<File, Database> mdbDatabases = new HashMap<File, Database>();
            private final File mdbfile;

            private MDBTable(CreateTableData data) {
                super(data);
                this.mdbfile = new File((String)data.tableEngineParams.get(0));
            }

            public com.healthmarketscience.jackcess.Table getMdbTable() {
                com.healthmarketscience.jackcess.Table mdbtable;
                Database mdbdatabase = mdbDatabases.get(this.mdbfile);
                if (mdbdatabase == null) {
                    try {
                        mdbdatabase = DatabaseBuilder.open((File)this.mdbfile);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Can't open database file '" + this.mdbfile + "'.", ex);
                    }
                }
                try {
                    mdbtable = mdbdatabase.getTable(this.getName());
                }
                catch (IOException ex) {
                    throw new RuntimeException("Can't open table '" + this.getName() + "' database file '" + this.mdbfile + "'.", ex);
                }
                return mdbtable;
            }

            public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
                return null;
            }

            public void addRow(Session session, org.h2.result.Row r) {
            }

            public boolean canDrop() {
                return true;
            }

            public boolean canGetRowCount() {
                return true;
            }

            public void checkSupportAlter() {
            }

            public void close(Session session) {
            }

            public ArrayList<Index> getIndexes() {
                return null;
            }

            public long getMaxDataModificationId() {
                return 0L;
            }

            public long getRowCount(Session session) {
                return this.getRowCountApproximation();
            }

            public long getRowCountApproximation() {
                return this.getMdbTable().getRowCount();
            }

            public Index getScanIndex(Session session) {
                return new Scan((Table)this);
            }

            public TableType getTableType() {
                return TableType.EXTERNAL_TABLE_ENGINE;
            }

            public Index getUniqueIndex() {
                return null;
            }

            public boolean isDeterministic() {
                return false;
            }

            public boolean isLockedExclusively() {
                return false;
            }

            public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
                return false;
            }

            public void removeRow(Session session, org.h2.result.Row r) {
            }

            public void truncate(Session session) {
            }

            public void unlock(Session s) {
            }

            public void checkRename() {
            }

            public long getDiskSpaceUsed() {
                return -1L;
            }

            private class MDBCursor
            implements Cursor {
                private final com.healthmarketscience.jackcess.Cursor cursor;

                private MDBCursor(com.healthmarketscience.jackcess.Cursor cursor) {
                    this.cursor = cursor;
                }

                public org.h2.result.Row get() {
                    try {
                        Row r = this.cursor.getCurrentRow();
                        MDBRowAdapterToRow row = new MDBRowAdapterToRow(r);
                        return row;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Can't get current row", ex);
                    }
                }

                public SearchRow getSearchRow() {
                    return this.get();
                }

                public boolean next() {
                    try {
                        return this.cursor.getNextRow() != null;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Can't move to next row", ex);
                    }
                }

                public boolean previous() {
                    try {
                        return this.cursor.getPreviousRow() != null;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Can't move to previous row", ex);
                    }
                }
            }

            private class MDBRowAdapterToRow
            implements org.h2.result.Row {
                private long key;
                private int version;
                private boolean deleted;
                private int sessionId;
                private Row row;

                public MDBRowAdapterToRow(Row row) {
                    this.row = row;
                }

                public org.h2.result.Row getCopy() {
                    try {
                        MDBRowAdapterToRow copy = (MDBRowAdapterToRow)this.clone();
                        copy.row = new RowImpl(this.row);
                        return copy;
                    }
                    catch (CloneNotSupportedException ex) {
                        throw new RuntimeException("Can't copy row", ex);
                    }
                }

                public void setVersion(int version) {
                    this.version = version;
                }

                public int getByteCount(Data dummy) {
                    return -1;
                }

                public boolean isEmpty() {
                    return false;
                }

                public void setDeleted(boolean deleted) {
                    this.deleted = deleted;
                }

                public void setSessionId(int sessionId) {
                    this.sessionId = sessionId;
                }

                public int getSessionId() {
                    return this.sessionId;
                }

                public void commit() {
                }

                public boolean isDeleted() {
                    return this.deleted;
                }

                public Value[] getValueList() {
                    Value[] values = new Value[MDBTable.this.getMdbTable().getColumnCount()];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = this.getValue(i);
                    }
                    return values;
                }

                public int getColumnCount() {
                    return this.row.size();
                }

                public Value getValue(int index) {
                    com.healthmarketscience.jackcess.Column column = (com.healthmarketscience.jackcess.Column)MDBTable.this.getMdbTable().getColumns().get(index);
                    Object data = this.row.get((Object)column.getName());
                    if (data == null) {
                        return ValueNull.INSTANCE;
                    }
                    ValueNull v = null;
                    switch (column.getType()) {
                        case TEXT: {
                            v = ValueString.get((String)this.row.getString(column.getName()));
                            break;
                        }
                        case BYTE: {
                            v = ValueInt.get((int)((Number)this.row.getByte(column.getName())).intValue());
                            break;
                        }
                        case INT: {
                            v = ValueInt.get((int)((Number)this.row.getShort(column.getName())).intValue());
                            break;
                        }
                        case LONG: {
                            v = ValueLong.get((long)((Number)this.row.getInt(column.getName())).longValue());
                            break;
                        }
                        case DOUBLE: {
                            v = ValueDouble.get((double)this.row.getDouble(column.getName()));
                            break;
                        }
                        case SHORT_DATE_TIME: {
                            v = ValueString.get((String)this.row.get((Object)column.getName()).toString());
                            break;
                        }
                        case MONEY: {
                            v = ValueDouble.get((double)((Number)this.row.getBigDecimal(column.getName())).doubleValue());
                            break;
                        }
                        case NUMERIC: {
                            v = ValueDouble.get((double)((Number)this.row.getBigDecimal(column.getName())).doubleValue());
                            break;
                        }
                        case BOOLEAN: {
                            v = ValueBoolean.get((boolean)this.row.getBoolean(column.getName()));
                            break;
                        }
                        case GUID: {
                            v = ValueString.get((String)this.row.get((Object)column.getName()).toString());
                            break;
                        }
                        case MEMO: {
                            v = ValueString.get((String)this.row.getString(column.getName()));
                            break;
                        }
                        case COMPLEX_TYPE: {
                            v = ValueNull.INSTANCE;
                        }
                    }
                    return v;
                }

                public void setValue(int index, Value v) {
                }

                public void setKeyAndVersion(SearchRow row) {
                    this.setKey(row.getKey());
                    this.setVersion(row.getVersion());
                }

                public int getVersion() {
                    return this.version;
                }

                public void setKey(long key) {
                    this.key = key;
                }

                public long getKey() {
                    return this.key;
                }

                public int getMemory() {
                    return -1;
                }
            }

            private class Scan
            extends BaseIndex {
                Scan(Table table) {
                    this.initBaseIndex(table, table.getId(), table.getName() + "_SCAN", IndexColumn.wrap((Column[])table.getColumns()), IndexType.createScan((boolean)false));
                }

                public long getRowCountApproximation() {
                    return MDBTable.this.getMdbTable().getRowCount();
                }

                public long getRowCount(Session session) {
                    return MDBTable.this.getMdbTable().getRowCount();
                }

                public void checkRename() {
                }

                public void truncate(Session session) {
                }

                public void remove(Session session) {
                }

                public void remove(Session session, org.h2.result.Row r) {
                }

                public boolean needRebuild() {
                    return false;
                }

                public double getCost(Session session, int[] masks) {
                    return 1.0;
                }

                public Cursor findFirstOrLast(Session session, boolean first) {
                    com.healthmarketscience.jackcess.Cursor cursor = MDBTable.this.getMdbTable().getDefaultCursor();
                    if (first) {
                        cursor.beforeFirst();
                    } else {
                        cursor.afterLast();
                    }
                    return new MDBCursor(cursor);
                }

                public Cursor find(Session session, SearchRow first, SearchRow last) {
                    com.healthmarketscience.jackcess.Table mdbtable = MDBTable.this.getMdbTable();
                    com.healthmarketscience.jackcess.Cursor cursor = mdbtable.getDefaultCursor();
                    return new MDBCursor(cursor);
                }

                public void close(Session session) {
                }

                public boolean canGetFirstOrLast() {
                    return true;
                }

                public void add(Session session, org.h2.result.Row r) {
                }

                public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
                    return 1.0;
                }

                public long getDiskSpaceUsed() {
                    return -1L;
                }
            }
        }
    }

    public static class MDBConnection
    extends JdbcConnection {
        private final File mdbfile;
        private Database mdbDatabase;

        public MDBConnection(File mdbfile, String url, Properties info) throws SQLException {
            super(new ConnectionInfo(url, info), true);
            this.mdbfile = mdbfile;
            this.addTables();
        }

        private void addTables() {
            try {
                this.mdbDatabase = DatabaseBuilder.open((File)this.mdbfile);
                for (String tableName : this.mdbDatabase.getTableNames()) {
                    String sql = Testmdb.createTableSQL(this.mdbDatabase.getTable(tableName));
                    this.createStatement().execute(sql);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't add external tables", ex);
            }
        }

        public synchronized void close() throws SQLException {
            super.close();
            try {
                this.mdbDatabase.close();
            }
            catch (IOException ex) {
                throw new SQLException("Can't close mdb database", ex);
            }
            this.mdbDatabase = null;
        }
    }

    public static class Driver
    implements java.sql.Driver,
    JdbcDriverBackwardsCompat {
        private static final Driver INSTANCE = new Driver();
        private static volatile boolean registered;

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            try {
                if (info == null) {
                    info = new Properties();
                }
                if (!this.acceptsURL(url)) {
                    return null;
                }
                Connection c = DbUpgrade.connectOrUpgrade((String)url, (Properties)info);
                if (c != null) {
                    return c;
                }
                String[] ss = url.split(":");
                String h2url = "jdbc:h2:mem:test;EARLY_FILTER=TRUE";
                MDBConnection conn = new MDBConnection(new File(ss[2]), h2url, info);
                return conn;
            }
            catch (Exception e) {
                throw DbException.toSQLException((Exception)e);
            }
        }

        @Override
        public boolean acceptsURL(String url) {
            if (url != null) {
                if (StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"jdbc:mdb:")) {
                    return true;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"jdbc:accdb:")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getMajorVersion() {
            return 1;
        }

        @Override
        public int getMinorVersion() {
            return 4;
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
            return new DriverPropertyInfo[0];
        }

        @Override
        public boolean jdbcCompliant() {
            return true;
        }

        @Override
        public Logger getParentLogger() {
            return null;
        }

        public static synchronized Driver load() {
            try {
                Class.forName("org.h2.Driver");
                if (!registered) {
                    registered = true;
                    DriverManager.registerDriver(INSTANCE);
                }
            }
            catch (Exception e) {
                DbException.traceThrowable((Throwable)e);
            }
            return INSTANCE;
        }

        public static synchronized void unload() {
            try {
                if (registered) {
                    registered = false;
                    DriverManager.deregisterDriver(INSTANCE);
                }
            }
            catch (SQLException e) {
                DbException.traceThrowable((Throwable)e);
            }
        }

        static {
            Driver.load();
        }
    }
}

