/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.remoteclient.exceptions.ServerErrorException;
import org.gvsig.remoteclient.exceptions.WMSException;
import org.gvsig.remoteclient.ogc.OGCProtocolHandler;
import org.gvsig.remoteclient.ogc.OGCServiceInformation;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wms.WMSLayer;
import org.gvsig.remoteclient.wms.WMSServiceInformation;
import org.gvsig.remoteclient.wms.WMSStatus;
import org.gvsig.remoteclient.wms.WMSStyle;
import org.gvsig.remoteclient.wms.request.WMSGetCapabilitiesRequest;
import org.gvsig.remoteclient.wms.request.WMSGetFeatureInfoRequest;
import org.gvsig.remoteclient.wms.request.WMSGetLegendGraphicRequest;
import org.gvsig.remoteclient.wms.request.WMSGetMapRequest;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public abstract class WMSProtocolHandler
extends OGCProtocolHandler {
    private static final Logger logger = LoggerFactory.getLogger(WMSProtocolHandler.class);
    protected String encoding = "UTF-8";
    protected WMSServiceInformation serviceInfo;
    public TreeMap layers;
    public WMSLayer rootLayer;

    public String getName() {
        return this.name;
    }

    public OGCServiceInformation getServiceInformation() {
        return this.serviceInfo;
    }

    public void getCapabilities(WMSStatus status, boolean override, ICancellable cancel) {
        URL request = null;
        try {
            request = new URL(this.buildCapabilitiesRequest(status));
        }
        catch (Exception e) {
            logger.warn("Can't get capabilities, error building url.", (Throwable)e);
        }
        try {
            File f;
            if (override) {
                Utilities.removeURL((URL)request);
            }
            if ((f = Utilities.downloadFile((URL)request, (String)"wms_capabilities.xml", (ICancellable)cancel)) == null) {
                return;
            }
            this.clear();
            this.parseCapabilities(f);
        }
        catch (Exception e) {
            logger.warn("Can't get capabilities.", (Throwable)e);
        }
    }

    private void clear() {
        this.layers.clear();
        this.serviceInfo.clear();
    }

    public String getFeatureInfo(WMSStatus status, int x, int y, int featureCount, ICancellable cancel) {
        StringBuffer output = new StringBuffer();
        String outputFormat = new String();
        String ServiceException = "ServiceExceptionReport";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        try {
            WMSGetFeatureInfoRequest request = this.createGetFeatureInfoRequest(status, x, y);
            URL url = request.getURL();
            outputFormat = url.openConnection().getContentType();
            File f = request.sendRequest(cancel);
            if (f == null) {
                return "";
            }
            FileReader fReader = new FileReader(f);
            char[] buffer = new char[262144];
            int i = fReader.read(buffer);
            while (i > 0) {
                String str = new String(buffer, 0, i);
                output.append(str);
                i = fReader.read(buffer);
            }
            if (outputFormat == null || outputFormat.indexOf("xml") != -1 || output.toString().toLowerCase().startsWith("<?xml") || outputFormat.indexOf("gml") != -1) {
                KXmlParser kxmlParser = null;
                kxmlParser = new KXmlParser();
                kxmlParser.setInput((Reader)new FileReader(f));
                int tag = kxmlParser.nextTag();
                if (kxmlParser.getName().compareTo(ServiceException) == 0) {
                    sb.append("<INFO>").append(this.parseException(output.toString().getBytes())).append("</INFO>");
                    return sb.toString();
                }
                if (kxmlParser.getName().compareToIgnoreCase("ERROR") == 0) {
                    return output.toString();
                }
                return output.toString();
            }
            return output.toString();
        }
        catch (XmlPullParserException parserEx) {
            if (output.toString().toLowerCase().indexOf("xml") != -1) {
                return output.toString().trim();
            }
            sb.append("<INFO>").append("Info format not supported").append("</INFO>");
            return sb.toString();
        }
        catch (Exception e) {
            logger.warn("Can't get information by point.", (Throwable)e);
            sb.append("<INFO>").append("Info format not supported").append("</INFO>");
            return sb.toString();
        }
    }

    public byte[] _getMap(WMSStatus status) throws ServerErrorException, WMSException {
        try {
            WMSGetMapRequest request = this.createGetMapRequest(status);
            URL url = request.getURL();
            URLConnection conn = url.openConnection();
            logger.info(((Object)((Object)request)).toString());
            String type = conn.getContentType();
            byte[] imageBytes = null;
            byte[] buffer = new byte[262144];
            InputStream is = conn.getInputStream();
            int readed = 0;
            int i = is.read(buffer);
            while (i > 0) {
                byte[] buffered = new byte[readed + i];
                for (int j = 0; j < buffered.length; ++j) {
                    buffered[j] = j < readed ? imageBytes[j] : buffer[j - readed];
                }
                imageBytes = (byte[])buffered.clone();
                readed += i;
                i = is.read(buffer);
            }
            if (type != null && !type.subSequence(0, 5).equals("image") || Utilities.isTextData(imageBytes)) {
                String xml;
                String error;
                int pos;
                WMSException wmsEx = null;
                String exceptionMessage = this.parseException(imageBytes);
                if (exceptionMessage == null && (pos = (error = new String(imageBytes)).indexOf("<?xml")) != -1 && (exceptionMessage = this.parseException((xml = error.substring(pos, error.length())).getBytes())) == null) {
                    exceptionMessage = new String(imageBytes);
                }
                wmsEx = new WMSException(exceptionMessage);
                wmsEx.setWMSMessage(new String(imageBytes));
                throw wmsEx;
            }
            return imageBytes;
        }
        catch (IOException e) {
            logger.warn("Can't build map request.", (Throwable)e);
            throw new ServerErrorException();
        }
    }

    public File getLegendGraphic_old(WMSStatus status, String layerName, ICancellable cancel) throws ServerErrorException, WMSException {
        try {
            WMSGetLegendGraphicRequest request = this.createGetLegendGraphicRequest(status, layerName);
            File f = request.sendRequest(cancel);
            if (f == null) {
                return null;
            }
            if (Utilities.isTextFile((File)f)) {
                byte[] data = this.fileToBytes(f);
                WMSException wmsEx = null;
                String exceptionMessage = this.parseException(data);
                if (exceptionMessage == null) {
                    String error = new String(data);
                    int pos = error.indexOf("<?xml");
                    if (pos != -1) {
                        String xml = error.substring(pos, error.length());
                        exceptionMessage = this.parseException(xml.getBytes());
                    }
                    if (exceptionMessage == null) {
                        exceptionMessage = new String(data);
                    }
                }
                wmsEx = new WMSException(exceptionMessage);
                wmsEx.setWMSMessage(new String(data));
                downloader.removeURL((Object)request);
                throw wmsEx;
            }
            return f;
        }
        catch (IOException e) {
            logger.warn("Can't get legend graphics.", (Throwable)e);
            throw new ServerErrorException();
        }
    }

    public File getLegendGraphic(WMSStatus status, String layerName, ICancellable cancel) throws ServerErrorException, WMSException {
        URL request = null;
        try {
            status.setOnlineResource(status.getOnlineResource().replaceAll(" ", "%20"));
            request = new URL(this.buildGetLegendGraphicRequest(status, layerName));
            logger.info(request.toString());
            File f = Utilities.downloadFile((URL)request, (String)"wmsGetLegendGraphic", (ICancellable)cancel);
            if (f == null) {
                return null;
            }
            if (Utilities.isTextFile((File)f)) {
                FileInputStream fis = new FileInputStream(f);
                FileChannel fc = fis.getChannel();
                byte[] data = new byte[(int)fc.size()];
                ByteBuffer bb = ByteBuffer.wrap(data);
                fc.read(bb);
                WMSException wmsEx = null;
                String exceptionMessage = this.parseException(data);
                if (exceptionMessage == null) {
                    String error = new String(data);
                    int pos = error.indexOf("<?xml");
                    if (pos != -1) {
                        String xml = error.substring(pos, error.length());
                        exceptionMessage = this.parseException(xml.getBytes());
                    }
                    if (exceptionMessage == null) {
                        exceptionMessage = new String(data);
                    }
                }
                wmsEx = new WMSException(exceptionMessage);
                wmsEx.setWMSMessage(new String(data));
                Utilities.removeURL((URL)request);
                throw wmsEx;
            }
            return f;
        }
        catch (IOException e) {
            logger.warn("Can't get legend graphics", (Throwable)e);
            throw new ServerErrorException();
        }
    }

    private String buildGetLegendGraphicRequest(WMSStatus status, String layerName) {
        WMSLayer lyr = (WMSLayer)this.layers.get(layerName);
        WMSStyle sty2 = null;
        if (lyr != null) {
            for (WMSStyle sty2 : lyr.getStyles()) {
                if (!sty2.getName().equals(status.getStyles().get(0).toString())) continue;
                return sty2.getLegendURLOnlineResourceHRef().replaceAll(" ", "%20");
            }
        }
        StringBuffer req = new StringBuffer();
        String symbol = null;
        String onlineResource = null;
        onlineResource = status.getOnlineResource() == null ? this.getHost() : status.getOnlineResource();
        symbol = WMSProtocolHandler.getSymbol((String)onlineResource);
        req.append(onlineResource + symbol + "REQUEST=GetLegendGraphic&SERVICE=WMS&VERSION=").append(this.getVersion());
        req.append("&LAYER=" + layerName).append("&TRANSPARENT=TRUE").append("&FORMAT=image/png");
        String aux = req.toString().replaceAll(" ", "%20");
        logger.info("GetLegendGraphic url:" + aux);
        return aux;
    }

    public URL getMapURL(WMSStatus status, ICancellable cancel) throws ServerErrorException, WMSException {
        try {
            WMSGetMapRequest request = this.createGetMapRequest(status);
            return request.getURL();
        }
        catch (IOException e) {
            logger.warn("Can't get map URL", (Throwable)e);
            throw new ServerErrorException();
        }
    }

    public String getExceptionMessage(File f) throws IOException {
        if (f == null) {
            return null;
        }
        if (Utilities.isTextFile((File)f)) {
            byte[] data = this.fileToBytes(f);
            String exceptionMessage = this.parseException(data);
            if (exceptionMessage == null) {
                String error = new String(data);
                int pos = error.indexOf("<?xml");
                if (pos != -1) {
                    String xml = error.substring(pos, error.length());
                    exceptionMessage = this.parseException(xml.getBytes());
                }
                if (exceptionMessage == null) {
                    exceptionMessage = new String(data);
                }
            }
            return exceptionMessage;
        }
        return null;
    }

    public File getMap(WMSStatus status, ICancellable cancel) throws ServerErrorException, WMSException {
        try {
            WMSGetMapRequest request = this.createGetMapRequest(status);
            File f = request.sendRequest(cancel);
            if (f == null) {
                return null;
            }
            if (Utilities.isTextFile((File)f)) {
                byte[] data = this.fileToBytes(f);
                WMSException wmsEx = null;
                String exceptionMessage = this.parseException(data);
                if (exceptionMessage == null) {
                    String error = new String(data);
                    int pos = error.indexOf("<?xml");
                    if (pos != -1) {
                        String xml = error.substring(pos, error.length());
                        exceptionMessage = this.parseException(xml.getBytes());
                    }
                    if (exceptionMessage == null) {
                        exceptionMessage = new String(data);
                    }
                }
                wmsEx = new WMSException(exceptionMessage);
                wmsEx.setWMSMessage(new String(data));
                downloader.removeURL((Object)request);
                throw wmsEx;
            }
            return f;
        }
        catch (IOException e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    protected String parseException(byte[] data) {
        ArrayList<String> errors = new ArrayList<String>();
        KXmlParser kxmlParser = new KXmlParser();
        try {
            kxmlParser.setInput((InputStream)new ByteArrayInputStream(data), this.encoding);
            kxmlParser.nextTag();
            if (kxmlParser.getEventType() != 1) {
                kxmlParser.require(2, null, "ServiceExceptionReport");
                int tag = kxmlParser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (kxmlParser.getName().compareTo("ServiceException") != 0) break;
                            String errorCode = kxmlParser.getAttributeValue("", "code");
                            errorCode = errorCode != null ? "[" + errorCode + "] " : "";
                            String errorMessage = kxmlParser.nextText();
                            errors.add(errorCode + errorMessage);
                            break;
                        }
                    }
                    tag = kxmlParser.nextTag();
                }
            }
        }
        catch (XmlPullParserException parser_ex) {
            logger.warn("", (Throwable)parser_ex);
        }
        catch (IOException ioe) {
            logger.warn("", (Throwable)ioe);
        }
        String message = errors.size() > 0 ? "" : null;
        for (int i = 0; i < errors.size(); ++i) {
            message = message + (String)errors.get(i) + "\n";
        }
        return message;
    }

    public static String buildCapabilitiesSuitableVersionRequest(String _host, String _version) {
        int index = _host.indexOf(63);
        if (index > -1) {
            String host = _host.substring(0, index + 1);
            String query = _host.substring(index + 1, _host.length());
            StringTokenizer tokens = new StringTokenizer(query, "&");
            String newQuery = "";
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.toUpperCase().compareTo("REQUEST=GETCAPABILITIES") == 0 || token.toUpperCase().compareTo("SERVICE=WMS") == 0 || _version != null && _version.length() > 0 && token.toUpperCase().compareTo("VERSION=" + _version) == 0 || token.toUpperCase().compareTo("EXCEPTIONS=XML") == 0) continue;
                newQuery = newQuery + token + "&";
            }
            _host = host + newQuery;
        } else {
            _host = _host + "?";
        }
        _host = _version != null && _version.compareTo("") != 0 ? _host + "REQUEST=GetCapabilities&SERVICE=WMS&VERSION=" + _version : _host + "REQUEST=GetCapabilities&SERVICE=WMS";
        return _host;
    }

    private String buildCapabilitiesRequest(WMSStatus status) {
        StringBuffer req = new StringBuffer();
        String symbol = null;
        String onlineResource = status == null || status.getOnlineResource() == null ? this.getHost() : status.getOnlineResource();
        symbol = WMSProtocolHandler.getSymbol((String)onlineResource);
        req.append(onlineResource).append(symbol);
        if (req.toString().toLowerCase().lastIndexOf("request=getcapabilities") == -1) {
            req.append("REQUEST=GetCapabilities");
        }
        if (req.toString().toLowerCase().lastIndexOf("&service=wms") == -1) {
            req.append("&SERVICE=WMS");
        }
        if (req.toString().toLowerCase().lastIndexOf("&version=") == -1) {
            req.append("&VERSION=").append(this.getVersion());
        }
        return req.toString();
    }

    public void close() {
    }

    protected abstract WMSGetMapRequest createGetMapRequest(WMSStatus var1);

    protected abstract WMSGetFeatureInfoRequest createGetFeatureInfoRequest(WMSStatus var1, int var2, int var3);

    protected abstract WMSGetLegendGraphicRequest createGetLegendGraphicRequest(WMSStatus var1, String var2);

    protected abstract WMSGetCapabilitiesRequest createGetCapabilitiesRequest(WMSStatus var1);

    protected void parseRequestTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Request");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("GetCapabilities") == 0) {
                        this.parserDcpType(parser, "GetCapabilities");
                        break;
                    }
                    if (parser.getName().compareTo("GetMap") == 0) {
                        this.parseGetMapTag(parser);
                        break;
                    }
                    if (parser.getName().compareTo("GetFeatureInfo") == 0) {
                        this.parseGetFeatureInfoTag(parser);
                        break;
                    }
                    if (parser.getName().compareTo("DescribeLayer") == 0) {
                        this.parserDcpType(parser, "DescribeLayer");
                        break;
                    }
                    if (parser.getName().compareTo("GetLegendGraphic") != 0) break;
                    this.parseGetLegendGraphicTag(parser);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Request") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    protected void parseGetMapTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "GetMap");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Format") == 0) {
                        this.serviceInfo.formats.add(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("DCPType") != 0) break;
                    this.parserDcpType(parser, "GetMap");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("GetMap") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    protected void parseGetFeatureInfoTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "GetFeatureInfo");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Format") == 0) {
                        this.serviceInfo.infoformats.add(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("DCPType") != 0) break;
                    this.parserDcpType(parser, "GetFeatureInfo");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("GetFeatureInfo") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    protected void parseGetLegendGraphicTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "GetLegendGraphic");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Format") == 0 || parser.getName().compareTo("DCPType") != 0) break;
                    this.parserDcpType(parser, "GetLegendGraphic");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("GetLegendGraphic") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }
}

