/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.swing.impl;

import java.awt.Image;
import javax.swing.ImageIcon;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconThemeHelper {
    private static Logger logger = LoggerFactory.getLogger(IconThemeHelper.class);

    public static void registerIcon(String group, String name, Object obj) {
        String provider;
        ClassLoader loader;
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        String resourceName = group == null || group.trim().length() == 0 ? "images/" + name + ".png" : "images/" + group + "/" + name + ".png";
        if (obj instanceof Class) {
            loader = ((Class)obj).getClassLoader();
            provider = ((Class)obj).getName();
        } else {
            loader = obj.getClass().getClassLoader();
            provider = obj.getClass().getName();
        }
        try {
            iconTheme.registerDefault(provider, group, name, null, loader.getResource(resourceName));
        }
        catch (Throwable e) {
            logger.info(e.getMessage());
        }
    }

    public static ImageIcon getImageIcon(String iconName) {
        IconThemeManager manager = ToolsSwingLocator.getIconThemeManager();
        return manager.getCurrent().get(iconName);
    }

    public static Image getImage(String iconName) {
        IconThemeManager manager = ToolsSwingLocator.getIconThemeManager();
        return manager.getCurrent().get(iconName).getImage();
    }
}

