/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceComboBoxButton;
import org.jvnet.substance.SubstanceComboBoxRenderer;
import org.jvnet.substance.SubstanceImageCreator;

public class SubstanceComboBoxUI
extends BasicComboBoxUI {
    public static final Icon COMBO_ARROW = SubstanceImageCreator.getArrowIcon(9, 6, 5);

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceComboBoxUI();
    }

    protected JButton createArrowButton() {
        return new SubstanceComboBoxButton(this.comboBox, COMBO_ARROW);
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceComboBoxRenderer.SubstanceUIResource();
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension superRes = super.getPreferredSize(c);
        Dimension res = new Dimension((int)superRes.getWidth() + 4, (int)superRes.getHeight() + 4);
        return res;
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            cb.setBorder(new SubstanceBorder());
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.getInsets();
            int buttonWidth = UIManager.getInt("ScrollBar.width") - 1;
            int buttonHeight = height - (insets.top + insets.bottom);
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                SubstanceComboBoxUI.this.editor.setBounds(SubstanceComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

