/*
 * Decompiled with CFR 0.152.
 */
package es.gva.cit.jmrsid;

import es.gva.cit.jmrsid.MrSIDException;
import es.gva.cit.jmrsid.MrSIDImageReaderBase;
import java.io.IOException;

public class MrSIDImageReader
extends MrSIDImageReaderBase {
    private native long MrSIDImageReaderNat(String var1);

    private native long MrSIDImageReaderArrayNat(byte[] var1);

    private native void FreeMrSIDImageReaderNat(long var1);

    public MrSIDImageReader() {
    }

    public MrSIDImageReader(long cPtr) {
        this.cPtr = cPtr;
    }

    protected void finalize() {
        if (this.cPtr != 0L) {
            this.close();
        }
    }

    public void close() {
        if (this.cPtr != 0L) {
            this.FreeMrSIDImageReaderNat(this.cPtr);
            this.cPtr = 0L;
        }
    }

    public MrSIDImageReader(String pszFilename) throws MrSIDException, IOException {
        this.cPtr = this.MrSIDImageReaderArrayNat(pszFilename.getBytes());
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error in MrDID Open");
        }
    }

    public int getNumLevels() throws MrSIDException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac os x")) {
            return this.getNumLevelsFromMinMagnification();
        }
        String msg1 = "Error en getNumLevels. No se ha obtenido un puntero valido a LTIImage";
        String msg2 = "La llamada nativa a getNumLevels ha devuelto un c\u00f3digo de error";
        return this.baseSimpleFunction(2, msg1, msg2);
    }

    public int getNumLevelsFromMinMagnification() throws MrSIDException {
        double mag = this.getMinMagnification();
        double aux = (double)this.getWidth() * mag;
        int cont = 0;
        while (aux < (double)this.getWidth()) {
            aux *= 2.0;
            ++cont;
        }
        return cont;
    }
}

