/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.tika.utils.StringUtils;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;

public class CoerceToBoolean
extends AbstractCoercion {
    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        return CoerceToBoolean.convert(value);
    }

    public static Boolean convert(Object value) {
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            if (value instanceof Number) {
                value = ((Number)value).intValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
            } else {
                String s = value.toString();
                if (StringUtils.isBlank((String)s)) {
                    return null;
                }
                value = BooleanUtils.toBoolean((String)s);
            }
            return (Boolean)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't convert", e);
        }
    }
}

