/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.folders.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.gvsig.tools.folders.FoldersManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFoldersManager
implements FoldersManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFoldersManager.class);
    private File temporaryFolder;
    private Map<String, File> paths;
    private int uniqueCounter = 1;

    public DefaultFoldersManager() {
        File f;
        String temp = System.getenv("GVSIG_TEMP");
        if (StringUtils.isEmpty((CharSequence)temp)) {
            temp = FileUtils.getTempDirectoryPath();
            f = FileUtils.getFile((String[])new String[]{temp, "tmp-gvsig"});
        } else {
            f = new File(temp);
        }
        this.setTemporaryFolder(f);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DefaultFoldersManager.this.cleanTemporaryFiles();
            }
        });
    }

    private Map<String, File> getPaths() {
        if (this.paths == null) {
            this.paths = new HashMap<String, File>();
        }
        return this.paths;
    }

    @Override
    public boolean isEmpty() {
        return this.paths == null || this.paths.isEmpty();
    }

    @Override
    public void setLastPath(String pathId, File path) {
        if (StringUtils.isBlank((CharSequence)pathId)) {
            throw new IllegalArgumentException("Invalid argument pathId, it is a blank string.");
        }
        this.getPaths().put("last.path." + pathId, path);
    }

    @Override
    public File getLastPath(String pathId) {
        return this.getLastPath(pathId, null);
    }

    @Override
    public File getLastPath(String pathId, File defaultValue) {
        File path;
        if (!StringUtils.isBlank((CharSequence)pathId) && (path = this.getPaths().get("last.path." + pathId)) != null) {
            return path;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return FileSystemView.getFileSystemView().getHomeDirectory();
    }

    @Override
    public Iterator<Map.Entry<String, File>> lastPathsIterator() {
        final Iterator<Map.Entry<String, File>> it0 = this.getPaths().entrySet().iterator();
        Iterator<Map.Entry<String, File>> it = new Iterator<Map.Entry<String, File>>(){
            Map.Entry<String, File> last = null;

            @Override
            public boolean hasNext() {
                while (it0.hasNext()) {
                    this.last = (Map.Entry)it0.next();
                    if (!StringUtils.startsWithIgnoreCase((CharSequence)this.last.getKey(), (CharSequence)"last.path.")) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, File> next() {
                if (this.last == null) {
                    return null;
                }
                return new ImmutablePair((Object)this.last.getKey().substring(10), (Object)this.last.getValue());
            }
        };
        return it;
    }

    private int getPID() {
        try {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            int java_pid = Integer.parseInt(rt.getName().substring(0, rt.getName().indexOf("@")));
            return java_pid;
        }
        catch (Throwable th) {
            return 0;
        }
    }

    @Override
    public File getTemporaryFolder() {
        return this.temporaryFolder;
    }

    @Override
    public final void setTemporaryFolder(File folder) {
        if (folder == null) {
            throw new IllegalArgumentException("Can't set temporary folder to null.");
        }
        this.temporaryFolder = folder.getAbsoluteFile();
        this.createTemporaryFolder();
    }

    @Override
    public void cleanTemporaryFiles() {
        if (this.temporaryFolder == null) {
            LOGGER.warn("Can't clean temporary folder, is null.");
        }
        try {
            FileUtils.cleanDirectory((File)this.temporaryFolder);
        }
        catch (IOException ex) {
            LOGGER.warn("Can't clean temporary folder (" + this.temporaryFolder.getAbsolutePath() + ").", (Throwable)ex);
        }
    }

    @Override
    public File createTemporaryFolder() {
        if (this.temporaryFolder == null) {
            throw new RuntimeException("Can't create temporary folder, is null.");
        }
        try {
            FileUtils.forceMkdir((File)this.temporaryFolder);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't create temporary folder", ex);
        }
        return this.temporaryFolder;
    }

    @Override
    public File getTemporaryFile(String ... pathComponents) {
        if (this.temporaryFolder == null) {
            throw new RuntimeException("Can't get temporary file, temporary folder is null.");
        }
        File f = FileUtils.getFile((File)this.temporaryFolder, (String[])pathComponents);
        return f;
    }

    @Override
    public File getUniqueTemporaryFile(String ... pathComponents) {
        File f = this.getTemporaryFile(pathComponents);
        String fullName = f.getAbsolutePath();
        String name = FilenameUtils.removeExtension((String)fullName);
        String extension = FilenameUtils.getExtension((String)fullName);
        fullName = StringUtils.isEmpty((CharSequence)extension) ? name + "-" + Integer.toHexString(this.uniqueCounter) + "-" + Long.toHexString(System.currentTimeMillis()) : name + "-" + Integer.toHexString(this.uniqueCounter) + "-" + Long.toHexString(System.currentTimeMillis()) + "." + extension;
        ++this.uniqueCounter;
        return new File(fullName);
    }

    @Override
    public File getUniqueFile(String ... pathComponents) {
        File f = FileUtils.getFile((String[])pathComponents);
        String fullName = f.getAbsolutePath();
        String name = FilenameUtils.removeExtension((String)fullName);
        String extension = FilenameUtils.getExtension((String)fullName);
        fullName = StringUtils.isEmpty((CharSequence)extension) ? name + "-" + Integer.toHexString(this.uniqueCounter) + "-" + Long.toHexString(System.currentTimeMillis()) : name + "-" + Integer.toHexString(this.uniqueCounter) + "-" + Long.toHexString(System.currentTimeMillis()) + "." + extension;
        ++this.uniqueCounter;
        return new File(fullName);
    }

    @Override
    public File createTemporaryFile(String basename, byte[] data) {
        File file;
        if (this.temporaryFolder == null) {
            throw new RuntimeException("Can't create temporary file, temporary folder is null.");
        }
        File f = this.getTemporaryFile(basename);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            IOUtils.write((byte[])data, (OutputStream)fos);
            f.deleteOnExit();
            file = f;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException("Can't create temporary file '" + f.getAbsolutePath() + "'.");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return file;
    }

    @Override
    public File createTemporaryFile(String basename, String data) throws IOException {
        return this.createTemporaryFile(basename, data.getBytes());
    }

    @Override
    public void set(String id, File file) {
        this.getPaths().put(id, file);
    }

    @Override
    public File get(String id) {
        return this.getPaths().get(id);
    }

    @Override
    public File get(String id, File defaultValue) {
        if (this.getPaths().containsKey(id)) {
            return this.getPaths().get(id);
        }
        return defaultValue;
    }

    @Override
    public File getHome() {
        File home = new File(System.getProperty("user.home"));
        return home;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getPaths().keySet().iterator();
    }
}

