/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.library;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gvsig.tools.library.Library;
import org.gvsig.tools.library.LibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLibrary
implements Library {
    private static Set<String> initialized = new HashSet<String>();
    private static Set<String> postInitialized = new HashSet<String>();
    private static final int DEFAULT_PRIORITY = 0;
    private Set<Library.Required> requireds = null;
    private Class library;
    private String type;
    private int priority = 0;

    protected AbstractLibrary() {
    }

    protected AbstractLibrary(Class library, String type) {
        this.registerAs(library, type);
    }

    protected AbstractLibrary(Class library, int priority) {
        this.registerAsImplementationOf(library, priority);
    }

    public Set getRequireds() {
        return this.requireds;
    }

    @Override
    public Class getLibrary() {
        return this.library;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public final synchronized void require(Class library, String type) {
        this.doRequire(library, type);
    }

    @Override
    public final synchronized void require(Class library) {
        this.doRequire(library, null);
    }

    @Override
    public final synchronized void require(Collection<Library.Required> libraries) {
        if (libraries == null) {
            return;
        }
        if (this.requireds == null) {
            this.requireds = new HashSet<Library.Required>();
        }
        this.requireds.addAll(libraries);
    }

    private void doRequire(Class library, String type) {
        if (this.requireds == null) {
            this.requireds = new HashSet<Library.Required>();
        }
        this.requireds.add(new DefaultRequired(library, type));
    }

    protected final synchronized void registerAs(Class library, String type) {
        this.library = library;
        this.type = type;
        if (this.library != null) {
            if (!Library.class.isAssignableFrom(library)) {
                throw new IllegalArgumentException("Invalid argument in registerAs(library:'" + library + "', type:" + type + ") of class '" + this.getClass().getName() + "', the library argument don't implement the interface Library.");
            }
            if (!"api".equals(type)) {
                this.doRequire(this.library, "api");
                if ("service".equals(type)) {
                    this.doRequire(this.library, "impl");
                }
            }
        }
    }

    protected final synchronized void registerAsAPI(Class library) {
        this.registerAs(library, "api");
    }

    protected final synchronized void registerAsSPI(Class library) {
        this.registerAs(library, "spi");
    }

    protected final synchronized void registerAsImplementationOf(Class library) {
        this.registerAsImplementationOf(library, 0);
    }

    protected final synchronized void registerAsImplementationOf(Class library, int priority) {
        this.registerAs(library, "impl");
        this.priority = priority;
    }

    protected final synchronized void registerAsServiceOf(Class library) {
        this.registerAs(library, "service");
    }

    @Override
    public final synchronized void initialize() throws LibraryException {
        String name = this.getClass().getName();
        if (initialized.contains(name)) {
            return;
        }
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("Initializing library '" + this.getClass().getName() + "'.");
        initialized.add(name);
        try {
            this.doInitialize();
        }
        catch (Throwable t) {
            logger.warn("Can't initialize library '" + this.getClass().getName() + "'.", t);
        }
    }

    @Override
    public final synchronized void postInitialize() throws LibraryException {
        String name = this.getClass().getName();
        if (postInitialized.contains(name)) {
            return;
        }
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("PostInitializing library '" + this.getClass().getName() + "'.");
        try {
            this.doPostInitialize();
        }
        catch (Throwable t) {
            logger.warn("Can't postinitialize library '" + this.getClass().getName() + "'.", t);
        }
        postInitialized.add(name);
    }

    @Override
    public void doRegistration() {
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().getName().equals(obj.getClass().getName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String toString() {
        if (this.getType() == null) {
            return this.getClass().getName();
        }
        String relatedLibName = this.library == null ? this.getClass().getName() : this.library.getName();
        return this.getClass().getName() + " (" + this.getType().toUpperCase() + " of " + relatedLibName + ")";
    }

    @Override
    public boolean isRequired(Library lib) {
        return this.isRequired(lib.getClass());
    }

    @Override
    public boolean isRequired(Class libClass) {
        if (this.requireds != null) {
            for (DefaultRequired defaultRequired : this.requireds) {
                if (!libClass.equals(defaultRequired.getLibraryClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void doInitialize() throws LibraryException;

    protected abstract void doPostInitialize() throws LibraryException;

    public static class DefaultRequired
    implements Library.Required {
        Library library = null;
        Class libraryClass;
        String type;

        DefaultRequired(Class library, String type) {
            this.libraryClass = library;
            this.type = type;
        }

        @Override
        public Class getLibraryClass() {
            return this.libraryClass;
        }

        @Override
        public Library getLibrary(Set<Library> pool) {
            if (this.library == null && pool != null) {
                for (Library lib : pool) {
                    if (lib.getClass() != this.libraryClass) continue;
                    this.library = lib;
                    break;
                }
            }
            return this.library;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.libraryClass.toString() + (this.type == null ? "" : ":" + this.type.toUpperCase());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Library.Required)) {
                return false;
            }
            Library.Required other = (Library.Required)obj;
            if (!Objects.equals(this.getLibraryClass(), other.getLibraryClass())) {
                return false;
            }
            return Objects.equals(this.getType(), other.getType());
        }

        public int hashCode() {
            return Objects.hash(this.libraryClass, this.type);
        }
    }
}

