/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.jts.AbstractGeometry;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.primitive.Primitive;

public abstract class AbstractAggregate
extends AbstractGeometry
implements Aggregate {
    private static final long serialVersionUID = -2922828622616885472L;
    ArrayList<Primitive> primitives = new ArrayList();

    public AbstractAggregate(int type, int subtype) {
        super(type, subtype);
    }

    public int getPrimitivesNumber() {
        return this.primitives.size();
    }

    public Primitive getPrimitiveAt(int i) {
        return this.primitives.get(i);
    }

    public Iterator<Geometry> iterator() {
        return new AggregateIterator();
    }

    public void ensureCapacity(int capacity) {
        this.primitives.ensureCapacity(capacity);
    }

    public void reProject(ICoordTrans ct) {
        for (Primitive primitive : this.primitives) {
            primitive.reProject(ct);
        }
    }

    public void transform(AffineTransform at) {
        for (Primitive primitive : this.primitives) {
            primitive.transform(at);
        }
    }

    @Override
    public boolean is3D() {
        for (GeometryJTS geometryJTS : this.primitives) {
            if (!geometryJTS.is3D()) continue;
            return true;
        }
        return false;
    }

    public Shape getShape(AffineTransform affineTransform) {
        if (this.isEmpty()) {
            return new GeneralPath();
        }
        boolean empty = true;
        Iterator<Geometry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Geometry primitive = iterator.next();
            if (primitive.isEmpty()) continue;
            empty = false;
            break;
        }
        if (empty) {
            return new GeneralPath();
        }
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return this.getShape(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof AbstractAggregate)) return false;
        AbstractAggregate other = (AbstractAggregate)obj;
        if (other.getPrimitivesNumber() != this.getPrimitivesNumber()) return false;
        for (int j = 0; j < this.getPrimitivesNumber(); ++j) {
            if (this.getPrimitiveAt(j).equals(other.getPrimitiveAt(j))) continue;
            return false;
        }
        return true;
    }

    public boolean canBeTransformed(AffineTransform at) {
        for (GeometryJTS geometryJTS : this.primitives) {
            if (geometryJTS.canBeTransformed(at)) continue;
            return false;
        }
        return true;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        for (GeometryJTS geometryJTS : this.primitives) {
            if (geometryJTS.canBeReprojected(ct)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getPrimitivesNumber() < 1;
    }

    public int size() {
        return this.getPrimitivesNumber();
    }

    public Geometry get(int position) {
        return this.getPrimitiveAt(position);
    }

    private class AggregateIterator
    implements Iterator<Geometry> {
        private int current = 0;

        AggregateIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < AbstractAggregate.this.getPrimitivesNumber();
        }

        @Override
        public Geometry next() {
            return AbstractAggregate.this.getPrimitiveAt(this.current++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

