/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiSurface;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;

public class DefaultMultiSurface
extends AbstractMultiSurface {
    private static final long serialVersionUID = 9211543270911740110L;

    public DefaultMultiSurface(GeometryType geometryType) {
        super(geometryType.getSubType());
    }

    public Geometry cloneGeometry() {
        DefaultMultiSurface clone = new DefaultMultiSurface(this.getGeometryType());
        for (int i = 0; i < this.primitives.size(); ++i) {
            clone.addPrimitive((Primitive)((Primitive)this.primitives.get(i)).cloneGeometry());
        }
        clone.setProjection(this.getProjection());
        return clone;
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiSurface other = new DefaultMultiSurface(this.getGeometryType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(0));
        }
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiSurface other = new DefaultMultiSurface(this.getGeometryType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(2));
        }
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiSurface other = new DefaultMultiSurface(this.getGeometryType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(1));
        }
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiSurface other = new DefaultMultiSurface(this.getGeometryType());
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(3));
        }
        return other;
    }

    public void addSurface(Surface surface) {
        GeometryType geometryType = surface.getGeometryType();
        if (geometryType.getSubType() == this.getGeometryType().getSubType()) {
            this.primitives.add(surface);
            return;
        }
        String msg = StringUtils.replaceEach((String)"Only a surface subtype  %(subtypeSurface)s can be added to a MultiSurface subtype %(subtype)s", (String[])new String[]{"%(subtypeSurface)s", "%(subtype)s"}, (String[])new String[]{String.valueOf(geometryType.getSubType()), String.valueOf(this.getGeometryType().getSubType())});
        LOGGER.warn(msg);
        throw new UnsupportedOperationException(msg);
    }

    public int getDimension() {
        switch (this.getGeometryType().getSubType()) {
            case 0: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 1: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint multiPoint = GeometryLocator.getGeometryManager().createMultiPoint(this.getGeometryType().getSubType());
        for (Primitive primitive : this.primitives) {
            MultiPoint primitivePoints = primitive.toPoints();
            for (int i = 0; i < primitivePoints.getPrimitivesNumber(); ++i) {
                multiPoint.addPoint(primitivePoints.getPointAt(i));
            }
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine multiLine = GeometryLocator.getGeometryManager().createMultiLine(this.getGeometryType().getSubType());
        for (Primitive primitive : this.primitives) {
            MultiLine primitiveLines = primitive.toLines();
            for (int i = 0; i < primitiveLines.getPrimitivesNumber(); ++i) {
                multiLine.addPrimitive((Primitive)primitiveLines.getPrimitiveAt(i).cloneGeometry());
            }
        }
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon multiPolygon = GeometryLocator.getGeometryManager().createMultiPolygon(this.getGeometryType().getSubType());
        for (Primitive primitive : this.primitives) {
            MultiPolygon primitivePolygons = primitive.toPolygons();
            for (int i = 0; i < primitivePolygons.getPrimitivesNumber(); ++i) {
                multiPolygon.addPrimitive((Primitive)primitivePolygons.getPrimitiveAt(i).cloneGeometry());
            }
        }
        return multiPolygon;
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        for (GeometryJTS primitive : this.primitives) {
            primitive.flip();
        }
        Collections.reverse(this.primitives);
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        int subType;
        int primitiveSubType = primitive.getGeometryType().getSubType();
        if (primitiveSubType == (subType = this.getGeometryType().getSubType())) {
            return primitive;
        }
        String message = StringUtils.replace((String)"This MultiSurface only accept subtype %(subtype)s primitives", (String)"%(subtype)s", (String)String.valueOf(subType));
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            Polygon polygon;
            if (primitive instanceof org.gvsig.fmap.geom.primitive.Polygon) {
                polygon = (Polygon)((GeometryJTS)primitive).getJTS();
                polygons.add(polygon);
                continue;
            }
            try {
                MultiPolygon multipolygon = primitive.toPolygons();
                for (int j = 0; j < multipolygon.getPrimitivesNumber(); ++j) {
                    polygon = (Polygon)((GeometryJTS)multipolygon.getPrimitiveAt(j)).getJTS();
                    polygons.add(polygon);
                }
            }
            catch (GeometryException e) {
                GeometryType geomType = primitive.getGeometryType();
                LOGGER.warn(StringUtils.replaceEach((String)"Can't convert primitive type=%(type)s, %(subtype)s to MultiPolygon", (String[])new String[]{"%(type)s", "%(subtype)s"}, (String[])new String[]{String.valueOf(geomType.getType()), String.valueOf(geomType.getSubType())}));
            }
        }
        return JTSUtils.createJTSMultiPolygon(this.getProjection(), polygons.toArray(new Polygon[polygons.size()]));
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiSurface result = new DefaultMultiSurface(this.getGeometryType());
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(distance);
            if (offset instanceof MultiPrimitive) {
                MultiPrimitive multiOffset = (MultiPrimitive)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            result.addPrimitive((Primitive)primitive.offset(distance));
        }
        return result;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        DefaultMultiSurface result = new DefaultMultiSurface(this.getGeometryType());
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(joinStyle, distance);
            if (offset instanceof MultiPrimitive) {
                MultiPrimitive multiOffset = (MultiPrimitive)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            result.addPrimitive((Primitive)primitive.offset(joinStyle, distance));
        }
        return result;
    }
}

