/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.coerce;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryCoercionContext;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;

public class CoerceToGeometry
extends AbstractCoercion {
    private static GeometryManager manager = null;

    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null) {
            return value;
        }
        int mode = 1;
        GeometryType targetGeometryType = null;
        Geometry sourcegeom = null;
        try {
            Geometry geom;
            if (context instanceof GeometryCoercionContext) {
                GeometryCoercionContext geomContext = (GeometryCoercionContext)context;
                targetGeometryType = geomContext.getGeometryType();
                mode = geomContext.getMode();
            }
            if (value instanceof Geometry) {
                geom = (Geometry)value;
            } else {
                if (value instanceof byte[]) {
                    geom = CoerceToGeometry.getManager().createFrom((byte[])value);
                } else {
                    String wkt = value.toString();
                    if (StringUtils.isBlank((CharSequence)wkt)) {
                        return null;
                    }
                    geom = CoerceToGeometry.getManager().createFrom(value.toString());
                }
                if (geom == null) {
                    switch (mode) {
                        case 1: 
                        case 2: {
                            return null;
                        }
                    }
                    throw new CoercionException();
                }
            }
            if (targetGeometryType == null) {
                return geom;
            }
            sourcegeom = geom;
            if (geom.getGeometryType().equals(targetGeometryType)) {
                return geom;
            }
            switch (targetGeometryType.getType()) {
                case 7: {
                    geom = geom.toPoints();
                    break;
                }
                case 8: {
                    if (geom.getGeometryType().getSubType() == 8) break;
                    geom = geom.toLines();
                    break;
                }
                case 21: {
                    geom = geom.toLines();
                    break;
                }
                case 9: {
                    if (geom.getGeometryType().getSubType() == 9) break;
                    geom = geom.toPolygons();
                    break;
                }
                case 22: {
                    geom = geom.toPolygons();
                    break;
                }
                case 1: {
                    geom = this.convertToPoint(targetGeometryType, geom);
                    break;
                }
                case 2: {
                    if (geom.getGeometryType().getSubType() == 2) break;
                    geom = this.convertToLine(targetGeometryType, geom);
                    break;
                }
                case 18: {
                    geom = this.convertToLine(targetGeometryType, geom);
                    break;
                }
                case 3: {
                    if (geom.getGeometryType().getSubType() == 3) break;
                    geom = this.convertToPolygon(targetGeometryType, geom);
                    break;
                }
                case 19: {
                    geom = this.convertToPolygon(targetGeometryType, geom);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    geom = null;
                }
            }
            if (geom.getGeometryType().getSubType() != targetGeometryType.getSubType()) {
                geom = geom.forceSubtype(targetGeometryType.getSubType());
            }
            if (geom != null) {
                return geom;
            }
            switch (mode) {
                case 1: {
                    return null;
                }
                case 2: {
                    return sourcegeom;
                }
            }
            throw new CoercionException();
        }
        catch (Exception e) {
            switch (mode) {
                case 1: {
                    return null;
                }
                case 2: {
                    return sourcegeom;
                }
            }
            throw new CoercionException();
        }
    }

    private static GeometryManager getManager() {
        if (manager == null) {
            manager = GeometryLocator.getGeometryManager();
        }
        return manager;
    }

    private Geometry convertToPoint(GeometryType geometryType, Geometry geom) {
        try {
            Point target = null;
            MultiPoint points = geom.toPoints();
            if (points.getPrimitivesNumber() == 1) {
                target = (Point)points.getPrimitiveAt(0);
            }
            return target;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Geometry convertToLine(GeometryType geometryType, Geometry geom) {
        try {
            Line target = null;
            MultiLine lines = geom.toLines();
            if (lines.getPrimitivesNumber() == 1) {
                target = (Line)lines.getPrimitiveAt(0);
            }
            return target;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Geometry convertToPolygon(GeometryType geometryType, Geometry geom) {
        try {
            Polygon target = null;
            MultiPolygon polygons = geom.toPolygons();
            if (polygons.getPrimitivesNumber() == 1) {
                target = (Polygon)polygons.getPrimitiveAt(0);
            }
            return target;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

