/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.persistence;

import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractSinglePersistenceFactory;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class GeometryTypePersistenceFactory
extends AbstractSinglePersistenceFactory {
    private static final GeometryManager geometryManager = GeometryLocator.getGeometryManager();
    private static final String DYNCLASS_NAME = "GeometryType";
    private static final String DYNCLASS_DESCRIPTION = "gvSIG Geometry type";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_SUBTYPE = "subtype";

    public GeometryTypePersistenceFactory() {
        super(GeometryType.class, DYNCLASS_NAME, DYNCLASS_DESCRIPTION, null, null);
        DynStruct definition = this.getDefinition();
        definition.addDynFieldInt(FIELD_TYPE).setMandatory(true);
        definition.addDynFieldInt(FIELD_SUBTYPE).setMandatory(true);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        int type = state.getInt(FIELD_TYPE);
        int subType = state.getInt(FIELD_SUBTYPE);
        try {
            return geometryManager.getGeometryType(type, subType);
        }
        catch (GeometryTypeNotSupportedException e) {
            throw new PersistenceException("Error creating the geometry type with type = " + type + ", subType = " + subType, (Throwable)e);
        }
        catch (GeometryException e) {
            throw new PersistenceException("Error creating the geometry type with type = " + type + ", subType = " + subType, (Throwable)e);
        }
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        GeometryType type = (GeometryType)obj;
        state.set(FIELD_TYPE, type.getType());
        state.set(FIELD_SUBTYPE, type.getSubType());
    }
}

