/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.line;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.AbstractLine;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.ReadOnlyCoordinates;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseLine3D
extends AbstractLine {
    private static final long serialVersionUID = -1886715977687661564L;

    public BaseLine3D(int type) {
        super(type, 1);
        this.coordinates = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
    }

    public BaseLine3D(int type, Coordinate[] coordinates) {
        super(type, 1);
        this.initializeCoordinates(coordinates);
    }

    public BaseLine3D(int type, ArrayListCoordinateSequence coordinates) {
        super(type, 1);
        this.coordinates = coordinates;
    }

    private void initializeCoordinates(Coordinate[] coordinates) {
        this.coordinates = new ArrayListCoordinateSequence(new ReadOnlyCoordinates(coordinates));
    }

    public OrientablePrimitive addVertex(double x, double y) {
        return this.addVertex(new Point3D(x, y, 0.0));
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        return this.addVertex(new Point3D(x, y, z));
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3D) {
            return point;
        }
        if (point instanceof Point3DM) {
            return new Point3D(point.getX(), point.getY(), ((Point3DM)point).getM());
        }
        return new Point3D(point.getX(), point.getY(), 0.0);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3D multiPoint = new MultiPoint3D();
        multiPoint.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            multiPoint.addPoint(new Point3D(this.getProjection(), coordinate));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3D multiLine = new MultiLine3D();
        multiLine.addPrimitive(this);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3D multiPolygon = new MultiPolygon3D();
        Polygon3D polygon = new Polygon3D(this.coordinates.toCoordinateArray());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    public Point getVertex(int index) {
        Point3D vertex = new Point3D(this.getProjection(), (Coordinate)this.coordinates.get(index));
        return vertex;
    }
}

