/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.periellipse;

import com.vividsolutions.jts.geom.LineString;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.jts.primitive.curve.periellipse.PeriEllipse2D;
import org.gvsig.fmap.geom.jts.primitive.curve.periellipse.PeriEllipse2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.periellipse.PeriEllipse2DZ;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipse.BaseEllipse2DZ;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.PeriEllipse;
import org.gvsig.fmap.geom.primitive.Point;

public class PeriEllipse2DZM
extends BaseEllipse2DZ
implements PeriEllipse {
    public PeriEllipse2DZM() {
        super(24);
    }

    public Geometry cloneGeometry() {
        PeriEllipse2DZM clone = new PeriEllipse2DZM();
        clone.setPoints(this.init.cloneGeometry(), this.end.cloneGeometry(), this.ydist);
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        ArrayListCoordinateSequence coordinates = this.getJTSCoordinates();
        LineString g = JTSUtils.createJTSLineString(this.getProjection(), coordinates);
        return g.reverse();
    }

    public void setPoints(Point initialPoint, Point endPoint) {
        String message = "Calling deprecated method setPoints of a perimeter of ellipse";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        PeriEllipse clonedEllipse = (PeriEllipse)this.cloneGeometry();
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Point2D center = new Point2D((this.getAxis1Start().getX() + this.getAxis1End().getX()) / 2.0, (this.getAxis1Start().getY() + this.getAxis1End().getY()) / 2.0);
        double axis1Lenght = this.getAxis1Start().distance((Geometry)this.getAxis1End());
        Point clonedAxis1Start = this.getAxis1Start().cloneGeometry();
        Point clonedAxis1End = this.getAxis1End().cloneGeometry();
        double clonedYDist = this.ydist + distance;
        clonedAxis1Start.setX(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getX(), this.getAxis1Start().getX(), axis1Lenght / 2.0 + distance));
        clonedAxis1Start.setY(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getY(), this.getAxis1Start().getY(), axis1Lenght / 2.0 + distance));
        clonedAxis1End.setX(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getX(), this.getAxis1End().getX(), axis1Lenght / 2.0 + distance));
        clonedAxis1End.setY(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getY(), this.getAxis1End().getY(), axis1Lenght / 2.0 + distance));
        clonedEllipse.setPoints(clonedAxis1Start, clonedAxis1End, clonedYDist);
        return clonedEllipse;
    }

    @Override
    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.offset(distance);
    }

    @Override
    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        PeriEllipse2D other = new PeriEllipse2D();
        other.setProjection(this.getProjection());
        other.setPoints(this.init.force2D(), this.end.force2D(), this.ydist);
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        PeriEllipse2DM other = new PeriEllipse2DM();
        other.setProjection(this.getProjection());
        other.setPoints(this.init.force2DM(), this.end.force2DM(), this.ydist);
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        PeriEllipse2DZ other = new PeriEllipse2DZ();
        other.setProjection(this.getProjection());
        other.setPoints(this.init.force3D(), this.end.force3D(), this.ydist);
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Geometry c = this.cloneGeometry();
        return c;
    }
}

