/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.spline;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.AbstractSpline;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.ReadOnlyCoordinates;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseSpline3D
extends AbstractSpline {
    private static final long serialVersionUID = 6699898811455152758L;

    public BaseSpline3D(int type) {
        super(type, 1);
        this.coordinates = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
    }

    public BaseSpline3D(int type, Coordinate[] coordinates) {
        super(type, 1);
        this.coordinates = new ArrayListCoordinateSequence(new ReadOnlyCoordinates(coordinates));
        this.anyVertex = coordinates.length < 1 ? new Point3D(0.0, 0.0, 0.0) : new Point3D(coordinates[0].x, coordinates[0].y, coordinates[0].z);
    }

    public BaseSpline3D(int type, ArrayListCoordinateSequence coordinates) {
        super(type, 1);
        this.coordinates = coordinates;
    }

    public OrientablePrimitive addVertex(double x, double y) {
        return this.addVertex(new Point3D(x, y, 0.0));
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        return this.addVertex(new Point3D(x, y, z));
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3D) {
            return point;
        }
        if (point instanceof Point3DM) {
            return new Point3D(point.getX(), point.getY(), ((Point3DM)point).getM());
        }
        return new Point3D(point.getX(), point.getY(), 0.0);
    }

    @Override
    protected ArrayListCoordinateSequence getSplineCoordinates() {
        ArrayListCoordinateSequence splineCoordinates = new ArrayListCoordinateSequence();
        if (splineCoordinates == null || splineCoordinates.size() == 0) {
            int num = this.coordinates.size();
            double[] px = new double[num];
            double[] py = new double[num];
            double[] pz = new double[num];
            for (int i = 0; i < num; ++i) {
                Coordinate coord = (Coordinate)this.coordinates.get(i);
                px[i] = coord.x;
                py[i] = coord.y;
                pz[i] = coord.z;
            }
            AbstractSpline.Spline splineX = new AbstractSpline.Spline(px);
            AbstractSpline.Spline splineY = new AbstractSpline.Spline(py);
            AbstractSpline.Spline splineZ = new AbstractSpline.Spline(pz);
            splineCoordinates.add(this.coordinates.get(0));
            for (int i = 0; i < this.coordinates.size() - 1; ++i) {
                int t = 1;
                while ((double)t <= 30.0) {
                    if ((double)t == 30.0 && i == this.coordinates.size() - 2) {
                        splineCoordinates.add(new Coordinate(px[px.length - 1], py[px.length - 1], pz[px.length - 1]));
                    } else {
                        double x1 = splineX.fn(i, (double)t / 30.0);
                        double y1 = splineY.fn(i, (double)t / 30.0);
                        double z1 = splineZ.fn(i, (double)t / 30.0);
                        splineCoordinates.add(new Coordinate(x1, y1, z1));
                    }
                    ++t;
                }
            }
        }
        return splineCoordinates;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3D multiPoint = new MultiPoint3D();
        Coordinate[] theCoordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(theCoordinates.length);
        for (Coordinate theCoordinate : theCoordinates) {
            multiPoint.addPoint(new Point3D(this.getProjection(), theCoordinate));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3D multiLine = new MultiLine3D();
        Line3D line = new Line3D(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3D multiPolygon = new MultiPolygon3D();
        Polygon3D polygon = new Polygon3D(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    public Point getVertex(int index) {
        Point3D vertex = new Point3D(this.getProjection(), (Coordinate)this.coordinates.get(index));
        this.anyVertex = vertex;
        return vertex;
    }
}

