/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.spline;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.AbstractSpline;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.BaseSpline2DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Spline;

public class Spline2DM
extends BaseSpline2DM
implements Spline {
    private static final long serialVersionUID = 3275115053567971975L;

    public Spline2DM() {
        super(14);
    }

    public Spline2DM(Coordinate[] coordinates) {
        super(14, coordinates);
    }

    public Spline2DM(ArrayListCoordinateSequence coordinates) {
        super(14, coordinates);
    }

    @Override
    public OrientablePrimitive addVertex(double x, double y) {
        return this.addVertex(new Point2DM(x, y, 0.0));
    }

    @Override
    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Can't add x,y,z coordinate to Polygon2DM.";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry cloneGeometry() {
        Spline2DM clone = new Spline2DM(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2DM) {
            return point;
        }
        return new Point2DM(point.getX(), point.getY(), 0.0);
    }

    @Override
    protected ArrayListCoordinateSequence getSplineCoordinates() {
        ArrayListCoordinateSequence splineCoordinates = new ArrayListCoordinateSequence();
        if (splineCoordinates == null || splineCoordinates.size() == 0) {
            int num = this.coordinates.size();
            double[] px = new double[num];
            double[] py = new double[num];
            double[] pm = new double[num];
            for (int i = 0; i < num; ++i) {
                Coordinate coord = (Coordinate)this.coordinates.get(i);
                px[i] = coord.x;
                py[i] = coord.y;
                pm[i] = coord.getOrdinate(3);
            }
            AbstractSpline.Spline splineX = new AbstractSpline.Spline(px);
            AbstractSpline.Spline splineY = new AbstractSpline.Spline(py);
            AbstractSpline.Spline splineM = new AbstractSpline.Spline(pm);
            splineCoordinates.add(this.coordinates.get(0));
            for (int i = 0; i < this.coordinates.size() - 1; ++i) {
                int t = 1;
                while ((double)t <= 30.0) {
                    if ((double)t == 30.0 && i == this.coordinates.size() - 2) {
                        splineCoordinates.add(JTSUtils.createMCoordinate(px[px.length - 1], py[px.length - 1], pm[px.length - 1]));
                    } else {
                        double x1 = splineX.fn(i, (double)t / 30.0);
                        double y1 = splineY.fn(i, (double)t / 30.0);
                        double m1 = splineM.fn(i, (double)t / 30.0);
                        splineCoordinates.add(JTSUtils.createMCoordinate(x1, y1, m1));
                    }
                    ++t;
                }
            }
        }
        return splineCoordinates;
    }

    @Override
    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2DM multiPoint = new MultiPoint2DM();
        Coordinate[] theCoordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(theCoordinates.length);
        for (Coordinate theCoordinate : theCoordinates) {
            multiPoint.addPoint(new Point2DM(this.getProjection(), theCoordinate));
        }
        return multiPoint;
    }

    @Override
    public MultiLine toLines() throws GeometryException {
        MultiLine2DM multiLine = new MultiLine2DM();
        Line2DM line = new Line2DM(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    @Override
    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2DM multiPolygon = new MultiPolygon2DM();
        Polygon2DM polygon = new Polygon2DM(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    public Point getVertex(int index) {
        Point2DM vertex = new Point2DM(this.getProjection(), (Coordinate)this.coordinates.get(index));
        this.anyVertex = vertex;
        return vertex;
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Coordinate[] coords = this.getJTS().getCoordinates();
        ArrayListCoordinateSequence listCoordSequence = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
        listCoordSequence.addAll(Arrays.asList(coords));
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), listCoordSequence, distance);
        }
        return JTSUtils.offsetOpenLine(this.getProjection(), listCoordSequence, distance);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Coordinate[] coords = this.getJTS().getCoordinates();
        ArrayListCoordinateSequence listCoordSequence = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
        for (int i = 0; i < coords.length; ++i) {
            listCoordSequence.add(coords[i]);
        }
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), listCoordSequence, joinStyle, distance);
        }
        return JTSUtils.offsetOpenLine(this.getProjection(), listCoordSequence, joinStyle, distance);
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof Spline2DM) {
            Spline2DM other = (Spline2DM)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                if (((Coordinate)other.coordinates.get(i)).getOrdinate(2) == ((Coordinate)this.coordinates.get(i)).getOrdinate(2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Geometry c = this.cloneGeometry();
        return c;
    }
}

