/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.point;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Arrays;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.DirectPosition;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.handler.AbstractHandler;
import org.gvsig.fmap.geom.handler.FinalHandler;
import org.gvsig.fmap.geom.handler.Handler;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.AbstractPrimitive;
import org.gvsig.fmap.geom.jts.primitive.Envelope2D;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.IsEmpty;
import org.gvsig.tools.util.Size;

public abstract class AbstractPoint
extends AbstractPrimitive
implements PointJTS,
IsEmpty,
Size,
GetItem<Double> {
    private static final long serialVersionUID = -8378193151810866724L;
    protected Coordinate coordinate;

    protected AbstractPoint(int subtype) {
        super(1, subtype);
    }

    public AbstractPoint(int subtype, Coordinate coordinate) {
        this(subtype);
        this.coordinate = coordinate;
    }

    public DirectPosition getDirectPosition() {
        return new PointDirectPosition();
    }

    public void setCoordinateAt(int dimension, double value) {
        this.coordinate.setOrdinate(dimension, value);
    }

    public void setCoordinates(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.coordinate.setOrdinate(i, values[i]);
        }
    }

    public void setX(double x) {
        this.coordinate.x = x;
    }

    public void setY(double y) {
        this.coordinate.y = y;
    }

    public double getCoordinateAt(int dimension) {
        return this.coordinate.getOrdinate(dimension);
    }

    public double[] getCoordinates() {
        double[] coords = new double[this.getDimension()];
        coords[0] = this.getX();
        coords[1] = this.getY();
        if (this.getGeometryType().getSubType() == 2) {
            coords[2] = this.getCoordinateAt(3);
        } else if (this.getGeometryType().getSubType() == 1) {
            coords[2] = this.getCoordinateAt(2);
        } else if (this.getGeometryType().getSubType() == 3) {
            coords[2] = this.getCoordinateAt(2);
            coords[3] = this.getCoordinateAt(3);
        }
        return coords;
    }

    public double getX() {
        return this.coordinate.x;
    }

    public double getY() {
        return this.coordinate.y;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        return JTSUtils.createJTSPoint(this.getProjection(), this.coordinate);
    }

    public void reProject(ICoordTrans ct) {
        if (ct == null) {
            return;
        }
        java.awt.geom.Point2D p = new Point2D.Double(this.getX(), this.getY());
        try {
            p = ct.convert(p, p);
            this.setX(p.getX());
            this.setY(p.getY());
            this.setProjection(ct.getPDest());
        }
        catch (Exception exc) {
            this.setX(0.0);
            this.setY(0.0);
        }
    }

    public void transform(AffineTransform at) {
        if (at == null) {
            return;
        }
        Point2D.Double p = new Point2D.Double(this.getX(), this.getY());
        at.transform(p, p);
        this.setX(((java.awt.geom.Point2D)p).getX());
        this.setY(((java.awt.geom.Point2D)p).getY());
    }

    @Override
    public Coordinate getJTSCoordinate() {
        return this.coordinate;
    }

    public Shape getShape(AffineTransform affineTransform) {
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return new DefaultGeneralPathX(this.getPathIterator(null), false, 0.0);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    @Override
    public Handler[] getHandlers(int type) {
        return new Handler[]{new PointHandler()};
    }

    @Override
    public Envelope getEnvelope() {
        return new Envelope2D(this.getX(), this.getY(), this.getX(), this.getY(), this.getProjection());
    }

    public MultiLine toLines() throws GeometryException {
        String message = "Can't get lines from a point";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public MultiPolygon toPolygons() throws GeometryException {
        String message = "Can't get polygons from a point";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
    }

    @Override
    public abstract String toString();

    public boolean canBeTransformed(AffineTransform at) {
        return true;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        return true;
    }

    public int hashCode() {
        double[] v = this.coordinate instanceof MCoordinate ? new double[]{this.coordinate.x, this.coordinate.y, this.coordinate.z, ((MCoordinate)this.coordinate).m} : new double[]{this.coordinate.x, this.coordinate.y, this.coordinate.z, Double.NaN};
        return Arrays.hashCode(v);
    }

    @Override
    public Point centroid() throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.cloneGeometry();
    }

    public Point clone() throws CloneNotSupportedException {
        return this.cloneGeometry();
    }

    public Point force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point2D p = new Point2D(this.getProjection(), this.coordinate.x, this.coordinate.y);
        return p;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.offset(distance);
    }

    @Override
    public boolean isEmpty() {
        return this.coordinate == null;
    }

    public int size() {
        return this.getDimension();
    }

    public Double get(int position) {
        return this.getCoordinateAt(position);
    }

    class PointHandler
    extends AbstractHandler
    implements FinalHandler {
        public PointHandler() {
            this.point = new Point2D.Double(AbstractPoint.this.getX(), AbstractPoint.this.getY());
            this.index = 0;
        }

        public void move(double movex, double movey) {
            AbstractPoint.this.setX(AbstractPoint.this.getX() + movex);
            AbstractPoint.this.setY(AbstractPoint.this.getY() + movey);
        }

        public void set(double setx, double sety) {
            AbstractPoint.this.setX(setx);
            AbstractPoint.this.setY(sety);
        }
    }

    class PointDirectPosition
    implements DirectPosition {
        PointDirectPosition() {
        }

        public int getDimension() {
            return AbstractPoint.this.getDimension();
        }

        public double getOrdinate(int dimension) {
            return AbstractPoint.this.getCoordinateAt(dimension);
        }
    }
}

