/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.point;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.point.AbstractPoint;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.PointM;
import org.gvsig.fmap.geom.type.GeometryType;

public class Point2DM
extends AbstractPoint
implements PointM {
    private static final long serialVersionUID = 7829655161985732518L;

    public Point2DM(IProjection proj, Coordinate coordinates) {
        super(2, MCoordinate.convertCoordinate(coordinates));
        this.setProjection(proj);
    }

    public Point2DM() {
        this(null, (Coordinate)JTSUtils.createMCoordinate(0.0, 0.0, 0.0));
    }

    public Point2DM(double x, double y, double m) {
        this(null, (Coordinate)JTSUtils.createMCoordinate(x, y, m));
    }

    public Point2DM(IProjection proj, double x, double y, double m) {
        this(proj, (Coordinate)JTSUtils.createMCoordinate(x, y, m));
    }

    public double getM() {
        return ((MCoordinate)this.coordinate).m;
    }

    public void setM(double m) {
        ((MCoordinate)this.coordinate).m = m;
    }

    public int getDimension() {
        return 3;
    }

    @Override
    public GeometryType getGeometryType() {
        try {
            return GeometryLocator.getGeometryManager().getGeometryType(1, 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Point cloneGeometry() {
        Point2DM clone = new Point2DM(this.getProjection(), (Coordinate)MCoordinate.convertCoordinate((Coordinate)this.coordinate.clone()));
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    public double getCoordinateAt(int dimension) {
        if (dimension == 2) {
            return this.getM();
        }
        return super.getCoordinateAt(dimension);
    }

    @Override
    public void setCoordinateAt(int dimension, double value) {
        if (dimension == 2) {
            this.coordinate.setOrdinate(3, value);
            return;
        }
        this.coordinate.setOrdinate(dimension, value);
    }

    @Override
    public boolean is3D() {
        return false;
    }

    @Override
    public void setJTSCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(new PointIterator(null), false, 0.0);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        PointIterator pi = new PointIterator(at);
        return pi;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        return hash;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2DM multiPoint = new MultiPoint2DM();
        multiPoint.addPoint(this);
        return multiPoint;
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("POINT M (");
        for (int i = 0; i < this.getDimension() - 1; ++i) {
            builder.append(this.getCoordinateAt(i));
            builder.append(" ");
        }
        builder.append(this.getCoordinateAt(this.getDimension() - 1));
        builder.append(")");
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        Point other;
        if (obj == null) {
            return false;
        }
        try {
            other = (Point)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (this.getGeometryType().getSubType() != other.getGeometryType().getSubType()) {
            return false;
        }
        if (this.coordinate.x != other.getX()) {
            return false;
        }
        if (this.coordinate.y != other.getY()) {
            return false;
        }
        return ((MCoordinate)this.coordinate).m == other.getCoordinateAt(2);
    }

    public Point force3D() {
        Point3D p = new Point3D(this.getProjection(), this.coordinate.x, this.coordinate.y, 0.0);
        return p;
    }

    public Point force2DM() {
        Point2DM p = new Point2DM(this.getProjection(), this.coordinate.x, this.coordinate.y, ((MCoordinate)this.coordinate).m);
        return p;
    }

    public Point force3DM() {
        Point3DM p = new Point3DM(this.getProjection(), this.coordinate.x, this.coordinate.y, 0.0, ((MCoordinate)this.coordinate).m);
        return p;
    }

    public class PointIterator
    extends GeneralPathXIterator {
        private final AffineTransform at;
        private boolean done;

        public PointIterator(AffineTransform at) {
            super((IGeneralPathX)new GeneralPathX());
            if (at == null) {
                at = new AffineTransform();
            }
            this.at = at;
            this.done = Point2DM.this.isEmpty();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            this.done = true;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public int currentSegment(double[] coords) {
            coords[0] = Point2DM.this.getX();
            coords[1] = Point2DM.this.getY();
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }

        @Override
        public int currentSegment(float[] coords) {
            coords[0] = (float)Point2DM.this.getX();
            coords[1] = (float)Point2DM.this.getY();
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }
    }
}

