/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.circle;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import org.cresques.cts.CoordTransRuntimeException;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.AbstractSurface;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.Circle2D;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.Circle2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.Circle2DZ;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.Circle2DZM;
import org.gvsig.fmap.geom.jts.util.UtilFunctions;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.tools.exception.BaseException;

public abstract class AbstractCircle
extends AbstractSurface {
    private static final long serialVersionUID = -5509291843865895995L;
    protected Point center;
    protected double radius;

    public AbstractCircle(int type, int subtype) {
        super(type, subtype);
    }

    protected AbstractCircle(int type, int subtype, Point center, double radius) {
        this(type, subtype);
        this.setCenter(center);
        this.setRadius(radius);
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Circle2D other = new Circle2D(this.center.force2D(), this.radius);
        other.setProjection(this.getProjection());
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Circle2DM other = new Circle2DM(this.center.force2DM(), this.radius);
        other.setProjection(this.getProjection());
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Circle2DZ other = new Circle2DZ(this.center.force3D(), this.radius);
        other.setProjection(this.getProjection());
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Circle2DZM other = new Circle2DZM(this.center.force3DM(), this.radius);
        other.setProjection(this.getProjection());
        return other;
    }

    protected abstract Point fixPoint(Point var1);

    public void setCenter(Point center) {
        this.center = this.fixPoint(center);
    }

    public Point getCenter() {
        return this.center;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadious() {
        return this.radius;
    }

    public int getDimension() {
        return this.center.getDimension();
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public void setPoints(Point center, Point radius) {
        this.setCenter(center);
        this.radius = ((PointJTS)radius).getJTSCoordinate().distance(((PointJTS)this.center).getJTSCoordinate());
    }

    public void setPoints(Point center, double radius) {
        this.setCenter(center);
        this.radius = radius;
    }

    @Override
    public boolean is3D() {
        return ((PointJTS)this.center).is3D();
    }

    public double getCoordinateAt(int index, int dimension) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive setCoordinateAt(int index, int dimension, double value) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(Point point) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(double x, double y) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeVertex(int index) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Point getVertex(int index) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public int getNumVertices() {
        String message = "Calling deprecated method getNumVertices of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive insertVertex(int index, Point p) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive setVertex(int index, Point p) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void setGeneralPath(GeneralPathX generalPathX) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addMoveToVertex(Point point) {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void closePrimitive() {
        String message = "Calling deprecated method setPoints of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive ensureCapacity(int capacity) {
        String message = "Calling deprecated method ensureCapacity of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Shape getShape(AffineTransform affineTransform) {
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return this.getShape(null);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPathIterator(at, this.getManager().getFlatness());
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        Point2D.Double center = new Point2D.Double(this.center.getX(), this.center.getY());
        Arc2D arco = UtilFunctions.createCircle(center, this.radius);
        return arco.getPathIterator(at, flatness);
    }

    public GeneralPathX getGeneralPath() {
        DefaultGeneralPathX gp = new DefaultGeneralPathX(this.getPathIterator(null, this.getManager().getFlatness()), this.is3D(), 0.0);
        return gp;
    }

    public int getNumInteriorRings() {
        String message = "Calling deprecated method getNumInteriorRings of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Ring getInteriorRing(int index) {
        String message = "Calling deprecated method getInteriorRing of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Ring ring) {
        String message = "Calling deprecated method addInteriorRing of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Line ring) {
        String message = "Calling deprecated method addInteriorRing of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Polygon polygon) {
        String message = "Calling unsupported method addInteriorRing of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeInteriorRing(int index) {
        String message = "Calling deprecated method removeInteriorRing of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public List<Ring> getInteriorRings() {
        String message = "Calling method getInteriorRings of a circle";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void reProject(ICoordTrans ct) {
        Point2D aux = new Point2D(this.center.getX(), this.center.getY() - this.radius);
        try {
            this.center.reProject(ct);
            aux.reProject(ct);
            this.setProjection(ct.getPDest());
        }
        catch (CoordTransRuntimeException e) {
            this.center.setX(0.0);
            this.center.setY(0.0);
            this.radius = 0.0;
            return;
        }
        try {
            this.radius = this.center.distance((Geometry)aux);
        }
        catch (BaseException e) {
            throw new UnsupportedOperationException("Error calculating the radius of the transformed circle.", e);
        }
    }

    public void transform(AffineTransform at) {
        Point2D aux = new Point2D(this.center.getX(), this.center.getY() - this.radius);
        this.center.transform(at);
        aux.transform(at);
        try {
            this.radius = this.center.distance((Geometry)aux);
        }
        catch (BaseException e) {
            throw new UnsupportedOperationException("Error calculating the radius of the transformed circle.", e);
        }
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
    }

    public boolean canBeTransformed(AffineTransform at) {
        return false;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        return false;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.offset(distance);
    }

    @Override
    public boolean isEmpty() {
        return this.center == null || Double.isNaN(this.radius);
    }
}

