/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.ellipticarc;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import org.cresques.cts.CoordTransRuntimeException;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.AbstractSurface;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipticarc.EllipticArc2D;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipticarc.EllipticArc2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipticarc.EllipticArc2DZ;
import org.gvsig.fmap.geom.jts.primitive.surface.ellipticarc.EllipticArc2DZM;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.UtilFunctions;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.EllipticArc;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.tools.exception.BaseException;

public abstract class AbstractEllipticArc
extends AbstractSurface {
    private static final long serialVersionUID = 6163269454714321454L;
    protected Point axis1Start;
    protected Point axis1End;
    protected double semiAxis2Length;
    protected double angSt;
    protected double angExt;

    protected AbstractEllipticArc(int type, int subtype) {
        super(type, subtype);
    }

    public int getNumInteriorRings() {
        String message = "Calling deprecated method getInteriorRing of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Ring getInteriorRing(int index) {
        String message = "Calling deprecated method getInteriorRing of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Ring ring) {
        String message = "Calling unsupported method addInteriorRing of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Line ring) {
        String message = "Calling unsupported method addInteriorRing of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Polygon polygon) {
        String message = "Calling unsupported method addInteriorRing of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeInteriorRing(int index) {
        String message = "Calling unsupported method removeInteriorRing of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public List<Ring> getInteriorRings() {
        String message = "Calling method getInteriorRings of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public double getCoordinateAt(int index, int dimension) {
        String message = "Calling deprecated method getCoordinateAt of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive setCoordinateAt(int index, int dimension, double value) {
        String message = "Calling deprecated method setCoordinateAt of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(Point point) {
        String message = "Calling deprecated method addVertex of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(double x, double y) {
        String message = "Calling deprecated method addVertex of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Calling deprecated method addVertex of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeVertex(int index) {
        String message = "Calling deprecated method removeVertex of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Point getVertex(int index) {
        String message = "Calling deprecated method getVertex of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public int getNumVertices() {
        String message = "Calling deprecated method getNumVertices of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive insertVertex(int index, Point p) {
        String message = "Calling deprecated method insertVertex of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive setVertex(int index, Point p) {
        String message = "Calling deprecated method setVertex of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void setGeneralPath(GeneralPathX generalPathX) {
        String message = "Calling deprecated method setGeneralPath of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addMoveToVertex(Point point) {
        String message = "Calling deprecated method addMoveToVertex of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void closePrimitive() {
        String message = "Calling deprecated method closePrimitive of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public OrientablePrimitive ensureCapacity(int capacity) {
        String message = "Calling deprecated method ensureCapacity of a ellipticArc";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void reProject(ICoordTrans ct) {
        Point2D aux = new Point2D(this.getProjection(), JTSUtils.getPointAtYAxisInEllipse(this.axis1Start, this.axis1End, this.semiAxis2Length));
        try {
            this.axis1Start.reProject(ct);
            this.axis1End.reProject(ct);
            aux.reProject(ct);
            this.setProjection(ct.getPDest());
        }
        catch (CoordTransRuntimeException e) {
            this.axis1Start.setX(0.0);
            this.axis1Start.setY(0.0);
            this.axis1End.setX(0.0);
            this.axis1End.setY(0.0);
            this.semiAxis2Length = 0.0;
        }
        try {
            Point2D transformedMiddlePoint = new Point2D(this.getProjection(), JTSUtils.getMidPoint(this.axis1Start, this.axis1End));
            this.semiAxis2Length = transformedMiddlePoint.distance(aux);
        }
        catch (BaseException e) {
            throw new UnsupportedOperationException("Error calculating the radius of the transformed circle.", e);
        }
    }

    public void transform(AffineTransform at) {
        Point2D aux = new Point2D(this.getProjection(), JTSUtils.getPointAtYAxisInEllipse(this.axis1Start, this.axis1End, this.semiAxis2Length));
        this.axis1Start.transform(at);
        this.axis1End.transform(at);
        aux.transform(at);
        try {
            Point2D transformedMiddlePoint = new Point2D(this.getProjection(), JTSUtils.getMidPoint(this.axis1Start, this.axis1End));
            this.semiAxis2Length = transformedMiddlePoint.distance(aux);
        }
        catch (BaseException e) {
            throw new UnsupportedOperationException("Error calculating the minor semi-axis of the transformed ellipse.", e);
        }
    }

    public int getDimension() {
        return this.axis1Start.getDimension();
    }

    public Shape getShape(AffineTransform affineTransform) {
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return this.getShape(null);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPathIterator(at, this.getManager().getFlatness());
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            double axis1Lenght = this.axis1Start.distance((Geometry)this.axis1End);
            Point2D.Double center = new Point2D.Double((this.axis1Start.getX() + this.axis1End.getX()) / 2.0, (this.axis1Start.getY() + this.axis1End.getY()) / 2.0);
            double x = ((java.awt.geom.Point2D)center).getX() - axis1Lenght / 2.0;
            double y = ((java.awt.geom.Point2D)center).getY() - this.semiAxis2Length;
            double angle = UtilFunctions.getAngle(center, new Point2D.Double(this.axis1Start.getX(), this.axis1Start.getY()));
            Arc2D.Double arc = new Arc2D.Double(x, y, axis1Lenght, 2.0 * this.semiAxis2Length, Math.toDegrees(this.angSt), Math.toDegrees(this.angExt), 1);
            AffineTransform mT = AffineTransform.getRotateInstance(angle, ((java.awt.geom.Point2D)center).getX(), ((java.awt.geom.Point2D)center).getY());
            return arc.getPathIterator(null, geomManager.getFlatness());
        }
        catch (BaseException e) {
            throw new UnsupportedOperationException("Error calculating the radius of the transformed circle.", e);
        }
    }

    public GeneralPathX getGeneralPath() {
        DefaultGeneralPathX gp = new DefaultGeneralPathX(this.getPathIterator(null, this.getManager().getFlatness()), this.is3D(), 0.0);
        return gp;
    }

    @Override
    public boolean is3D() {
        return ((PointJTS)this.axis1Start).is3D();
    }

    protected abstract Point fixPoint(Point var1);

    public void setPoints(Point axis1Start, Point axis1End, double axis2Length, double angSt, double angExt) {
        this.axis1Start = this.fixPoint(axis1Start);
        this.axis1End = this.fixPoint(axis1End);
        this.semiAxis2Length = axis2Length;
        this.angSt = angSt;
        this.angExt = angExt;
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        EllipticArc2D other = new EllipticArc2D();
        Point theAxis1Start = this.axis1Start.force2D();
        Point theAxis1End = this.axis1End.force2D();
        other.setPoints(theAxis1Start, theAxis1End, this.semiAxis2Length, this.angSt, this.angExt);
        other.setProjection(this.getProjection());
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        EllipticArc2DM other = new EllipticArc2DM();
        Point theAxis1Start = this.axis1Start.force2DM();
        Point theAxis1End = this.axis1End.force2DM();
        other.setPoints(theAxis1Start, theAxis1End, this.semiAxis2Length, this.angSt, this.angExt);
        other.setProjection(this.getProjection());
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        EllipticArc2DZ other = new EllipticArc2DZ();
        Point theAxis1Start = this.axis1Start.force3D();
        Point theAxis1End = this.axis1End.force3D();
        other.setPoints(theAxis1Start, theAxis1End, this.semiAxis2Length, this.angSt, this.angExt);
        other.setProjection(this.getProjection());
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        EllipticArc2DZM other = new EllipticArc2DZM();
        Point theAxis1Start = this.axis1Start.force3DM();
        Point theAxis1End = this.axis1End.force3DM();
        other.setPoints(theAxis1Start, theAxis1End, this.semiAxis2Length, this.angSt, this.angExt);
        other.setProjection(this.getProjection());
        return other;
    }

    public Point getAxis1Start() {
        return this.axis1Start;
    }

    public Point getAxis1End() {
        return this.axis1End;
    }

    public double getAxis2Dist() {
        return this.semiAxis2Length;
    }

    public double getAngSt() {
        return this.angSt;
    }

    public double getAngExt() {
        return this.angExt;
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        EllipticArc cloned = (EllipticArc)this.cloneGeometry();
        Point2D center = new Point2D((this.getAxis1Start().getX() + this.getAxis1End().getX()) / 2.0, (this.getAxis1Start().getY() + this.getAxis1End().getY()) / 2.0);
        double axis1Lenght = this.getAxis1Start().distance((Geometry)this.getAxis1End());
        Point clonedAxis1Start = this.getAxis1Start().cloneGeometry();
        Point clonedAxis1End = this.getAxis1End().cloneGeometry();
        double clonedYDist = this.semiAxis2Length + distance;
        clonedAxis1Start.setX(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getX(), this.getAxis1Start().getX(), axis1Lenght / 2.0 + distance));
        clonedAxis1Start.setY(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getY(), this.getAxis1Start().getY(), axis1Lenght / 2.0 + distance));
        clonedAxis1End.setX(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getX(), this.getAxis1End().getX(), axis1Lenght / 2.0 + distance));
        clonedAxis1End.setY(JTSUtils.straightLineThroughTwoPointsEquation(0.0, axis1Lenght / 2.0, center.getY(), this.getAxis1End().getY(), axis1Lenght / 2.0 + distance));
        cloned.setPoints(clonedAxis1Start, clonedAxis1End, clonedYDist, this.angSt, this.angExt);
        return cloned;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return this.offset(distance);
    }

    public boolean canBeTransformed(AffineTransform at) {
        return false;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.axis1Start == null || this.axis1End == null || Double.isNaN(this.angExt) || Double.isNaN(this.angSt) || Double.isNaN(this.semiAxis2Length);
    }
}

