/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.polygon;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.util.JTSUtils2;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.locationtech.jts.coverage.CoverageGapFinder;
import org.locationtech.jts.coverage.CoveragePolygonValidator;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;

public class PolygonHelper {
    public static Shape getShape(org.gvsig.fmap.geom.primitive.Polygon polygon, AffineTransform affineTransform) {
        if (polygon.isEmpty()) {
            return new GeneralPath();
        }
        int capacity = polygon.getNumVertices();
        for (int i = 0; i < polygon.getNumInteriorRings(); ++i) {
            capacity += polygon.getInteriorRing(i).getNumVertices();
        }
        return new DefaultGeneralPathX(polygon.getPathIterator(affineTransform), false, 0.0, capacity);
    }

    public static Geometry validateCoverage(org.gvsig.fmap.geom.primitive.Polygon target, Geometry[] geoms, double gapWidth) {
        Polygon target2 = JTSUtils2.createJTSPolygon(target.getProjection(), (OrientablePrimitive)target.getExteriorRing(), target.getInteriorRings());
        return PolygonHelper.validateCoverage((org.locationtech.jts.geom.Geometry)target2, geoms, gapWidth);
    }

    public static Geometry validateCoverage(MultiPolygon target, Geometry[] geoms, double gapWidth) {
        GeometryCollection target2 = JTSUtils2.createJTSCollection(target);
        return PolygonHelper.validateCoverage((org.locationtech.jts.geom.Geometry)target2, geoms, gapWidth);
    }

    private static Geometry validateCoverage(org.locationtech.jts.geom.Geometry target2, Geometry[] geoms, double gapWidth) {
        ArrayList<Polygon> geoms2 = new ArrayList<Polygon>();
        IProjection proj = null;
        for (Geometry geom1 : geoms) {
            if (geom1 instanceof org.gvsig.fmap.geom.primitive.Polygon) {
                org.gvsig.fmap.geom.primitive.Polygon geom = (org.gvsig.fmap.geom.primitive.Polygon)geom1;
                if (proj == null) {
                    proj = geom.getProjection();
                }
                geoms2.add(JTSUtils2.createJTSPolygon(geom.getProjection(), (OrientablePrimitive)geom.getExteriorRing(), geom.getInteriorRings()));
                continue;
            }
            if (!(geom1 instanceof MultiPolygon)) continue;
            for (Geometry geom0 : (MultiPolygon)geom1) {
                org.gvsig.fmap.geom.primitive.Polygon geom = (org.gvsig.fmap.geom.primitive.Polygon)geom0;
                if (proj == null) {
                    proj = geom.getProjection();
                }
                geoms2.add(JTSUtils2.createJTSPolygon(geom.getProjection(), (OrientablePrimitive)geom.getExteriorRing(), geom.getInteriorRings()));
            }
        }
        org.locationtech.jts.geom.Geometry gap2 = CoveragePolygonValidator.validate((org.locationtech.jts.geom.Geometry)target2, (org.locationtech.jts.geom.Geometry[])geoms2.toArray(new org.locationtech.jts.geom.Geometry[geoms2.size()]), (double)gapWidth);
        return JTSUtils2.createGeometry(proj, gap2);
    }

    public static Geometry findGaps(org.gvsig.fmap.geom.primitive.Polygon polygon, double gapWidth) {
        Polygon target2 = JTSUtils2.createJTSPolygon(polygon);
        return PolygonHelper.findGaps(polygon.getProjection(), (org.locationtech.jts.geom.Geometry)target2, gapWidth);
    }

    public static Geometry findGaps(MultiPolygon target, double gapWidth) {
        GeometryCollection target2 = JTSUtils2.createJTSCollection(target);
        return PolygonHelper.findGaps(target.getProjection(), (org.locationtech.jts.geom.Geometry)target2, gapWidth);
    }

    private static Geometry findGaps(IProjection proj, org.locationtech.jts.geom.Geometry target2, double gapWidth) {
        org.locationtech.jts.geom.Geometry gap2 = CoverageGapFinder.findGaps((org.locationtech.jts.geom.Geometry[])new org.locationtech.jts.geom.Geometry[]{target2}, (double)gapWidth);
        return JTSUtils2.createGeometry(proj, gap2);
    }
}

