/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.transform;

import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.transform.Transform;

public class Transform3D
implements Transform {
    public static final double ACCURACY = 1.0E-12;
    protected double m00;
    protected double m01;
    protected double m02;
    protected double m03;
    protected double m10;
    protected double m11;
    protected double m12;
    protected double m13;
    protected double m20;
    protected double m21;
    protected double m22;
    protected double m23;

    public Transform3D() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
    }

    public Transform3D(double[] coefs) {
        if (coefs.length == 9) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m10 = coefs[3];
            this.m11 = coefs[4];
            this.m12 = coefs[5];
            this.m20 = coefs[6];
            this.m21 = coefs[7];
            this.m22 = coefs[8];
        } else if (coefs.length == 12) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m03 = coefs[3];
            this.m10 = coefs[4];
            this.m11 = coefs[5];
            this.m12 = coefs[6];
            this.m13 = coefs[7];
            this.m20 = coefs[8];
            this.m21 = coefs[9];
            this.m22 = coefs[10];
            this.m23 = coefs[11];
        } else {
            throw new IllegalArgumentException("Input array must have 9 or 12 elements");
        }
    }

    public Transform3D(double xx, double yx, double zx, double tx, double xy, double yy, double zy, double ty, double xz, double yz, double zz, double tz) {
        this.m00 = xx;
        this.m01 = yx;
        this.m02 = zx;
        this.m03 = tx;
        this.m10 = xy;
        this.m11 = yy;
        this.m12 = zy;
        this.m13 = ty;
        this.m20 = xz;
        this.m21 = yz;
        this.m22 = zz;
        this.m23 = tz;
    }

    private Point createPoint3D(double x, double y, double z) {
        try {
            Point point = GeometryLocator.getGeometryManager().createPoint(x, y, 0);
            point.setCoordinateAt(2, z);
            return point;
        }
        catch (CreateGeometryException ex) {
            throw new RuntimeException("Can't create Point3D", ex);
        }
    }

    public boolean isIdentity() {
        if (this.m00 != 1.0) {
            return false;
        }
        if (this.m11 != 1.0) {
            return false;
        }
        if (this.m22 != 0.0) {
            return false;
        }
        if (this.m01 != 0.0) {
            return false;
        }
        if (this.m02 != 0.0) {
            return false;
        }
        if (this.m03 != 0.0) {
            return false;
        }
        if (this.m10 != 0.0) {
            return false;
        }
        if (this.m12 != 0.0) {
            return false;
        }
        if (this.m13 != 0.0) {
            return false;
        }
        if (this.m20 != 0.0) {
            return false;
        }
        if (this.m21 != 0.0) {
            return false;
        }
        return this.m23 == 0.0;
    }

    public double[] coefficients() {
        double[] tab = new double[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23};
        return tab;
    }

    private double determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) - this.m01 * (this.m10 * this.m22 - this.m20 * this.m12) + this.m02 * (this.m10 * this.m21 - this.m20 * this.m11);
    }

    public Transform3D inverse() {
        double det = this.determinant();
        return new Transform3D((this.m11 * this.m22 - this.m21 * this.m12) / det, (this.m21 * this.m02 - this.m01 * this.m22) / det, (this.m01 * this.m12 - this.m11 * this.m02) / det, (this.m01 * (this.m22 * this.m13 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m21 * this.m13) - this.m03 * (this.m11 * this.m22 - this.m21 * this.m12)) / det, (this.m20 * this.m12 - this.m10 * this.m22) / det, (this.m00 * this.m22 - this.m20 * this.m02) / det, (this.m10 * this.m02 - this.m00 * this.m12) / det, (this.m00 * (this.m12 * this.m23 - this.m22 * this.m13) - this.m02 * (this.m10 * this.m23 - this.m20 * this.m13) + this.m03 * (this.m10 * this.m22 - this.m20 * this.m12)) / det, (this.m10 * this.m21 - this.m20 * this.m11) / det, (this.m20 * this.m01 - this.m00 * this.m21) / det, (this.m00 * this.m11 - this.m10 * this.m01) / det, (this.m00 * (this.m21 * this.m13 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m20 * this.m13) - this.m03 * (this.m10 * this.m21 - this.m20 * this.m11)) / det);
    }

    public Transform concatenate(Transform other) {
        if (!(other instanceof Transform3D)) {
            throw new IllegalArgumentException("Can't concatenate an AffineTransform3D with a non AffineTransform2D (other " + other.toString() + ")");
        }
        Transform3D that = (Transform3D)other;
        double n00 = this.m00 * that.m00 + this.m01 * that.m10 + this.m02 * that.m20;
        double n01 = this.m00 * that.m01 + this.m01 * that.m11 + this.m02 * that.m21;
        double n02 = this.m00 * that.m02 + this.m01 * that.m12 + this.m02 * that.m22;
        double n03 = this.m00 * that.m03 + this.m01 * that.m13 + this.m02 * that.m23 + this.m03;
        double n10 = this.m10 * that.m00 + this.m11 * that.m10 + this.m12 * that.m20;
        double n11 = this.m10 * that.m01 + this.m11 * that.m11 + this.m12 * that.m21;
        double n12 = this.m10 * that.m02 + this.m11 * that.m12 + this.m12 * that.m22;
        double n13 = this.m10 * that.m03 + this.m11 * that.m13 + this.m12 * that.m23 + this.m13;
        double n20 = this.m20 * that.m00 + this.m21 * that.m10 + this.m22 * that.m20;
        double n21 = this.m20 * that.m01 + this.m21 * that.m11 + this.m22 * that.m21;
        double n22 = this.m20 * that.m02 + this.m21 * that.m12 + this.m22 * that.m22;
        double n23 = this.m20 * that.m03 + this.m21 * that.m13 + this.m22 * that.m23 + this.m23;
        return new Transform3D(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23);
    }

    public Transform3D preConcatenate(Transform other) {
        if (!(other instanceof Transform3D)) {
            throw new IllegalArgumentException("Can't concatenate an AffineTransform3D with a non AffineTransform3D (other " + other.toString() + ")");
        }
        Transform3D that = (Transform3D)other;
        double n00 = that.m00 * this.m00 + that.m01 * this.m10 + that.m02 * this.m20;
        double n01 = that.m00 * this.m01 + that.m01 * this.m11 + that.m02 * this.m21;
        double n02 = that.m00 * this.m02 + that.m01 * this.m12 + that.m02 * this.m22;
        double n03 = that.m00 * this.m03 + that.m01 * this.m13 + that.m02 * this.m23 + that.m03;
        double n10 = that.m10 * this.m00 + that.m11 * this.m10 + that.m12 * this.m20;
        double n11 = that.m10 * this.m01 + that.m11 * this.m11 + that.m12 * this.m21;
        double n12 = that.m10 * this.m02 + that.m11 * this.m12 + that.m12 * this.m22;
        double n13 = that.m10 * this.m03 + that.m11 * this.m13 + that.m12 * this.m23 + that.m13;
        double n20 = that.m20 * this.m00 + that.m21 * this.m10 + that.m22 * this.m20;
        double n21 = that.m20 * this.m01 + that.m21 * this.m11 + that.m22 * this.m21;
        double n22 = that.m20 * this.m02 + that.m21 * this.m12 + that.m22 * this.m22;
        double n23 = that.m20 * this.m03 + that.m21 * this.m13 + that.m22 * this.m23 + that.m23;
        return new Transform3D(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23);
    }

    public Point[] transform(Point[] src, Point[] dst) {
        if (dst == null || dst.length < src.length) {
            dst = new Point[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            Point3D p = (Point3D)src[i];
            dst[i] = this.createPoint3D(p.getX() * this.m00 + p.getY() * this.m01 + p.getZ() * this.m02 + this.m03, p.getX() * this.m10 + p.getY() * this.m11 + p.getZ() * this.m12 + this.m13, p.getX() * this.m20 + p.getY() * this.m21 + p.getZ() * this.m22 + this.m23);
        }
        return dst;
    }

    public Point transform(Point src) {
        Point3D p = (Point3D)src;
        return this.createPoint3D(p.getX() * this.m00 + p.getY() * this.m01 + p.getZ() * this.m02 + this.m03, p.getX() * this.m10 + p.getY() * this.m11 + p.getZ() * this.m12 + this.m13, p.getX() * this.m20 + p.getY() * this.m21 + p.getZ() * this.m22 + this.m23);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Transform3D)) {
            return false;
        }
        double[] tab = ((Transform3D)obj).coefficients();
        if (Math.abs(tab[0] - this.m00) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[1] - this.m01) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[2] - this.m02) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[3] - this.m03) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[4] - this.m10) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[5] - this.m11) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[6] - this.m12) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[7] - this.m13) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[8] - this.m20) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[9] - this.m21) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[10] - this.m22) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(tab[11] - this.m23) > 1.0E-12);
    }
}

